/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.event;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEventAssembler;
import ca.odell.glazedlists.event.ListEventBlock;
import java.util.EventObject;
import java.util.List;

public final class ListEvent
extends EventObject {
    public static final int DELETE = 0;
    public static final int UPDATE = 1;
    public static final int INSERT = 2;
    private int blockCount;
    private ListEventBlock currentBlock = null;
    private int rowIndex;
    private EventList sourceList;
    private ListEventAssembler masterSequence;

    ListEvent(ListEventAssembler masterSequence, EventList sourceList) {
        super(sourceList);
        this.masterSequence = masterSequence;
        this.sourceList = sourceList;
        this.blockCount = 0;
    }

    public ListEvent(ListEvent original) {
        super(original.sourceList);
        this.blockCount = original.blockCount;
        this.currentBlock = original.currentBlock;
        this.rowIndex = original.rowIndex;
        this.masterSequence = original.masterSequence;
        this.sourceList = original.sourceList;
    }

    public void reset() {
        this.currentBlock = null;
        this.blockCount = 0;
    }

    public boolean next() {
        if (this.currentBlock == null || this.rowIndex == this.currentBlock.getEndIndex()) {
            return this.nextBlock();
        }
        if (this.rowIndex >= this.currentBlock.getEndIndex()) {
            throw new IllegalStateException();
        }
        ++this.rowIndex;
        return true;
    }

    public boolean hasNext() {
        if (this.currentBlock == null || this.rowIndex == this.currentBlock.getEndIndex()) {
            return this.blockCount < this.getBlocks().size();
        }
        return true;
    }

    public boolean nextBlock() {
        if (this.blockCount == this.getBlocks().size()) {
            this.currentBlock = null;
            this.rowIndex = -5;
            this.blockCount = 0;
            return false;
        }
        this.currentBlock = (ListEventBlock)this.getBlocks().get(this.blockCount);
        ++this.blockCount;
        this.rowIndex = this.currentBlock.getStartIndex();
        return true;
    }

    public boolean isReordering() {
        return this.masterSequence.getReorderMap() != null;
    }

    public int[] getReorderMap() {
        int[] reorderMap = this.masterSequence.getReorderMap();
        if (reorderMap == null) {
            throw new IllegalStateException("Cannot get reorder map for a non-reordering change");
        }
        return reorderMap;
    }

    public int getIndex() {
        if (this.currentBlock.getType() == 0) {
            return this.currentBlock.getStartIndex();
        }
        return this.rowIndex;
    }

    public int getBlockStartIndex() {
        return this.currentBlock.getStartIndex();
    }

    public int getBlockEndIndex() {
        return this.currentBlock.getEndIndex();
    }

    public int getType() {
        return this.currentBlock.getType();
    }

    List getBlocks() {
        return this.masterSequence.getBlocks();
    }

    public int getBlocksRemaining() {
        if (this.currentBlock != null && this.rowIndex < this.currentBlock.getEndIndex()) {
            return this.getBlocks().size() - this.blockCount + 1;
        }
        return this.getBlocks().size() - this.blockCount;
    }

    public EventList getSourceList() {
        return this.sourceList;
    }

    public String toString() {
        return "ListEvent: " + this.masterSequence.getBlocks();
    }
}

