/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: XclExpPivotTables.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:38:00 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SC_XCLEXPPIVOTTABLES_HXX
#define SC_XCLEXPPIVOTTABLES_HXX

//_________________________________________________________

class ScDPCollection;
class ScDPObject;

//_________________________________________________________

#ifndef _SFXDOCFILE_HXX
#include <bf_sfx2/docfile.hxx>
#endif

#ifndef SC_SCGLOB_HXX
#include "global.hxx"
#endif

#ifndef _ROOT_HXX
#include "root.hxx"
#endif
#ifndef _EXCRECDS_HXX
#include "excrecds.hxx"
#endif
#ifndef _EXCDEFS_HXX
#include "excdefs.hxx"
#endif
namespace binfilter {

//============================================================================
// pivot cache and additional pivot table data

//_________________________________________________________
// XclPivotCacheItem - any cache item

class XclPivotCacheItem
{
private:
protected:
	UINT16						nTypeFlags;

public:
	virtual						~XclPivotCacheItem();

	virtual BOOL				IsDouble() const;
	virtual BOOL				IsString() const;
	virtual BOOL				IsDate() const;
	inline UINT16				GetTypeFlags() const	{ return nTypeFlags; }

	virtual BOOL				operator==( XclPivotCacheItem& rItem ) = 0;

	virtual void				Write( XclExpStream& rStrm ) = 0;
};

//_________________________________________________________
// XclPivotCacheDblItem - double value item

class XclPivotCacheDblItem : public XclPivotCacheItem
{
private:
	double						fVal;

protected:
public:
								XclPivotCacheDblItem( double fNewVal );
	virtual BOOL				IsDouble() const;
	inline double				GetCont() const		{ return fVal; }

	virtual BOOL				operator==( XclPivotCacheItem& rItem );

	virtual void				Write( XclExpStream& rStrm );
};

//_________________________________________________________
// XclPivotCacheStrItem - string item

class XclPivotCacheStrItem : public XclPivotCacheItem
{
private:
	String						sText;

protected:
public:
	inline						XclPivotCacheStrItem( const String& sNewText ) :
									sText( sNewText )	{ nTypeFlags = 0x0480; }

	virtual BOOL				IsString() const;
	inline const String&		GetCont() const		{ return sText; }

	virtual BOOL				operator==( XclPivotCacheItem& rItem );

	virtual void				Write( XclExpStream& rStrm );
};

//_________________________________________________________
// XclPivotCacheDatItem - date/time item

class XclPivotCacheDatItem : public XclPivotCacheItem
{
private:
	UINT16						nYear;
	UINT16						nMonth;
	UINT8						nDay;
	UINT8						nHour;
	UINT8						nMin;
	UINT8						nSec;
	double						fVal;

protected:
public:
								XclPivotCacheDatItem( double fNewDate, RootData* pExcRoot );
	virtual BOOL				IsDate() const;
	inline double				GetCont() const		{ return fVal; }

	virtual BOOL				operator==( XclPivotCacheItem& rItem );

	virtual void				Write( XclExpStream& rStrm );
};

//_________________________________________________________
// XclPivotCacheField - cache field (list of cache items)

class XclPivotCacheField : public ExcRoot, private List
{
private:
	String						sName;
	UINT16						nFlags;
    ScfUInt16List               aIndexList;
	XclPivotCacheItem*			pCurr;				// for _Find()
	UINT16						nIndex;				// for _Find()

	UINT16						nAxis;				// xcl flags
	UINT16						nSubTotalMask;		// xcl flags
	UINT16						nPosition;
    ScfUInt16List               aSubTotalList;
    ScfUInt16List               aDataFuncList;
    ScfUInt16List               aDataPosList;
	BOOL						bShowAllItems;

	inline XclPivotCacheItem*	_First()	{ return (XclPivotCacheItem*) List::First(); }
	inline XclPivotCacheItem*	_Next()		{ return (XclPivotCacheItem*) List::Next(); }
	UINT16						_Find( XclPivotCacheItem& rItem );

	void						WriteFieldHeader( XclExpStream& rStrm );

protected:
public:
								XclPivotCacheField( RootData* pRD, ScRange& rRange );
	virtual						~XclPivotCacheField();

	inline const String&		GetName() const			{ return sName; }
	inline ULONG				GetIndexWidth() const	{ return (nFlags & EXC_SXFIELD_16BIT) ? 2 : 1; }

								List::Count;

	void						Insert( XclPivotCacheItem*& rpItem );

	void						WriteIndex( XclExpStream& rStrm, UINT16 nRow );
	void						Write( XclExpStream& rStrm );

	inline void					AddAxis( UINT16 nAxisFlag )	{ nAxis |= nAxisFlag; }
	inline void					AddDataFunc( UINT16 nFunc )	{ aDataFuncList.Append( nFunc ); }
	void						AddSubTotal( UINT16 nSubT );
	void						SetPosition( UINT16 nPos, UINT16 nAxisFlag );
	inline void					SetShowAll( BOOL bShowAll )	{ bShowAllItems = bShowAll; }

	inline UINT16				GetAxis() const				{ return nAxis; }
	inline UINT16				GetSubTotalCount() const	{ return ( UINT16 ) aSubTotalList.Count(); }
	inline UINT16				GetSubTotalMask() const		{ return nSubTotalMask; }
	inline UINT16				GetSubTotal( UINT16 nIndex ) const
                                                            { return aSubTotalList.GetValue( nIndex ); }
	inline UINT16				GetPosition() const			{ return nPosition; }
	BOOL						IsInDataPosList( UINT16 nPos ) const;
	UINT16						GetFunction( UINT16 nPos ) const;
	inline BOOL					IsShowAll() const			{ return bShowAllItems; }
};

//_________________________________________________________
// XclPivotCache - pivot cache (list of cache fields)

class XclPivotCache : public ExcRoot, private List
{
private:
	UINT16						nIndex;				// 1-based
	ScRange						aSourceRange;
	String						sSourceName;
	UINT16						nSrcRecs;

	UINT16						nColF;
	UINT16						nRowF;
	UINT16						nPageF;
	UINT16						nDataF;
	UINT16						nDataFAxis;
	UINT16						nDataFPos;
	ScRange						aOutRange;
	String						sTableName;
	String						sDataName;
	BOOL						bMultiData;
    bool                        bRowGrand;
    bool                        bColGrand;

    ScfUInt16List               aRowPosList;
    ScfUInt16List               aColPosList;
    ScfUInt16List               aDataPosList;

	inline XclPivotCacheField*	_First()	{ return (XclPivotCacheField*) List::First(); }
	inline XclPivotCacheField*	_Next()		{ return (XclPivotCacheField*) List::Next(); }
	inline XclPivotCacheField*	_Get( UINT16 nIndex )
									{ return (XclPivotCacheField*) List::GetObject( nIndex ); }
	XclPivotCacheField*			_GetByName( const String& rName );

	ULONG						GetIndexRecLen();

	void						WriteCacheHeader( XclExpStream& rStrm );
	void						WriteCacheEnd( XclExpStream& rStrm );
	void						WriteIndexList( XclExpStream& rStrm );

    void                        BuildPosList( ScfUInt16List& rList, UINT16& rCount, UINT16 nAxisFlag );

protected:
public:
								XclPivotCache( RootData* pRD, ScDPObject& rObject, UINT16 nInd );
	virtual						~XclPivotCache();

								List::Count;
	inline const XclPivotCacheField* Get( UINT16 nIndex ) const
									{ return (const XclPivotCacheField*) List::GetObject( nIndex ); }
	inline void					Append( XclPivotCacheField* pField )
									{ List::Insert( pField, LIST_APPEND ); }

	inline UINT16				GetIndex() const		{ return nIndex; }
	inline UINT16				GetSourceType() const	{ return EXC_SXVS_EXCEL; }
	inline const ScRange&		GetRange() const		{ return aSourceRange; }
	inline const String&		GetWorkbook() const		{ return sSourceName; }

	void						Write();

	inline const ScRange&		GetOutRange() const		{ return aOutRange; }
	inline UINT16				GetColFCount() const	{ return nColF; }
	inline UINT16				GetRowFCount() const	{ return nRowF; }
	inline UINT16				GetPageFCount() const	{ return nPageF; }
	inline UINT16				GetDataFCount() const	{ return nDataF; }
	inline UINT16				GetDataFAxis() const	{ return nDataFAxis; }
	inline UINT16				GetDataFPos() const		{ return nDataFPos; }
	inline const String&		GetTableName() const	{ return sTableName; }
	inline const String&		GetDataName() const		{ return sDataName; }
	inline UINT16				GetDataLineCount( UINT16 nAxisFlag ) const
									{ return (nAxisFlag & nDataFAxis) ? nDataF : 1; }

	inline BOOL					HasMultiData() const	{ return bMultiData; }
	inline BOOL					HasMultiData( UINT16 nAxisFlag ) const
									{ return bMultiData && (nDataFAxis & nAxisFlag); }
	BOOL						HasGrandTotal( UINT16 nAxisFlag ) const;

    const ScfUInt16List*        GetPosList( UINT16 nAxisFlag ) const;
};

//_________________________________________________________
// XclPivotCacheList - list of caches

class XclPivotCacheList : public ExcRoot, private List
{
private:
	inline XclPivotCache*		_First()	{ return (XclPivotCache*) List::First(); }
	inline XclPivotCache*		_Next()		{ return (XclPivotCache*) List::Next(); }

protected:
public:
								XclPivotCacheList( RootData* pRD, ScDPCollection& rDPColl );
	virtual						~XclPivotCacheList();

	inline const XclPivotCache*	First()		{ return (const XclPivotCache*) List::First(); }
	inline const XclPivotCache*	Next()		{ return (const XclPivotCache*) List::Next(); }
	inline const XclPivotCache*	Get( UINT16 nInd ) const
									{ return (const XclPivotCache*) List::GetObject( nInd ); }

	inline void					Append( XclPivotCache* pCache )
									{ List::Insert( pCache, LIST_APPEND ); }

	void						Write();
};

//============================================================================
// biff records

//_________________________________________________________
// XclSxIdStm - (0x00D5 SXIDSTM) pivot cache id

class XclSxIdStm : public ExcRecord
{
private:
	UINT16					nIndex;

	virtual void			SaveCont( XclExpStream& rStrm );

public:
	inline					XclSxIdStm( const XclPivotCache& rCache ) :
								nIndex( rCache.GetIndex() )	{}

	virtual UINT16			GetNum() const;
	virtual ULONG			GetLen() const;
};

//_________________________________________________________
// XclSxVs - (0x00E3 SXVS) data source

class XclSxVs : public ExcRecord
{
private:
	UINT16					nSource;

	virtual void			SaveCont( XclExpStream& rStrm );

public:
	inline					XclSxVs( const XclPivotCache& rCache ) :
								nSource( rCache.GetSourceType() )	{}

	virtual UINT16			GetNum() const;
	virtual ULONG			GetLen() const;
};

//_________________________________________________________
// XclSxView - (0x00B0 SXVIEW) pivot table header

class XclSxView : public ExcRecord
{
private:
	UINT16					nIndex;
	ScRange					aOutRange;
	UINT16					nFirstHeading;
	ScAddress				aFirstData;
	UINT16					nFields;
	UINT16					nRowF;
	UINT16					nColF;
	UINT16					nPageF;
	UINT16					nDataF;
	UINT16					nDataFAxis;
	UINT16					nDataFPos;
	UINT16					nDataRows;
	UINT16					nDataCols;
	UINT16					nFlags;

	XclExpUniString			sTableName;
	XclExpUniString			sDataName;

	virtual void			SaveCont( XclExpStream& rStrm );

public:
							XclSxView( const XclPivotCache& rCache, UINT16 nCacheInd );

	inline UINT16			GetDataRows() const		{ return nDataRows; }
	inline UINT16			GetDataCols() const		{ return nDataCols; }

	virtual UINT16			GetNum() const;
	virtual ULONG			GetLen() const;
};

//_________________________________________________________
// XclSxVi - (0x00B2 SXVI) view field item

class XclSxVi : public ExcRecord
{
private:
	UINT16					nItemType;
	UINT16					nCacheInd;

	virtual void			SaveCont( XclExpStream& rStrm );

public:
	inline					XclSxVi( UINT16 nType, UINT16 nCache ) :
								nItemType( nType ), nCacheInd( nCache )	{}

	virtual UINT16			GetNum() const;
	virtual ULONG			GetLen() const;
};

//_________________________________________________________
// XclSxViList - list of view field items

class XclSxViList : private List
{
private:
	inline XclSxVi*			_First()	{ return (XclSxVi*) List::First(); }
	inline XclSxVi*			_Next()		{ return (XclSxVi*) List::Next(); }

public:
							XclSxViList( const XclPivotCacheField& rField );
	virtual					~XclSxViList();

							List::Count;
	inline void				Append( XclSxVi* pSxVi )
								{ List::Insert( pSxVi, LIST_APPEND ); }

	void					Save( XclExpStream& rStrm );
};

//_________________________________________________________
// XclSxVdex - (0x0100 SXVDEX) view field ext. info

class XclSxVdex : public ExcRecord
{
private:
	UINT32					nFlags;

	virtual void			SaveCont( XclExpStream& rStrm );

public:
							XclSxVdex( const XclPivotCacheField& rField );

	virtual UINT16			GetNum() const;
	virtual ULONG			GetLen() const;
};

//_________________________________________________________
// XclSxVd - (0x00B1 SXVD) view field

class XclSxVd : public ExcRecord
{
private:
	UINT16					nAxis;
	UINT16					nSubTotalMask;
	UINT16					nSubTotalCount;

	XclSxViList				aSxViList;
	XclSxVdex				aSxVdex;

	virtual void			SaveCont( XclExpStream& rStrm );

public:
							XclSxVd( const XclPivotCacheField& rField );
	virtual					~XclSxVd();

	virtual void			Save( XclExpStream& rStrm );

	virtual UINT16			GetNum() const;
	virtual ULONG			GetLen() const;
};

//_________________________________________________________
// XclSxVdList - list of view fields

class XclSxVdList : private List
{
private:
	inline XclSxVd*			_First()	{ return (XclSxVd*) List::First(); }
	inline XclSxVd*			_Next()		{ return (XclSxVd*) List::Next(); }

public:
							XclSxVdList( const XclPivotCache& rCache );
	virtual					~XclSxVdList();

	inline void				Append( XclSxVd* pSxVd )
								{ List::Insert( pSxVd, LIST_APPEND ); }

	void					Save( XclExpStream& rStrm );
};

//_________________________________________________________
// XclSxIvd - (0x00B4 SXIVD) index list to view fields

class XclSxIvd : public ExcRecord
{
private:
    ScfUInt16List           aIndexList;

	virtual	void			SaveCont( XclExpStream& rStrm );

public:
							XclSxIvd( const XclPivotCache& rCache, UINT16 nAxis );

	virtual void			Save( XclExpStream& rStrm );

	virtual UINT16			GetNum() const;
	virtual ULONG			GetLen() const;
};

//_________________________________________________________
// XclSxDi - (0x00C5 SXDI) data field

class XclSxDi : public ExcRecord
{
private:
	UINT16					nIndex;
	UINT16					nFunction;
	XclExpUniString			sFieldName;

	virtual void			SaveCont( XclExpStream& rStrm );

public:
	inline					XclSxDi( UINT16 nInd, UINT16 nFunc, const String& rName ) :
								nIndex( nInd ), nFunction( nFunc ), sFieldName( rName )	{}

	virtual UINT16			GetNum() const;
	virtual ULONG			GetLen() const;
};

//_________________________________________________________
// XclSxDiList - list of data items

class XclSxDiList : private List
{
private:
	inline XclSxDi*			_First()	{ return (XclSxDi*) List::First(); }
	inline XclSxDi*			_Next()		{ return (XclSxDi*) List::Next(); }

public:
							XclSxDiList( const XclPivotCache& rCache );
	virtual					~XclSxDiList();

	inline void				Append( XclSxDi* pSxDi )
								{ List::Insert( pSxDi, LIST_APPEND ); }

	void					Save( XclExpStream& rStrm );
};

//_________________________________________________________
// XclSxLi - (0x00B5 SXLI) line item(s) -- dummy --

class XclSxLi : public ExcRecord
{
private:
	UINT16					nLineCount;
	UINT16					nIndCount;

protected:
	virtual void			SaveCont( XclExpStream& rStrm );

public:
							XclSxLi( const XclPivotCache& rCache, UINT16 nAxisFlag, UINT16 nLines );

	virtual UINT16			GetNum() const;
	virtual ULONG			GetLen() const;
};

//_________________________________________________________
// XclSxEx - (0x00F1 SXEX) ext. info

class XclSxEx : public ExcRecord
{
private:
	virtual void			SaveCont( XclExpStream& rStrm );

public:
	virtual UINT16			GetNum() const;
	virtual ULONG			GetLen() const;
};

//_________________________________________________________
// XclPivotTableRecs - contains complete pivot table

class XclPivotTableRecs : public ExcEmptyRec
{
private:
	XclSxView				aSxView;		// SXVIEW
	XclSxVdList				aSxVdList;		// list of SXVD, SXVI, SXVDEX
	XclSxIvd				aSxIvdRow;		// row indexes to SXVD
	XclSxIvd				aSxIvdCol;		// col indexes to SXVD
	XclSxDiList				aSxDiList;		// list of SXDI
	XclSxLi*				pSxLiRow;		// row SXLI
	XclSxLi*				pSxLiCol;		// col SXLI
	XclSxEx					aSxEx;			// SXEX

public:
							XclPivotTableRecs( const XclPivotCache& rCache, UINT16 nCacheInd );
	virtual					~XclPivotTableRecs();

	virtual void			Save( XclExpStream& rStrm );
};



} //namespace binfilter
#endif

