/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_expbase.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 18:07:35 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#include "filt_pch.hxx"
#endif

#pragma hdrstop


#include "expbase.hxx"
#include "document.hxx"
#include "editutil.hxx"
namespace binfilter {


//------------------------------------------------------------------

#if defined(MAC)
const sal_Char __FAR_DATA ScExportBase::sNewLine = '\015';
#elif defined(UNX)
const sal_Char __FAR_DATA ScExportBase::sNewLine = '\012';
#else
const sal_Char __FAR_DATA ScExportBase::sNewLine[] = "\015\012";
#endif


ScExportBase::ScExportBase( SvStream& rStrmP, ScDocument* pDocP,
				const ScRange& rRangeP )
			:
			rStrm( rStrmP ),
			aRange( rRangeP ),
			pDoc( pDocP ),
			pFormatter( pDocP->GetFormatTable() ),
			pEditEngine( NULL )
{
}


ScExportBase::~ScExportBase()
{
	delete pEditEngine;
}


BOOL ScExportBase::GetDataArea( USHORT nTab, USHORT& nStartCol,
			USHORT& nStartRow, USHORT& nEndCol, USHORT& nEndRow ) const
{
	pDoc->GetDataStart( nTab, nStartCol, nStartRow );
	pDoc->GetPrintArea( nTab, nEndCol, nEndRow, TRUE );
	return TrimDataArea( nTab, nStartCol, nStartRow, nEndCol, nEndRow );
}


BOOL ScExportBase::TrimDataArea( USHORT nTab, USHORT& nStartCol,
			USHORT& nStartRow, USHORT& nEndCol, USHORT& nEndRow ) const
{
	while ( nStartCol <= nEndCol &&
			pDoc->GetColFlags( nStartCol, nTab ) & CR_HIDDEN )
		++nStartCol;
	while ( nStartCol <= nEndCol &&
			pDoc->GetColFlags( nEndCol, nTab ) & CR_HIDDEN )
		--nEndCol;
	while ( nStartRow <= nEndRow &&
			pDoc->GetRowFlags( nStartRow, nTab ) & CR_HIDDEN )
		++nStartRow;
	while ( nStartRow <= nEndRow &&
			pDoc->GetRowFlags( nEndRow, nTab ) & CR_HIDDEN )
		--nEndRow;
	return nStartCol <= nEndCol && nStartRow <= nEndRow;
}


BOOL ScExportBase::IsEmptyTable( USHORT nTab ) const
{
	if ( !pDoc->HasTable( nTab ) || !pDoc->IsVisible( nTab ) )
		return TRUE;
	USHORT nStartCol, nStartRow, nEndCol, nEndRow;
	return !GetDataArea( nTab, nStartCol, nStartRow, nEndCol, nEndRow );
}


ScFieldEditEngine& ScExportBase::GetEditEngine() const
{
	if ( !pEditEngine )
		((ScExportBase*)this)->pEditEngine = new ScFieldEditEngine( pDoc->GetEditPool() );
	return *pEditEngine;
}


}
