/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_appreg.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 02:23:56 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _CONFIG_HXX
// auto strip #include <tools/config.hxx>
// auto strip #endif

// auto strip #include <app.hxx>

#pragma hdrstop

// auto strip #include "appdata.hxx"
#include "arrdecl.hxx"
#include "intfrm.hxx"
#include "ipfrm.hxx"
// auto strip #include "fsetobsh.hxx"
// auto strip #include "fsetview.hxx"
#include "tbxcust.hxx"
// auto strip #include "sfxhelp.hxx"
#include "templdlg.hxx"
#include "objmnctl.hxx"
#include "inettbc.hxx"
#include "stbitem.hxx"
// auto strip #include "tbedctrl.hxx"
#include "navigat.hxx"
// auto strip #include "module.hxx"
#include "topfrm.hxx"
#include "appimp.hxx"
#include "mailchildwin.hxx"
#include "partwnd.hxx"
#include "sfxsids.hrc"

#ifndef _SVTOOLS_IMGDEF_HXX
#include <svtools/imgdef.hxx>
#endif

#include "recfloat.hxx"
namespace binfilter {

//===================================================================

/*N*/ void SfxApplication::Registrations_Impl()
/*N*/ {
/*N*/ 	// Interfaces
/*N*/ 	SfxApplication::RegisterInterface();
/*N*/ 	SfxModule::RegisterInterface();
/*N*/ 	SfxViewFrame::RegisterInterface();
/*N*/ 	SfxInternalFrame::RegisterInterface();
/*N*/ 	SfxInPlaceFrame::RegisterInterface();
/*N*/ 	SfxTopViewFrame::RegisterInterface();
/*N*/ 	SfxObjectShell::RegisterInterface();
/*N*/ 	SfxViewShell::RegisterInterface();
/*N*/ 
/*N*/ 	// ChildWindows
/*N*/     SfxRecordingFloatWrapper_Impl::RegisterChildWindow();
/*N*/ 	SfxNavigatorWrapper::RegisterChildWindow();
/*N*/ 	SfxToolboxCustomWindow::RegisterChildWindow();
/*N*/ 	SfxMailChildWinWrapper_Impl::RegisterChildWindow();
/*N*/ 	SfxMailChildWinWrapper_Impl::RegisterChildWindow();
/*N*/     SfxPartChildWnd_Impl::RegisterChildWindow();
/*N*/ 	SfxTemplateDialogWrapper::RegisterChildWindow(TRUE);
/*N*/ 
/*N*/ 	// Controller
/*N*/ 	SfxObjectVerbsControl::RegisterControl(SID_OBJECT);
//STRIP001 /*N*/ 	SfxMenuControl::RegisterControl(SID_QUITAPP);
//STRIP001 /*N*/ 	SfxMenuControl::RegisterControl(SID_SAVEASDOC);
//STRIP001 /*N*/ 	SfxMenuControl::RegisterControl(SID_SAVEDOC);
//STRIP001 /*N*/ 	SfxMenuControl::RegisterControl(SID_OPENDOC);
//STRIP001 /*N*/ 	SfxMenuControl::RegisterControl(SID_CLOSEDOC);
//STRIP001 /*N*/ 	SfxMenuControl::RegisterControl(SID_OBJECTMENU0);
//STRIP001 /*N*/ 	SfxMenuControl::RegisterControl(SID_OBJECTMENU1);
//STRIP001 /*N*/ 	SfxMenuControl::RegisterControl(SID_OBJECTMENU2);
//STRIP001 /*N*/ 	SfxMenuControl::RegisterControl(SID_OBJECTMENU3);
//STRIP001 /*N*/ 	SfxMenuControl::RegisterControl(SID_UNDO);
//STRIP001 /*N*/ 	SfxMenuControl::RegisterControl(SID_REDO);
//STRIP001 /*N*/ 	SfxMenuControl::RegisterControl(SID_REPEAT);
//STRIP001 /*N*/ 	SfxMenuControl::RegisterControl(SID_MAIL_SENDDOC);
//STRIP001 /*N*/ 	SfxAppMenuControl_Impl::RegisterControl( SID_NEWDOCDIRECT );
//STRIP001 /*N*/ 	SfxAppMenuControl_Impl::RegisterControl( SID_AUTOPILOTMENU );
//STRIP001 /*N*/ 	SfxToolBoxControl::RegisterControl(SID_UNDO);
//STRIP001 /*N*/ 	SfxToolBoxControl::RegisterControl(SID_REDO);
//STRIP001 /*N*/ 	SfxToolBoxControl::RegisterControl(SID_REPEAT);
//STRIP001 /*N*/ 	SfxURLToolBoxControl_Impl::RegisterControl(SID_OPENURL);
//STRIP001 /*N*/ 	SfxCancelToolBoxControl_Impl::RegisterControl(SID_BROWSE_STOP);
//STRIP001 /*N*/ 	SfxAppToolBoxControl_Impl::RegisterControl( SID_NEWDOCDIRECT );
//STRIP001 /*N*/ 	SfxAppToolBoxControl_Impl::RegisterControl( SID_AUTOPILOTMENU );
//STRIP001 /*N*/ 	SfxDragToolBoxControl_Impl::RegisterControl( SID_TOPDOC );
//STRIP001 /*N*/ 	SfxHistoryToolBoxControl_Impl::RegisterControl( SID_BROWSE_FORWARD );
//STRIP001 /*N*/ 	SfxHistoryToolBoxControl_Impl::RegisterControl( SID_BROWSE_BACKWARD );
//STRIP001 /*N*/ 	SfxReloadToolBoxControl_Impl::RegisterControl( SID_RELOAD );
//STRIP001 /*N*/ 	SfxAddonsToolBoxControl_Impl::RegisterControl( SID_ADDONS );
/*N*/ };

//--------------------------------------------------------------------

/*N*/ void SfxApplication::RegisterToolBoxControl( SfxModule *pMod, SfxTbxCtrlFactory *pFact )
/*N*/ {
/*N*/ 	if ( pMod )
/*N*/ 	{
/*N*/ 		pMod->RegisterToolBoxControl( pFact );
/*N*/ 		return;
/*N*/ 	}
/*N*/ 
/*N*/ #ifdef DBG_UTIL
/*N*/ 	for ( USHORT n=0; n<pImp->pTbxCtrlFac->Count(); n++ )
/*N*/ 	{
/*N*/ 		SfxTbxCtrlFactory *pF = (*pImp->pTbxCtrlFac)[n];
/*N*/ 		if ( pF->nTypeId && pF->nTypeId == pFact->nTypeId &&
/*N*/ 			(pF->nSlotId == pFact->nSlotId || pF->nSlotId == 0) )
/*N*/ 		{
/*N*/ 			DBG_WARNING("TbxController-Registrierung ist nicht eindeutig!");
/*N*/ 		}
/*N*/ 	}
/*N*/ #endif
/*N*/ 
/*N*/ 	pImp->pTbxCtrlFac->C40_INSERT( SfxTbxCtrlFactory, pFact, pImp->pTbxCtrlFac->Count() );
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxApplication::RegisterStatusBarControl( SfxModule *pMod, SfxStbCtrlFactory *pFact )
/*N*/ {
/*N*/ 	if ( pMod )
/*N*/ 	{
/*N*/ 		pMod->RegisterStatusBarControl( pFact );
/*N*/ 		return;
/*N*/ 	}
/*N*/ 
/*N*/ #ifdef DBG_UTIL
/*N*/ 	for ( USHORT n=0; n<pImp->pStbCtrlFac->Count(); n++ )
/*N*/ 	{
/*N*/ 		SfxStbCtrlFactory *pF = (*pImp->pStbCtrlFac)[n];
/*N*/ 		if ( pF->nTypeId && pF->nTypeId == pFact->nTypeId &&
/*N*/ 			(pF->nSlotId == pFact->nSlotId || pF->nSlotId == 0) )
/*N*/ 		{
/*N*/ 			DBG_WARNING("StbController-Registrierung ist nicht eindeutig!");
/*N*/ 		}
/*N*/ 	}
/*N*/ #endif
/*N*/ 
/*N*/ 	pImp->pStbCtrlFac->C40_INSERT( SfxStbCtrlFactory, pFact, pImp->pStbCtrlFac->Count() );
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxApplication::RegisterMenuControl( SfxModule *pMod, SfxMenuCtrlFactory *pFact )
/*N*/ {
/*N*/ 	if ( pMod )
/*N*/ 	{
/*N*/ 		pMod->RegisterMenuControl( pFact );
/*N*/ 		return;
/*N*/ 	}
/*N*/ 
/*N*/ #ifdef DBG_UTIL
/*N*/ 	for ( USHORT n=0; n<pImp->pMenuCtrlFac->Count(); n++ )
/*N*/ 	{
/*N*/ 		SfxMenuCtrlFactory *pF = (*pImp->pMenuCtrlFac)[n];
/*N*/ 		if ( pF->nTypeId && pF->nTypeId == pFact->nTypeId &&
/*N*/ 			(pF->nSlotId == pFact->nSlotId || pF->nSlotId == 0) )
/*N*/ 		{
/*N*/ 			DBG_WARNING("MenuController-Registrierung ist nicht eindeutig!");
/*N*/ 		}
/*N*/ 	}
/*N*/ #endif
/*N*/ 
/*N*/ 	pImp->pMenuCtrlFac->C40_INSERT( SfxMenuCtrlFactory, pFact, pImp->pMenuCtrlFac->Count() );
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxApplication::SetInterfaceByIdImpl( SfxInterfaceId eId,
/*N*/ 										   SfxInterface* pIF )
/*N*/ {
/*N*/ 	if ( (USHORT) eId >= nInterfaces )
/*N*/ 	{
/*N*/ 		USHORT nNewInterfaces = eId + 4;
/*N*/ 		SfxInterface **pNewInterfaces = new SfxInterface*[nNewInterfaces];
/*N*/ 		memcpy( pNewInterfaces, pInterfaces,
/*N*/ 				sizeof(SfxInterface*) * nInterfaces );
/*N*/ 		memset( pNewInterfaces+nInterfaces, 0,
/*N*/ 				sizeof(SfxInterface*) * (nNewInterfaces-nInterfaces) );
/*N*/ 		delete[] pInterfaces;
/*N*/ 		nInterfaces = nNewInterfaces;
/*N*/ 		pInterfaces = pNewInterfaces;
/*N*/ 	}
/*N*/ 
/*N*/ 	DBG_ASSERT( 0 == pInterfaces[ USHORT(eId) ],
/*N*/ 				"interface registered more than once" );
/*N*/ #if defined(DBG_UTIL) && defined(MSC)
/*N*/ 	USHORT nId = USHORT(eId);
/*N*/ 	if ( 0 != pInterfaces[ nId ] )
/*N*/ 	{
/*?*/ 		ByteString aMsg( pIF->GetClassName() );
/*?*/ 		aMsg += " registers over ";
/*?*/ 		aMsg += pInterfaces[ nId ]->GetClassName();
/*?*/ 		DbgTrace( aMsg.GetBuffer() );
/*N*/ 	}
/*N*/ #endif
/*N*/ 
/*N*/ 	pInterfaces[ USHORT(eId) ] = pIF;
/*N*/ }

//STRIP001 const SfxObjectFactory& SfxApplication::GetDefaultFactory() const
//STRIP001 {
//STRIP001     return SfxObjectFactory::GetDefaultFactory();
//STRIP001 }
}
