/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_svdedtv1.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 06:53:11 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "svdedtv.hxx"
#include <math.h>

#ifndef _MATH_H
#define _MATH_H
#endif

// auto strip #ifndef _BIGINT_HXX //autogen
// auto strip #include <tools/bigint.hxx>
// auto strip #endif

// auto strip #ifndef _SFXITEMITER_HXX //autogen
// auto strip #include <svtools/itemiter.hxx>
// auto strip #endif

// auto strip #ifndef _SV_MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif

// auto strip #ifndef _SVX_RECTENUM_HXX //autogen
// auto strip #include <rectenum.hxx>
// auto strip #endif

#include "svxids.hrc"   // fuer SID_ATTR_TRANSFORM_...
// auto strip #include "svdattr.hxx"  // fuer Get/SetGeoAttr
// auto strip #include "svditext.hxx"
// auto strip #include "svditer.hxx"
// auto strip #include "svdtrans.hxx"
// auto strip #include "svdundo.hxx"
// auto strip #include "svdpage.hxx"
// auto strip #include "svdpagv.hxx"
// auto strip #include "svdlayer.hxx" // fuer MergeNotPersistAttr
// auto strip #include "svdattrx.hxx" // fuer MergeNotPersistAttr
// auto strip #include "svdetc.hxx"   // fuer SearchOutlinerItems
// auto strip #include "svdopath.hxx"  // fuer Crook
#include "svdstr.hrc"   // Namen aus der Resource
// auto strip #include "svdglob.hxx"  // StringCache

// auto strip #ifndef _EEITEM_HXX //autogen
// auto strip #include <eeitem.hxx>
// auto strip #endif

// auto strip #ifndef _AEITEM_HXX //autogen
// auto strip #include <svtools/aeitem.hxx>
// auto strip #endif

// auto strip #ifndef _SFX_WHITER_HXX
// auto strip #include <svtools/whiter.hxx>
// auto strip #endif
namespace binfilter {

////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////
//
//  @@@@@ @@@@@  @@ @@@@@@  @@ @@ @@ @@@@@ @@   @@
//  @@    @@  @@ @@   @@    @@ @@ @@ @@    @@   @@
//  @@    @@  @@ @@   @@    @@ @@ @@ @@    @@ @ @@
//  @@@@  @@  @@ @@   @@    @@@@@ @@ @@@@  @@@@@@@
//  @@    @@  @@ @@   @@     @@@  @@ @@    @@@@@@@
//  @@    @@  @@ @@   @@     @@@  @@ @@    @@@ @@@
//  @@@@@ @@@@@  @@   @@      @   @@ @@@@@ @@   @@
//
////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////

//STRIP001 void SdrEditView::SetMarkedObjRect(const Rectangle& rRect, BOOL bCopy)
//STRIP001 {
//STRIP001 	DBG_ASSERT(!rRect.IsEmpty(),"SetMarkedObjRect() mit leerem Rect mach keinen Sinn");
//STRIP001 	if (rRect.IsEmpty()) return;
//STRIP001 	ULONG nAnz=aMark.GetMarkCount();
//STRIP001 	if (nAnz==0) return;
//STRIP001 	Rectangle aR0(GetMarkedObjRect());
//STRIP001 	DBG_ASSERT(!aR0.IsEmpty(),"SetMarkedObjRect(): GetMarkedObjRect() ist leer");
//STRIP001 	if (aR0.IsEmpty()) return;
//STRIP001 	long x0=aR0.Left();
//STRIP001 	long y0=aR0.Top();
//STRIP001 	long w0=aR0.Right()-x0;
//STRIP001 	long h0=aR0.Bottom()-y0;
//STRIP001 	long x1=rRect.Left();
//STRIP001 	long y1=rRect.Top();
//STRIP001 	long w1=rRect.Right()-x1;
//STRIP001 	long h1=rRect.Bottom()-y1;
//STRIP001 	XubString aStr;
//STRIP001 	ImpTakeDescriptionStr(STR_EditPosSize,aStr);
//STRIP001 	if (bCopy) aStr+=ImpGetResStr(STR_EditWithCopy);
//STRIP001 	BegUndo(aStr);
//STRIP001 	if (bCopy) CopyMarkedObj();
//STRIP001 	for (ULONG nm=0; nm<nAnz; nm++) {
//STRIP001 		SdrMark* pM=aMark.GetMark(nm);
//STRIP001 		SdrObject* pO=pM->GetObj();
//STRIP001 		AddUndo(new SdrUndoGeoObj(*pO));
//STRIP001 		Rectangle aR1(pO->GetSnapRect());
//STRIP001 		if (!aR1.IsEmpty()) {
//STRIP001 			if (aR1==aR0) aR1=rRect;
//STRIP001 			else { // aR1 von aR0 nach rRect transformieren
//STRIP001 				aR1.Move(-x0,-y0);
//STRIP001 				BigInt l(aR1.Left());
//STRIP001 				BigInt r(aR1.Right());
//STRIP001 				BigInt t(aR1.Top());
//STRIP001 				BigInt b(aR1.Bottom());
//STRIP001 				if (w0!=0) {
//STRIP001 					l*=w1; l/=w0;
//STRIP001 					r*=w1; r/=w0;
//STRIP001 				} else {
//STRIP001 					l=0; r=w1;
//STRIP001 				}
//STRIP001 				if (h0!=0) {
//STRIP001 					t*=h1; t/=h0;
//STRIP001 					b*=h1; b/=h0;
//STRIP001 				} else {
//STRIP001 					t=0; b=h1;
//STRIP001 				}
//STRIP001 				aR1.Left  ()=long(l);
//STRIP001 				aR1.Right ()=long(r);
//STRIP001 				aR1.Top   ()=long(t);
//STRIP001 				aR1.Bottom()=long(b);
//STRIP001 				aR1.Move(x1,y1);
//STRIP001 			}
//STRIP001 			pO->SetSnapRect(aR1);
//STRIP001 		} else {
//STRIP001 			DBG_ERROR("SetMarkedObjRect(): pObj->GetSnapRect() liefert leeres Rect");
//STRIP001 		}
//STRIP001 	}
//STRIP001 	EndUndo();
//STRIP001 }
//STRIP001 
//STRIP001 void SdrEditView::MoveMarkedObj(const Size& rSiz, BOOL bCopy)
//STRIP001 {
//STRIP001 	XubString aStr(ImpGetResStr(STR_EditMove));
//STRIP001 	if (bCopy) aStr+=ImpGetResStr(STR_EditWithCopy);
//STRIP001 	// benoetigt eigene UndoGroup wegen Parameter
//STRIP001 	BegUndo(aStr,aMark.GetMarkDescription(),SDRREPFUNC_OBJ_MOVE);
//STRIP001 	if (bCopy) CopyMarkedObj();
//STRIP001 	ULONG nMarkAnz=aMark.GetMarkCount();
//STRIP001 	for (ULONG nm=0; nm<nMarkAnz; nm++) {
//STRIP001 		SdrMark* pM=aMark.GetMark(nm);
//STRIP001 		SdrObject* pO=pM->GetObj();
//STRIP001 		AddUndo(new SdrUndoMoveObj(*pO,rSiz));
//STRIP001 		pO->Move(rSiz);
//STRIP001 	}
//STRIP001 	EndUndo();
//STRIP001 }
//STRIP001 
//STRIP001 void SdrEditView::ResizeMarkedObj(const Point& rRef, const Fraction& xFact, const Fraction& yFact, BOOL bCopy)
//STRIP001 {
//STRIP001 	XubString aStr;
//STRIP001 	ImpTakeDescriptionStr(STR_EditResize,aStr);
//STRIP001 	if (bCopy) aStr+=ImpGetResStr(STR_EditWithCopy);
//STRIP001 	BegUndo(aStr);
//STRIP001 	if (bCopy) CopyMarkedObj();
//STRIP001 	ULONG nMarkAnz=aMark.GetMarkCount();
//STRIP001 	for (ULONG nm=0; nm<nMarkAnz; nm++) {
//STRIP001 		SdrMark* pM=aMark.GetMark(nm);
//STRIP001 		SdrObject* pO=pM->GetObj();
//STRIP001 		AddUndo(new SdrUndoGeoObj(*pO));
//STRIP001 		Point aRef(rRef-pM->GetPageView()->GetOffset());
//STRIP001 		pO->Resize(aRef,xFact,yFact);
//STRIP001 	}
//STRIP001 	EndUndo();
//STRIP001 }
//STRIP001 
//STRIP001 long SdrEditView::GetMarkedObjRotate() const
//STRIP001 {
//STRIP001 	BOOL b1st=TRUE;
//STRIP001 	BOOL bOk=TRUE;
//STRIP001 	long nWink=0;
//STRIP001 	ULONG nMarkAnz=aMark.GetMarkCount();
//STRIP001 	for (ULONG nm=0; nm<nMarkAnz && bOk; nm++) {
//STRIP001 		SdrMark* pM=aMark.GetMark(nm);
//STRIP001 		SdrObject* pO=pM->GetObj();
//STRIP001 		long nWink2=pO->GetRotateAngle();
//STRIP001 		if (b1st) nWink=nWink2;
//STRIP001 		else if (nWink2!=nWink) bOk=FALSE;
//STRIP001 		b1st=FALSE;
//STRIP001 	}
//STRIP001 	if (!bOk) nWink=0;
//STRIP001 	return nWink;
//STRIP001 }
//STRIP001 
//STRIP001 void SdrEditView::RotateMarkedObj(const Point& rRef, long nWink, BOOL bCopy)
//STRIP001 {
//STRIP001 	XubString aStr;
//STRIP001 	ImpTakeDescriptionStr(STR_EditRotate,aStr);
//STRIP001 	if (bCopy) aStr+=ImpGetResStr(STR_EditWithCopy);
//STRIP001 	BegUndo(aStr);
//STRIP001 	if (bCopy) CopyMarkedObj();
//STRIP001 	double nSin=sin(nWink*nPi180);
//STRIP001 	double nCos=cos(nWink*nPi180);
//STRIP001 	ULONG nMarkAnz=aMark.GetMarkCount();
//STRIP001 	for (ULONG nm=0; nm<nMarkAnz; nm++) {
//STRIP001 		SdrMark* pM=aMark.GetMark(nm);
//STRIP001 		SdrObject* pO=pM->GetObj();
//STRIP001 		AddUndo(new SdrUndoGeoObj(*pO));
//STRIP001 		Point aRef(rRef-pM->GetPageView()->GetOffset());
//STRIP001 		pO->Rotate(aRef,nWink,nSin,nCos);
//STRIP001 	}
//STRIP001 	EndUndo();
//STRIP001 }
//STRIP001 
//STRIP001 void SdrEditView::MirrorMarkedObj(const Point& rRef1, const Point& rRef2, BOOL bCopy)
//STRIP001 {
//STRIP001 	XubString aStr;
//STRIP001 	Point aDif(rRef2-rRef1);
//STRIP001 	if (aDif.X()==0) ImpTakeDescriptionStr(STR_EditMirrorHori,aStr);
//STRIP001 	else if (aDif.Y()==0) ImpTakeDescriptionStr(STR_EditMirrorVert,aStr);
//STRIP001 	else if (Abs(aDif.X())==Abs(aDif.Y())) ImpTakeDescriptionStr(STR_EditMirrorDiag,aStr);
//STRIP001 	else ImpTakeDescriptionStr(STR_EditMirrorFree,aStr);
//STRIP001 	if (bCopy) aStr+=ImpGetResStr(STR_EditWithCopy);
//STRIP001 	BegUndo(aStr);
//STRIP001 	if (bCopy) CopyMarkedObj();
//STRIP001 	ULONG nMarkAnz=aMark.GetMarkCount();
//STRIP001 	for (ULONG nm=0; nm<nMarkAnz; nm++) {
//STRIP001 		SdrMark* pM=aMark.GetMark(nm);
//STRIP001 		SdrObject* pO=pM->GetObj();
//STRIP001 		AddUndo(new SdrUndoGeoObj(*pO));
//STRIP001 		Point aRef1(rRef1-pM->GetPageView()->GetOffset());
//STRIP001 		Point aRef2(rRef2-pM->GetPageView()->GetOffset());
//STRIP001 		pO->Mirror(aRef1,aRef2);
//STRIP001 	}
//STRIP001 	EndUndo();
//STRIP001 }
//STRIP001 
//STRIP001 void SdrEditView::MirrorMarkedObjHorizontal(BOOL bCopy)
//STRIP001 {
//STRIP001 	Point aCenter(GetMarkedObjRect().Center());
//STRIP001 	Point aPt2(aCenter);
//STRIP001 	aPt2.Y()++;
//STRIP001 	MirrorMarkedObj(aCenter,aPt2,bCopy);
//STRIP001 }
//STRIP001 
//STRIP001 void SdrEditView::MirrorMarkedObjVertical(BOOL bCopy)
//STRIP001 {
//STRIP001 	Point aCenter(GetMarkedObjRect().Center());
//STRIP001 	Point aPt2(aCenter);
//STRIP001 	aPt2.X()++;
//STRIP001 	MirrorMarkedObj(aCenter,aPt2,bCopy);
//STRIP001 }
//STRIP001 
//STRIP001 long SdrEditView::GetMarkedObjShear() const
//STRIP001 {
//STRIP001 	BOOL b1st=TRUE;
//STRIP001 	BOOL bOk=TRUE;
//STRIP001 	long nWink=0;
//STRIP001 	ULONG nMarkAnz=aMark.GetMarkCount();
//STRIP001 	for (ULONG nm=0; nm<nMarkAnz && bOk; nm++) {
//STRIP001 		SdrMark* pM=aMark.GetMark(nm);
//STRIP001 		SdrObject* pO=pM->GetObj();
//STRIP001 		long nWink2=pO->GetShearAngle();
//STRIP001 		if (b1st) nWink=nWink2;
//STRIP001 		else if (nWink2!=nWink) bOk=FALSE;
//STRIP001 		b1st=FALSE;
//STRIP001 	}
//STRIP001 	if (nWink>SDRMAXSHEAR) nWink=SDRMAXSHEAR;
//STRIP001 	if (nWink<-SDRMAXSHEAR) nWink=-SDRMAXSHEAR;
//STRIP001 	if (!bOk) nWink=0;
//STRIP001 	return nWink;
//STRIP001 }
//STRIP001 
//STRIP001 void SdrEditView::ShearMarkedObj(const Point& rRef, long nWink, BOOL bVShear, BOOL bCopy)
//STRIP001 {
//STRIP001 	XubString aStr;
//STRIP001 	ImpTakeDescriptionStr(STR_EditShear,aStr);
//STRIP001 	if (bCopy) aStr+=ImpGetResStr(STR_EditWithCopy);
//STRIP001 	BegUndo(aStr);
//STRIP001 	if (bCopy) CopyMarkedObj();
//STRIP001 	double nTan=tan(nWink*nPi180);
//STRIP001 	ULONG nMarkAnz=aMark.GetMarkCount();
//STRIP001 	for (ULONG nm=0; nm<nMarkAnz; nm++) {
//STRIP001 		SdrMark* pM=aMark.GetMark(nm);
//STRIP001 		SdrObject* pO=pM->GetObj();
//STRIP001 		AddUndo(new SdrUndoGeoObj(*pO));
//STRIP001 		Point aRef(rRef);
//STRIP001 		Point aOfs(pM->GetPageView()->GetOffset());
//STRIP001 		aRef-=aOfs;
//STRIP001 		pO->Shear(aRef,nWink,nTan,bVShear);
//STRIP001 	}
//STRIP001 	EndUndo();
//STRIP001 }
//STRIP001 
//STRIP001 void SdrEditView::ImpCrookObj(SdrObject* pO, const Point& rRef, const Point& rRad,
//STRIP001 	SdrCrookMode eMode, BOOL bVertical, BOOL bNoContortion, BOOL bRotate, const Rectangle& rMarkRect)
//STRIP001 {
//STRIP001 	SdrPathObj* pPath=PTR_CAST(SdrPathObj,pO);
//STRIP001 	BOOL bDone = FALSE;
//STRIP001 
//STRIP001 	if(pPath!=NULL && !bNoContortion)
//STRIP001 	{
//STRIP001 		XPolyPolygon aXPP(pPath->GetPathPoly());
//STRIP001 		switch (eMode) {
//STRIP001 			case SDRCROOK_ROTATE : CrookRotatePoly (aXPP,rRef,rRad,bVertical);           break;
//STRIP001 			case SDRCROOK_SLANT  : CrookSlantPoly  (aXPP,rRef,rRad,bVertical);           break;
//STRIP001 			case SDRCROOK_STRETCH: CrookStretchPoly(aXPP,rRef,rRad,bVertical,rMarkRect); break;
//STRIP001 		} // switch
//STRIP001 		pPath->SetPathPoly(aXPP);
//STRIP001 		bDone = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if(!bDone && !pPath && pO->IsPolyObj() && pO->GetPointCount() != 0)
//STRIP001 	{
//STRIP001 		// FuerPolyObj's, aber NICHT fuer SdrPathObj's, z.B. fuer's Bemassungsobjekt
//STRIP001 		USHORT nPtAnz=pO->GetPointCount();
//STRIP001 		XPolygon aXP(nPtAnz);
//STRIP001 		USHORT nPtNum;
//STRIP001 		for (nPtNum=0; nPtNum<nPtAnz; nPtNum++) {
//STRIP001 			Point aPt(pO->GetPoint(nPtNum));
//STRIP001 			aXP[nPtNum]=aPt;
//STRIP001 		}
//STRIP001 		switch (eMode) {
//STRIP001 			case SDRCROOK_ROTATE : CrookRotatePoly (aXP,rRef,rRad,bVertical);           break;
//STRIP001 			case SDRCROOK_SLANT  : CrookSlantPoly  (aXP,rRef,rRad,bVertical);           break;
//STRIP001 			case SDRCROOK_STRETCH: CrookStretchPoly(aXP,rRef,rRad,bVertical,rMarkRect); break;
//STRIP001 		} // switch
//STRIP001 		for (nPtNum=0; nPtNum<nPtAnz; nPtNum++) {
//STRIP001 			// hier koennte man vieleicht auch mal das Broadcasting optimieren
//STRIP001 			// ist aber z.Zt. bei den 2 Punkten des Bemassungsobjekts noch nicht so tragisch
//STRIP001 			pO->SetPoint(aXP[nPtNum],nPtNum);
//STRIP001 		}
//STRIP001 		bDone = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if(!bDone)
//STRIP001 	{
//STRIP001 		// Fuer alle anderen oder wenn bNoContortion
//STRIP001 		Point aCtr0(pO->GetSnapRect().Center());
//STRIP001 		Point aCtr1(aCtr0);
//STRIP001 		BOOL bRotOk=FALSE;
//STRIP001 		double nSin,nCos;
//STRIP001 		double nWink=0;
//STRIP001 		if (rRad.X()!=0 && rRad.Y()!=0) {
//STRIP001 			bRotOk=bRotate;
//STRIP001 			switch (eMode) {
//STRIP001 				case SDRCROOK_ROTATE : nWink=CrookRotateXPoint (aCtr1,NULL,NULL,rRef,rRad,nSin,nCos,bVertical); bRotOk=bRotate; break;
//STRIP001 				case SDRCROOK_SLANT  : nWink=CrookSlantXPoint  (aCtr1,NULL,NULL,rRef,rRad,nSin,nCos,bVertical);           break;
//STRIP001 				case SDRCROOK_STRETCH: nWink=CrookStretchXPoint(aCtr1,NULL,NULL,rRef,rRad,nSin,nCos,bVertical,rMarkRect); break;
//STRIP001 			} // switch
//STRIP001 		}
//STRIP001 		aCtr1-=aCtr0;
//STRIP001 		if (bRotOk) pO->Rotate(aCtr0,Round(nWink/nPi180),nSin,nCos);
//STRIP001 		pO->Move(Size(aCtr1.X(),aCtr1.Y()));
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SdrEditView::CrookMarkedObj(const Point& rRef, const Point& rRad, SdrCrookMode eMode,
//STRIP001 	BOOL bVertical, BOOL bNoContortion, BOOL bCopy)
//STRIP001 {
//STRIP001 	Rectangle aMarkRect(GetMarkedObjRect());
//STRIP001 	XubString aStr;
//STRIP001 	BOOL bRotate=bNoContortion && eMode==SDRCROOK_ROTATE && IsRotateAllowed(FALSE);
//STRIP001 	ImpTakeDescriptionStr(bNoContortion?STR_EditCrook:STR_EditCrookContortion,aStr);
//STRIP001 	if (bCopy) aStr+=ImpGetResStr(STR_EditWithCopy);
//STRIP001 	BegUndo(aStr);
//STRIP001 	if (bCopy) CopyMarkedObj();
//STRIP001 	ULONG nMarkAnz=aMark.GetMarkCount();
//STRIP001 	for (ULONG nm=0; nm<nMarkAnz; nm++) {
//STRIP001 		SdrMark* pM=aMark.GetMark(nm);
//STRIP001 		SdrObject* pO=pM->GetObj();
//STRIP001 		AddUndo(new SdrUndoGeoObj(*pO));
//STRIP001 		Point aRef(rRef);
//STRIP001 		Point aOfs(pM->GetPageView()->GetOffset());
//STRIP001 		aRef-=aOfs;
//STRIP001 		const SdrObjList* pOL=pO->GetSubList();
//STRIP001 		if (bNoContortion || pOL==NULL) {
//STRIP001 			ImpCrookObj(pO,aRef,rRad,eMode,bVertical,bNoContortion,bRotate,aMarkRect);
//STRIP001 		} else {
//STRIP001 			SdrObjListIter aIter(*pOL,IM_DEEPNOGROUPS);
//STRIP001 			while (aIter.IsMore()) {
//STRIP001 				SdrObject* pO1=aIter.Next();
//STRIP001 				ImpCrookObj(pO1,aRef,rRad,eMode,bVertical,bNoContortion,bRotate,aMarkRect);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	EndUndo();
//STRIP001 }
//STRIP001 
//STRIP001 void SdrEditView::ImpDistortObj(SdrObject* pO, const Rectangle& rRef, const XPolygon& rDistortedRect, BOOL bNoContortion)
//STRIP001 {
//STRIP001 	SdrPathObj* pPath=PTR_CAST(SdrPathObj,pO);
//STRIP001 	if (!bNoContortion && pPath!=NULL) {
//STRIP001 		XPolyPolygon aXPP(pPath->GetPathPoly());
//STRIP001 		aXPP.Distort(rRef,rDistortedRect);
//STRIP001 		pPath->SetPathPoly(aXPP);
//STRIP001 	} else if (pO->IsPolyObj()) {
//STRIP001 		// z.B. fuer's Bemassungsobjekt
//STRIP001 		USHORT nPtAnz=pO->GetPointCount();
//STRIP001 		XPolygon aXP(nPtAnz);
//STRIP001 		USHORT nPtNum;
//STRIP001 		for (nPtNum=0; nPtNum<nPtAnz; nPtNum++) {
//STRIP001 			Point aPt(pO->GetPoint(nPtNum));
//STRIP001 			aXP[nPtNum]=aPt;
//STRIP001 		}
//STRIP001 		aXP.Distort(rRef,rDistortedRect);
//STRIP001 		for (nPtNum=0; nPtNum<nPtAnz; nPtNum++) {
//STRIP001 			// hier koennte man vieleicht auch mal das Broadcasting optimieren
//STRIP001 			// ist aber z.Zt. bei den 2 Punkten des Bemassungsobjekts noch nicht so tragisch
//STRIP001 			pO->SetPoint(aXP[nPtNum],nPtNum);
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SdrEditView::DistortMarkedObj(const Rectangle& rRef, const XPolygon& rDistortedRect, BOOL bNoContortion, BOOL bCopy)
//STRIP001 {
//STRIP001 	XubString aStr;
//STRIP001 	ImpTakeDescriptionStr(STR_EditDistort,aStr);
//STRIP001 	if (bCopy) aStr+=ImpGetResStr(STR_EditWithCopy);
//STRIP001 	BegUndo(aStr);
//STRIP001 	if (bCopy) CopyMarkedObj();
//STRIP001 	ULONG nMarkAnz=aMark.GetMarkCount();
//STRIP001 	for (ULONG nm=0; nm<nMarkAnz; nm++) {
//STRIP001 		SdrMark* pM=aMark.GetMark(nm);
//STRIP001 		SdrObject* pO=pM->GetObj();
//STRIP001 		AddUndo(new SdrUndoGeoObj(*pO));
//STRIP001 		Rectangle aRefRect(rRef);
//STRIP001 		XPolygon  aRefPoly(rDistortedRect);
//STRIP001 		Point aOfs(pM->GetPageView()->GetOffset());
//STRIP001 		if (aOfs.X()!=0 || aOfs.Y()!=0) {
//STRIP001 			aRefRect.Move(-aOfs.X(),-aOfs.Y());
//STRIP001 			aRefPoly.Move(-aOfs.X(),-aOfs.Y());
//STRIP001 		}
//STRIP001 		const SdrObjList* pOL=pO->GetSubList();
//STRIP001 		if (bNoContortion || pOL==NULL) {
//STRIP001 			ImpDistortObj(pO,aRefRect,aRefPoly,bNoContortion);
//STRIP001 		} else {
//STRIP001 			SdrObjListIter aIter(*pOL,IM_DEEPNOGROUPS);
//STRIP001 			while (aIter.IsMore()) {
//STRIP001 				SdrObject* pO1=aIter.Next();
//STRIP001 				ImpDistortObj(pO1,aRefRect,aRefPoly,bNoContortion);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	EndUndo();
//STRIP001 }
//STRIP001 
//STRIP001 ////////////////////////////////////////////////////////////////////////////////////////////////////
//STRIP001 
//STRIP001 void SdrEditView::SetNotPersistAttrToMarked(const SfxItemSet& rAttr, BOOL bReplaceAll)
//STRIP001 {
//STRIP001 	// bReplaceAll hat hier keinerlei Wirkung
//STRIP001 	Rectangle aAllSnapRect(GetMarkedObjRect());
//STRIP001 	const SfxPoolItem *pPoolItem=NULL;
//STRIP001 	if (rAttr.GetItemState(SDRATTR_TRANSFORMREF1X,TRUE,&pPoolItem)==SFX_ITEM_SET) {
//STRIP001 		long n=((const SdrTransformRef1XItem*)pPoolItem)->GetValue();
//STRIP001 		SetRef1(Point(n,GetRef1().Y()));
//STRIP001 	}
//STRIP001 	if (rAttr.GetItemState(SDRATTR_TRANSFORMREF1Y,TRUE,&pPoolItem)==SFX_ITEM_SET) {
//STRIP001 		long n=((const SdrTransformRef1YItem*)pPoolItem)->GetValue();
//STRIP001 		SetRef1(Point(GetRef1().X(),n));
//STRIP001 	}
//STRIP001 	if (rAttr.GetItemState(SDRATTR_TRANSFORMREF2X,TRUE,&pPoolItem)==SFX_ITEM_SET) {
//STRIP001 		long n=((const SdrTransformRef2XItem*)pPoolItem)->GetValue();
//STRIP001 		SetRef2(Point(n,GetRef2().Y()));
//STRIP001 	}
//STRIP001 	if (rAttr.GetItemState(SDRATTR_TRANSFORMREF2Y,TRUE,&pPoolItem)==SFX_ITEM_SET) {
//STRIP001 		long n=((const SdrTransformRef2YItem*)pPoolItem)->GetValue();
//STRIP001 		SetRef2(Point(GetRef2().X(),n));
//STRIP001 	}
//STRIP001 	long nAllPosX=0; BOOL bAllPosX=FALSE;
//STRIP001 	long nAllPosY=0; BOOL bAllPosY=FALSE;
//STRIP001 	long nAllWdt=0;  BOOL bAllWdt=FALSE;
//STRIP001 	long nAllHgt=0;  BOOL bAllHgt=FALSE;
//STRIP001 	BOOL bDoIt=FALSE;
//STRIP001 	if (rAttr.GetItemState(SDRATTR_ALLPOSITIONX,TRUE,&pPoolItem)==SFX_ITEM_SET) {
//STRIP001 		nAllPosX=((const SdrAllPositionXItem*)pPoolItem)->GetValue();
//STRIP001 		bAllPosX=TRUE; bDoIt=TRUE;
//STRIP001 	}
//STRIP001 	if (rAttr.GetItemState(SDRATTR_ALLPOSITIONY,TRUE,&pPoolItem)==SFX_ITEM_SET) {
//STRIP001 		nAllPosY=((const SdrAllPositionYItem*)pPoolItem)->GetValue();
//STRIP001 		bAllPosY=TRUE; bDoIt=TRUE;
//STRIP001 	}
//STRIP001 	if (rAttr.GetItemState(SDRATTR_ALLSIZEWIDTH,TRUE,&pPoolItem)==SFX_ITEM_SET) {
//STRIP001 		nAllWdt=((const SdrAllSizeWidthItem*)pPoolItem)->GetValue();
//STRIP001 		bAllWdt=TRUE; bDoIt=TRUE;
//STRIP001 	}
//STRIP001 	if (rAttr.GetItemState(SDRATTR_ALLSIZEHEIGHT,TRUE,&pPoolItem)==SFX_ITEM_SET) {
//STRIP001 		nAllHgt=((const SdrAllSizeHeightItem*)pPoolItem)->GetValue();
//STRIP001 		bAllHgt=TRUE; bDoIt=TRUE;
//STRIP001 	}
//STRIP001 	if (bDoIt) {
//STRIP001 		Rectangle aRect(aAllSnapRect); // !!! fuer PolyPt's und GluePt's aber bitte noch aendern !!!
//STRIP001 		if (bAllPosX) aRect.Move(nAllPosX-aRect.Left(),0);
//STRIP001 		if (bAllPosY) aRect.Move(0,nAllPosY-aRect.Top());
//STRIP001 		if (bAllWdt)  aRect.Right()=aAllSnapRect.Left()+nAllWdt;
//STRIP001 		if (bAllHgt)  aRect.Bottom()=aAllSnapRect.Top()+nAllHgt;
//STRIP001 		SetMarkedObjRect(aRect);
//STRIP001 	}
//STRIP001 	if (rAttr.GetItemState(SDRATTR_RESIZEXALL,TRUE,&pPoolItem)==SFX_ITEM_SET) {
//STRIP001 		Fraction aXFact=((const SdrResizeXAllItem*)pPoolItem)->GetValue();
//STRIP001 		ResizeMarkedObj(aAllSnapRect.TopLeft(),aXFact,Fraction(1,1));
//STRIP001 	}
//STRIP001 	if (rAttr.GetItemState(SDRATTR_RESIZEYALL,TRUE,&pPoolItem)==SFX_ITEM_SET) {
//STRIP001 		Fraction aYFact=((const SdrResizeYAllItem*)pPoolItem)->GetValue();
//STRIP001 		ResizeMarkedObj(aAllSnapRect.TopLeft(),Fraction(1,1),aYFact);
//STRIP001 	}
//STRIP001 	if (rAttr.GetItemState(SDRATTR_ROTATEALL,TRUE,&pPoolItem)==SFX_ITEM_SET) {
//STRIP001 		long nAngle=((const SdrRotateAllItem*)pPoolItem)->GetValue();
//STRIP001 		RotateMarkedObj(aAllSnapRect.Center(),nAngle);
//STRIP001 	}
//STRIP001 	if (rAttr.GetItemState(SDRATTR_HORZSHEARALL,TRUE,&pPoolItem)==SFX_ITEM_SET) {
//STRIP001 		long nAngle=((const SdrHorzShearAllItem*)pPoolItem)->GetValue();
//STRIP001 		ShearMarkedObj(aAllSnapRect.Center(),nAngle,FALSE);
//STRIP001 	}
//STRIP001 	if (rAttr.GetItemState(SDRATTR_VERTSHEARALL,TRUE,&pPoolItem)==SFX_ITEM_SET) {
//STRIP001 		long nAngle=((const SdrVertShearAllItem*)pPoolItem)->GetValue();
//STRIP001 		ShearMarkedObj(aAllSnapRect.Center(),nAngle,TRUE);
//STRIP001 	}
//STRIP001 	// Todo: WhichRange nach Notwendigkeit ueberpruefen.
//STRIP001 	ULONG nMarkAnz=aMark.GetMarkCount();
//STRIP001 	for (ULONG nm=0; nm<nMarkAnz; nm++) {
//STRIP001 		const SdrMark* pM=aMark.GetMark(nm);
//STRIP001 		SdrObject* pObj=pM->GetObj();
//STRIP001 		const SdrPageView* pPV=pM->GetPageView();
//STRIP001 		AddUndo(new SdrUndoGeoObj(*pObj));
//STRIP001 		pObj->ApplyNotPersistAttr(rAttr);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SdrEditView::MergeNotPersistAttrFromMarked(SfxItemSet& rAttr, BOOL bOnlyHardAttr) const
//STRIP001 {
//STRIP001 	// bOnlyHardAttr hat hier keinerlei Wirkung
//STRIP001 	// Hier muss ausserdem noch der Nullpunkt und
//STRIP001 	// die PvPos berueksichtigt werden.
//STRIP001 	Rectangle aAllSnapRect(GetMarkedObjRect()); // !!! fuer PolyPt's und GluePt's aber bitte noch aendern !!!
//STRIP001 	long nAllSnapPosX=aAllSnapRect.Left();
//STRIP001 	long nAllSnapPosY=aAllSnapRect.Top();
//STRIP001 	long nAllSnapWdt=aAllSnapRect.GetWidth()-1;
//STRIP001 	long nAllSnapHgt=aAllSnapRect.GetHeight()-1;
//STRIP001 	// koennte mal zu CheckPossibilities mit rein
//STRIP001 	BOOL bMovProtect=FALSE,bMovProtectDC=FALSE;
//STRIP001 	BOOL bSizProtect=FALSE,bSizProtectDC=FALSE;
//STRIP001 	BOOL bPrintable =TRUE ,bPrintableDC=FALSE;
//STRIP001 	SdrLayerID nLayerId=0; BOOL bLayerDC=FALSE;
//STRIP001 	XubString aObjName;     BOOL bObjNameDC=FALSE,bObjNameSet=FALSE;
//STRIP001 	long nSnapPosX=0;      BOOL bSnapPosXDC=FALSE;
//STRIP001 	long nSnapPosY=0;      BOOL bSnapPosYDC=FALSE;
//STRIP001 	long nSnapWdt=0;       BOOL bSnapWdtDC=FALSE;
//STRIP001 	long nSnapHgt=0;       BOOL bSnapHgtDC=FALSE;
//STRIP001 	long nLogicWdt=0;      BOOL bLogicWdtDC=FALSE,bLogicWdtDiff=FALSE;
//STRIP001 	long nLogicHgt=0;      BOOL bLogicHgtDC=FALSE,bLogicHgtDiff=FALSE;
//STRIP001 	long nRotAngle=0;      BOOL bRotAngleDC=FALSE;
//STRIP001 	long nShrAngle=0;      BOOL bShrAngleDC=FALSE;
//STRIP001 	Rectangle aSnapRect;
//STRIP001 	Rectangle aLogicRect;
//STRIP001 	ULONG nMarkAnz=aMark.GetMarkCount();
//STRIP001 	for (ULONG nm=0; nm<nMarkAnz; nm++) {
//STRIP001 		const SdrMark* pM=aMark.GetMark(nm);
//STRIP001 		const SdrObject* pObj=pM->GetObj();
//STRIP001 		if (nm==0) {
//STRIP001 			nLayerId=pObj->GetLayer();
//STRIP001 			bMovProtect=pObj->IsMoveProtect();
//STRIP001 			bSizProtect=pObj->IsResizeProtect();
//STRIP001 			bPrintable =pObj->IsPrintable();
//STRIP001 			Rectangle aSnapRect(pObj->GetSnapRect());
//STRIP001 			Rectangle aLogicRect(pObj->GetLogicRect());
//STRIP001 			nSnapPosX=aSnapRect.Left();
//STRIP001 			nSnapPosY=aSnapRect.Top();
//STRIP001 			nSnapWdt=aSnapRect.GetWidth()-1;
//STRIP001 			nSnapHgt=aSnapRect.GetHeight()-1;
//STRIP001 			nLogicWdt=aLogicRect.GetWidth()-1;
//STRIP001 			nLogicHgt=aLogicRect.GetHeight()-1;
//STRIP001 			bLogicWdtDiff=nLogicWdt!=nSnapWdt;
//STRIP001 			bLogicHgtDiff=nLogicHgt!=nSnapHgt;
//STRIP001 			nRotAngle=pObj->GetRotateAngle();
//STRIP001 			nShrAngle=pObj->GetShearAngle();
//STRIP001 		} else {
//STRIP001 			if (!bLayerDC      && nLayerId   !=pObj->GetLayer())        bLayerDC=TRUE;
//STRIP001 			if (!bMovProtectDC && bMovProtect!=pObj->IsMoveProtect())   bMovProtectDC=TRUE;
//STRIP001 			if (!bSizProtectDC && bSizProtect!=pObj->IsResizeProtect()) bSizProtectDC=TRUE;
//STRIP001 			if (!bPrintableDC  && bPrintable !=pObj->IsPrintable())     bPrintableDC=TRUE;
//STRIP001 			if (!bRotAngleDC   && nRotAngle  !=pObj->GetRotateAngle())  bRotAngleDC=TRUE;
//STRIP001 			if (!bShrAngleDC   && nShrAngle  !=pObj->GetShearAngle())   bShrAngleDC=TRUE;
//STRIP001 			if (!bSnapWdtDC || !bSnapHgtDC || !bSnapPosXDC || !bSnapPosYDC || !bLogicWdtDiff || !bLogicHgtDiff) {
//STRIP001 				aSnapRect=pObj->GetSnapRect();
//STRIP001 				if (nSnapPosX!=aSnapRect.Left()) bSnapPosXDC=TRUE;
//STRIP001 				if (nSnapPosY!=aSnapRect.Top()) bSnapPosYDC=TRUE;
//STRIP001 				if (nSnapWdt!=aSnapRect.GetWidth()-1) bSnapWdtDC=TRUE;
//STRIP001 				if (nSnapHgt!=aSnapRect.GetHeight()-1) bSnapHgtDC=TRUE;
//STRIP001 			}
//STRIP001 			if (!bLogicWdtDC || !bLogicHgtDC || !bLogicWdtDiff || !bLogicHgtDiff) {
//STRIP001 				aLogicRect=pObj->GetLogicRect();
//STRIP001 				if (nLogicWdt!=aLogicRect.GetWidth()-1) bLogicWdtDC=TRUE;
//STRIP001 				if (nLogicHgt!=aLogicRect.GetHeight()-1) bLogicHgtDC=TRUE;
//STRIP001 				if (!bLogicWdtDiff && aSnapRect.GetWidth()!=aLogicRect.GetWidth()) bLogicWdtDiff=TRUE;
//STRIP001 				if (!bLogicHgtDiff && aSnapRect.GetHeight()!=aLogicRect.GetHeight()) bLogicHgtDiff=TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if (!bObjNameDC && pObj->HasSetName()) {
//STRIP001 			if (!bObjNameSet) {
//STRIP001 				aObjName=pObj->GetName();
//STRIP001 			} else {
//STRIP001 				if (aObjName!=pObj->GetName()) bObjNameDC=TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bSnapPosXDC || nAllSnapPosX!=nSnapPosX) rAttr.Put(SdrAllPositionXItem(nAllSnapPosX));
//STRIP001 	if (bSnapPosYDC || nAllSnapPosY!=nSnapPosY) rAttr.Put(SdrAllPositionYItem(nAllSnapPosY));
//STRIP001 	if (bSnapWdtDC  || nAllSnapWdt !=nSnapWdt ) rAttr.Put(SdrAllSizeWidthItem(nAllSnapWdt));
//STRIP001 	if (bSnapHgtDC  || nAllSnapHgt !=nSnapHgt ) rAttr.Put(SdrAllSizeHeightItem(nAllSnapHgt));
//STRIP001 
//STRIP001 	// Items fuer reine Transformationen
//STRIP001 	rAttr.Put(SdrMoveXItem());
//STRIP001 	rAttr.Put(SdrMoveYItem());
//STRIP001 	rAttr.Put(SdrResizeXOneItem());
//STRIP001 	rAttr.Put(SdrResizeYOneItem());
//STRIP001 	rAttr.Put(SdrRotateOneItem());
//STRIP001 	rAttr.Put(SdrHorzShearOneItem());
//STRIP001 	rAttr.Put(SdrVertShearOneItem());
//STRIP001 	if (nMarkAnz>1) {
//STRIP001 		rAttr.Put(SdrResizeXAllItem());
//STRIP001 		rAttr.Put(SdrResizeYAllItem());
//STRIP001 		rAttr.Put(SdrRotateAllItem());
//STRIP001 		rAttr.Put(SdrHorzShearAllItem());
//STRIP001 		rAttr.Put(SdrVertShearAllItem());
//STRIP001 	}
//STRIP001 
//STRIP001 	if(eDragMode == SDRDRAG_ROTATE || eDragMode == SDRDRAG_MIRROR) 
//STRIP001 	{
//STRIP001 		rAttr.Put(SdrTransformRef1XItem(GetRef1().X()));
//STRIP001 		rAttr.Put(SdrTransformRef1YItem(GetRef1().Y()));
//STRIP001 	}
//STRIP001 	
//STRIP001 	if(eDragMode == SDRDRAG_MIRROR) 
//STRIP001 	{
//STRIP001 		rAttr.Put(SdrTransformRef2XItem(GetRef2().X()));
//STRIP001 		rAttr.Put(SdrTransformRef2YItem(GetRef2().Y()));
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 SfxItemSet SdrEditView::GetAttrFromMarked(BOOL bOnlyHardAttr) const
//STRIP001 {
//STRIP001 	SfxItemSet aSet(pMod->GetItemPool());
//STRIP001 	MergeAttrFromMarked(aSet,bOnlyHardAttr);
//STRIP001 	return aSet;
//STRIP001 }
//STRIP001 
//STRIP001 void SdrEditView::MergeAttrFromMarked(SfxItemSet& rAttr, BOOL bOnlyHardAttr) const
//STRIP001 {
//STRIP001 	sal_uInt32 nMarkAnz(aMark.GetMarkCount());
//STRIP001 
//STRIP001 	for(sal_uInt32 a(0); a < nMarkAnz; a++) 
//STRIP001 	{
//STRIP001 		// #80277# merging was done wrong in the prev version
//STRIP001 		const SfxItemSet& rSet = aMark.GetMark(a)->GetObj()->GetItemSet();
//STRIP001 		SfxWhichIter aIter(rSet);
//STRIP001 		sal_uInt16 nWhich(aIter.FirstWhich());
//STRIP001 
//STRIP001 		while(nWhich)
//STRIP001 		{
//STRIP001 			if(!bOnlyHardAttr)
//STRIP001 			{
//STRIP001 				if(SFX_ITEM_DONTCARE == rSet.GetItemState(nWhich, FALSE))
//STRIP001 					rAttr.InvalidateItem(nWhich);
//STRIP001 				else
//STRIP001 					rAttr.MergeValue(rSet.Get(nWhich), TRUE);
//STRIP001 			}
//STRIP001 			else if(SFX_ITEM_SET == rSet.GetItemState(nWhich, FALSE))
//STRIP001 			{
//STRIP001 				const SfxPoolItem& rItem = rSet.Get(nWhich);
//STRIP001 				rAttr.MergeValue(rItem, TRUE);
//STRIP001 			}
//STRIP001 
//STRIP001 			nWhich = aIter.NextWhich();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SdrEditView::SetAttrToMarked(const SfxItemSet& rAttr, BOOL bReplaceAll)
//STRIP001 {
//STRIP001 	if (HasMarkedObj()) 
//STRIP001 	{
//STRIP001 #ifdef DBG_UTIL
//STRIP001 		{
//STRIP001 			BOOL bHasEEFeatureItems=FALSE;
//STRIP001 			SfxItemIter aIter(rAttr);
//STRIP001 			const SfxPoolItem* pItem=aIter.FirstItem();
//STRIP001 			while (!bHasEEFeatureItems && pItem!=NULL) {
//STRIP001 				if (!IsInvalidItem(pItem)) {
//STRIP001 					USHORT nW=pItem->Which();
//STRIP001 					if (nW>=EE_FEATURE_START && nW<=EE_FEATURE_END) bHasEEFeatureItems=TRUE;
//STRIP001 				}
//STRIP001 				pItem=aIter.NextItem();
//STRIP001 			}
//STRIP001 			if(bHasEEFeatureItems) 
//STRIP001 			{
//STRIP001 				String aMessage;
//STRIP001 				aMessage.AppendAscii("SdrEditView::SetAttrToMarked(): Das setzen von EE_FEATURE-Items an der SdrView macht keinen Sinn! Es fuehrt nur zu Overhead und nicht mehr lesbaren Dokumenten.");
//STRIP001 				InfoBox(NULL, aMessage).Execute();
//STRIP001 			}
//STRIP001 		}
//STRIP001 #endif
//STRIP001 
//STRIP001 		// #103836# if the user thets character attributes to the complete shape,
//STRIP001 		//			we want to remove all hard set character attributes with same
//STRIP001 		//			which ids from the text. We do that later but here we remember
//STRIP001 		//			all character attribute which id's that are set.
//STRIP001 		std::vector<sal_uInt16> aCharWhichIds;
//STRIP001 		{
//STRIP001 			SfxItemIter aIter(rAttr);
//STRIP001 			const SfxPoolItem* pItem=aIter.FirstItem();
//STRIP001 			while( pItem!=NULL )
//STRIP001 			{
//STRIP001 				if (!IsInvalidItem(pItem))
//STRIP001 				{
//STRIP001 					sal_uInt16 nWhich = pItem->Which();
//STRIP001 					if (nWhich>=EE_CHAR_START && nWhich<=EE_CHAR_END)
//STRIP001 						aCharWhichIds.push_back( nWhich );
//STRIP001 				}
//STRIP001 				pItem=aIter.NextItem();
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		// Joe, 2.7.98: Damit Undo nach Format.Standard auch die Textattribute korrekt restauriert
//STRIP001 		BOOL bHasEEItems=SearchOutlinerItems(rAttr,bReplaceAll);
//STRIP001 		XubString aStr;
//STRIP001 		ImpTakeDescriptionStr(STR_EditSetAttributes,aStr);
//STRIP001 
//STRIP001 		// AW 030100: save additional geom info when para or char attributes
//STRIP001 		// are changed and the geom form of the text object might be changed
//STRIP001 		BOOL bPossibleGeomChange(FALSE);
//STRIP001 		SfxWhichIter aIter(rAttr);
//STRIP001 		UINT16 nWhich = aIter.FirstWhich();
//STRIP001 		while(!bPossibleGeomChange && nWhich) 
//STRIP001 		{
//STRIP001 			SfxItemState eState = rAttr.GetItemState(nWhich);
//STRIP001 			if(eState == SFX_ITEM_SET) 
//STRIP001 			{
//STRIP001 				if((nWhich >= SDRATTR_TEXT_MINFRAMEHEIGHT && nWhich <= SDRATTR_TEXT_CONTOURFRAME) 
//STRIP001 					|| nWhich == SDRATTR_3DOBJ_PERCENT_DIAGONAL
//STRIP001 					|| nWhich == SDRATTR_3DOBJ_BACKSCALE
//STRIP001 					|| nWhich == SDRATTR_3DOBJ_DEPTH
//STRIP001 					|| nWhich == SDRATTR_3DOBJ_END_ANGLE
//STRIP001 					|| nWhich == SDRATTR_3DSCENE_DISTANCE)
//STRIP001 				{
//STRIP001 					bPossibleGeomChange = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			nWhich = aIter.NextWhich();
//STRIP001 		}
//STRIP001 
//STRIP001 		BegUndo(aStr);
//STRIP001 		ULONG nMarkAnz=aMark.GetMarkCount();
//STRIP001 
//STRIP001 		// create ItemSet without SFX_ITEM_DONTCARE. Put()
//STRIP001 		// uses it's second parameter (bInvalidAsDefault) to
//STRIP001 		// remove all such items to set them to default.
//STRIP001 		SfxItemSet aAttr(*rAttr.GetPool(), rAttr.GetRanges());
//STRIP001 		aAttr.Put(rAttr, TRUE);
//STRIP001 		
//STRIP001 		for (ULONG nm=0; nm<nMarkAnz; nm++)
//STRIP001 		{
//STRIP001 			SdrMark* pM=aMark.GetMark(nm);
//STRIP001 			SdrObject* pObj = pM->GetObj();
//STRIP001 
//STRIP001 			// new geometry undo
//STRIP001 			if(bPossibleGeomChange)
//STRIP001 			{
//STRIP001 				// save position and size of obect, too
//STRIP001 				AddUndo(new SdrUndoGeoObj(*pObj));
//STRIP001 			}
//STRIP001 
//STRIP001 			// #i8508#
//STRIP001 			// If this is a text object also rescue the OutlinerParaObject since
//STRIP001 			// applying attributes to the object may change text layout when
//STRIP001 			// multiple portions exist with multiple formats. If a OutlinerParaObject
//STRIP001 			// really exists and needs to be rescued is evaluated in the undo
//STRIP001 			// implementation itself.
//STRIP001 			sal_Bool bRescueText(pObj->ISA(SdrTextObj));
//STRIP001 
//STRIP001 			// add attribute undo
//STRIP001 			AddUndo(new SdrUndoAttrObj(*pObj,FALSE,bHasEEItems || bPossibleGeomChange || bRescueText));
//STRIP001 
//STRIP001 			SdrBroadcastItemChange aItemChange(*pObj);
//STRIP001 			if(bReplaceAll)
//STRIP001 				pObj->ClearItem();
//STRIP001 			if( (0 != aCharWhichIds.size() ) && pObj->ISA(SdrTextObj) )
//STRIP001 				((SdrTextObj*)pObj)->RemoveOutlinerCharacterAttribs( aCharWhichIds );
//STRIP001 
//STRIP001 			pObj->SetItemSet(aAttr);
//STRIP001 			pObj->BroadcastItemChange(aItemChange);
//STRIP001 		}
//STRIP001 		// besser vorher checken, was gemacht werden soll:
//STRIP001 		// pObj->SetAttr() oder SetNotPersistAttr()
//STRIP001 		// !!! fehlende Implementation !!!
//STRIP001 		SetNotPersistAttrToMarked(rAttr,bReplaceAll);
//STRIP001 		EndUndo();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 SfxStyleSheet* SdrEditView::GetStyleSheetFromMarked() const
//STRIP001 {
//STRIP001 	SfxStyleSheet* pRet=NULL;
//STRIP001 	BOOL b1st=TRUE;
//STRIP001 	ULONG nMarkAnz=aMark.GetMarkCount();
//STRIP001 	for (ULONG nm=0; nm<nMarkAnz; nm++) {
//STRIP001 		SdrMark* pM=aMark.GetMark(nm);
//STRIP001 		SfxStyleSheet* pSS=pM->GetObj()->GetStyleSheet();
//STRIP001 		if (b1st) pRet=pSS;
//STRIP001 		else if (pRet!=pSS) return NULL; // verschiedene StyleSheets
//STRIP001 		b1st=FALSE;
//STRIP001 	}
//STRIP001 	return pRet;
//STRIP001 }
//STRIP001 
//STRIP001 void SdrEditView::SetStyleSheetToMarked(SfxStyleSheet* pStyleSheet, BOOL bDontRemoveHardAttr)
//STRIP001 {
//STRIP001 	if (HasMarkedObj()) {
//STRIP001 		XubString aStr;
//STRIP001 		if (pStyleSheet!=NULL) ImpTakeDescriptionStr(STR_EditSetStylesheet,aStr);
//STRIP001 		else ImpTakeDescriptionStr(STR_EditDelStylesheet,aStr);
//STRIP001 		BegUndo(aStr);
//STRIP001 		ULONG nMarkAnz=aMark.GetMarkCount();
//STRIP001 		for (ULONG nm=0; nm<nMarkAnz; nm++) {
//STRIP001 			SdrMark* pM=aMark.GetMark(nm);
//STRIP001             AddUndo(new SdrUndoGeoObj(*pM->GetObj()));
//STRIP001 			AddUndo(new SdrUndoAttrObj(*pM->GetObj(),TRUE,TRUE));
//STRIP001 			pM->GetObj()->SetStyleSheet(pStyleSheet,bDontRemoveHardAttr);
//STRIP001 		}
//STRIP001 		EndUndo();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 ////////////////////////////////////////////////////////////////////////////////////////////////////
//STRIP001 
//STRIP001 /* new interface src537 */
//STRIP001 BOOL SdrEditView::GetAttributes(SfxItemSet& rTargetSet, BOOL bOnlyHardAttr) const
//STRIP001 {
//STRIP001 	if(aMark.GetMarkCount())
//STRIP001 	{
//STRIP001 		rTargetSet.Put(GetAttrFromMarked(bOnlyHardAttr), FALSE);
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		return SdrMarkView::GetAttributes(rTargetSet, bOnlyHardAttr);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 BOOL SdrEditView::SetAttributes(const SfxItemSet& rSet, BOOL bReplaceAll)
//STRIP001 {
//STRIP001 	if (aMark.GetMarkCount()!=0) {
//STRIP001 		SetAttrToMarked(rSet,bReplaceAll);
//STRIP001 		return TRUE;
//STRIP001 	} else {
//STRIP001 		return SdrMarkView::SetAttributes(rSet,bReplaceAll);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 SfxStyleSheet* SdrEditView::GetStyleSheet(BOOL& rOk) const
//STRIP001 {
//STRIP001 	if (aMark.GetMarkCount()!=0) {
//STRIP001 		rOk=TRUE;
//STRIP001 		return GetStyleSheetFromMarked();
//STRIP001 	} else {
//STRIP001 		return SdrMarkView::GetStyleSheet(rOk);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 BOOL SdrEditView::SetStyleSheet(SfxStyleSheet* pStyleSheet, BOOL bDontRemoveHardAttr)
//STRIP001 {
//STRIP001 	if (aMark.GetMarkCount()!=0) {
//STRIP001 		SetStyleSheetToMarked(pStyleSheet,bDontRemoveHardAttr);
//STRIP001 		return TRUE;
//STRIP001 	} else {
//STRIP001 		return SdrMarkView::SetStyleSheet(pStyleSheet,bDontRemoveHardAttr);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 ////////////////////////////////////////////////////////////////////////////////////////////////////
//STRIP001 
//STRIP001 SfxItemSet SdrEditView::GetGeoAttrFromMarked() const
//STRIP001 {
//STRIP001 	SfxItemSet aRetSet(pMod->GetItemPool(),   // SID_ATTR_TRANSFORM_... aus s:svxids.hrc
//STRIP001 					   SID_ATTR_TRANSFORM_POS_X,SID_ATTR_TRANSFORM_ANGLE,
//STRIP001 					   SID_ATTR_TRANSFORM_PROTECT_POS,SID_ATTR_TRANSFORM_AUTOHEIGHT,
//STRIP001 					   SDRATTR_ECKENRADIUS,SDRATTR_ECKENRADIUS,
//STRIP001 					   0);
//STRIP001 	if (HasMarkedObj()) {
//STRIP001 		SfxItemSet aMarkAttr(GetAttrFromMarked(FALSE)); // wg. AutoGrowHeight und Eckenradius
//STRIP001 		Rectangle aRect(GetMarkedObjRect());
//STRIP001 		if (GetPageViewCount()==1) { // hier mal etwas verbessern !!!
//STRIP001 			GetPageViewPvNum(0)->LogicToPagePos(aRect);
//STRIP001 		}
//STRIP001 
//STRIP001 		// Position
//STRIP001 		aRetSet.Put(SfxInt32Item(SID_ATTR_TRANSFORM_POS_X,aRect.Left()));
//STRIP001 		aRetSet.Put(SfxInt32Item(SID_ATTR_TRANSFORM_POS_Y,aRect.Top()));
//STRIP001 
//STRIP001 		// Groesse
//STRIP001 		long nResizeRefX=aRect.Left();
//STRIP001 		long nResizeRefY=aRect.Top();
//STRIP001 		if (eDragMode==SDRDRAG_ROTATE) { // Drehachse auch als Referenz fuer Resize
//STRIP001 			nResizeRefX=aRef1.X();
//STRIP001 			nResizeRefY=aRef1.Y();
//STRIP001 		}
//STRIP001 		aRetSet.Put(SfxUInt32Item(SID_ATTR_TRANSFORM_WIDTH,aRect.Right()-aRect.Left()));
//STRIP001 		aRetSet.Put(SfxUInt32Item(SID_ATTR_TRANSFORM_HEIGHT,aRect.Bottom()-aRect.Top()));
//STRIP001 		aRetSet.Put(SfxInt32Item(SID_ATTR_TRANSFORM_RESIZE_REF_X,nResizeRefX));
//STRIP001 		aRetSet.Put(SfxInt32Item(SID_ATTR_TRANSFORM_RESIZE_REF_Y,nResizeRefY));
//STRIP001 
//STRIP001 		Point aRotateAxe(aRef1);
//STRIP001 		if (GetPageViewCount()==1) { // hier mal etwas verbessern !!!
//STRIP001 			GetPageViewPvNum(0)->LogicToPagePos(aRotateAxe);
//STRIP001 		}
//STRIP001 
//STRIP001 		// Drehung
//STRIP001 		long nRotateRefX=aRect.Center().X();
//STRIP001 		long nRotateRefY=aRect.Center().Y();
//STRIP001 		if (eDragMode==SDRDRAG_ROTATE) {
//STRIP001 			nRotateRefX=aRotateAxe.X();
//STRIP001 			nRotateRefY=aRotateAxe.Y();
//STRIP001 		}
//STRIP001 		aRetSet.Put(SfxInt32Item(SID_ATTR_TRANSFORM_ANGLE,GetMarkedObjRotate()));
//STRIP001 		aRetSet.Put(SfxInt32Item(SID_ATTR_TRANSFORM_ROT_X,nRotateRefX));
//STRIP001 		aRetSet.Put(SfxInt32Item(SID_ATTR_TRANSFORM_ROT_Y,nRotateRefY));
//STRIP001 
//STRIP001 		// Shear
//STRIP001 		long nShearRefX=aRect.Left();
//STRIP001 		long nShearRefY=aRect.Bottom();
//STRIP001 		if (eDragMode==SDRDRAG_ROTATE) { // Drehachse auch als Referenz fuer Shear
//STRIP001 			nShearRefX=aRotateAxe.X();
//STRIP001 			nShearRefY=aRotateAxe.Y();
//STRIP001 		}
//STRIP001 		aRetSet.Put(SfxInt32Item(SID_ATTR_TRANSFORM_SHEAR,GetMarkedObjShear()));
//STRIP001 		aRetSet.Put(SfxInt32Item(SID_ATTR_TRANSFORM_SHEAR_X,nShearRefX));
//STRIP001 		aRetSet.Put(SfxInt32Item(SID_ATTR_TRANSFORM_SHEAR_Y,nShearRefY));
//STRIP001 
//STRIP001 		// Pruefen der einzelnen Objekte, ob Objekte geschuetzt sind
//STRIP001 		const SdrMarkList& rMarkList=GetMarkList();
//STRIP001 		ULONG nMarkCount=rMarkList.GetMarkCount();
//STRIP001 		SdrObject* pObj=rMarkList.GetMark(0)->GetObj();
//STRIP001 		BOOL bPosProt=pObj->IsMoveProtect();
//STRIP001 		BOOL bSizProt=pObj->IsResizeProtect();
//STRIP001 		BOOL bPosProtDontCare=FALSE;
//STRIP001 		BOOL bSizProtDontCare=FALSE;
//STRIP001 		for (ULONG i=1; i<nMarkCount && (!bPosProtDontCare || !bSizProtDontCare); i++) {
//STRIP001 			pObj=rMarkList.GetMark(i)->GetObj();
//STRIP001 			if (bPosProt!=pObj->IsMoveProtect()) bPosProtDontCare=TRUE;
//STRIP001 			if (bSizProt!=pObj->IsResizeProtect()) bSizProtDontCare=TRUE;
//STRIP001 		}
//STRIP001 
//STRIP001 		// InvalidateItem setzt das Item auf DONT_CARE
//STRIP001 		if (bPosProtDontCare) {
//STRIP001 			aRetSet.InvalidateItem(SID_ATTR_TRANSFORM_PROTECT_POS);
//STRIP001 		} else {
//STRIP001 			aRetSet.Put(SfxBoolItem(SID_ATTR_TRANSFORM_PROTECT_POS,bPosProt));
//STRIP001 		}
//STRIP001 		if (bSizProtDontCare) {
//STRIP001 			aRetSet.InvalidateItem(SID_ATTR_TRANSFORM_PROTECT_SIZE);
//STRIP001 		} else {
//STRIP001 			aRetSet.Put(SfxBoolItem(SID_ATTR_TRANSFORM_PROTECT_SIZE,bSizProt));
//STRIP001 		}
//STRIP001 
//STRIP001 		SfxItemState eState=aMarkAttr.GetItemState(SDRATTR_TEXT_AUTOGROWWIDTH);
//STRIP001 		BOOL bAutoGrow=((SdrTextAutoGrowWidthItem&)(aMarkAttr.Get(SDRATTR_TEXT_AUTOGROWWIDTH))).GetValue();
//STRIP001 		if (eState==SFX_ITEM_DONTCARE) {
//STRIP001 			aRetSet.InvalidateItem(SID_ATTR_TRANSFORM_AUTOWIDTH);
//STRIP001 		} else if (eState==SFX_ITEM_SET) {
//STRIP001 			aRetSet.Put(SfxBoolItem(SID_ATTR_TRANSFORM_AUTOWIDTH,bAutoGrow));
//STRIP001 		}
//STRIP001 
//STRIP001 		eState=aMarkAttr.GetItemState(SDRATTR_TEXT_AUTOGROWHEIGHT);
//STRIP001 		bAutoGrow=((SdrTextAutoGrowHeightItem&)(aMarkAttr.Get(SDRATTR_TEXT_AUTOGROWHEIGHT))).GetValue();
//STRIP001 		if (eState==SFX_ITEM_DONTCARE) {
//STRIP001 			aRetSet.InvalidateItem(SID_ATTR_TRANSFORM_AUTOHEIGHT);
//STRIP001 		} else if (eState==SFX_ITEM_SET) {
//STRIP001 			aRetSet.Put(SfxBoolItem(SID_ATTR_TRANSFORM_AUTOHEIGHT,bAutoGrow));
//STRIP001 		}
//STRIP001 
//STRIP001 		eState=aMarkAttr.GetItemState(SDRATTR_ECKENRADIUS);
//STRIP001 		long nRadius=((SdrEckenradiusItem&)(aMarkAttr.Get(SDRATTR_ECKENRADIUS))).GetValue();
//STRIP001 		if (eState==SFX_ITEM_DONTCARE) {
//STRIP001 			aRetSet.InvalidateItem(SDRATTR_ECKENRADIUS);
//STRIP001 		} else if (eState==SFX_ITEM_SET) {
//STRIP001 			aRetSet.Put(SdrEckenradiusItem(nRadius));
//STRIP001 		}
//STRIP001 
//STRIP001 	}
//STRIP001 	return aRetSet;
//STRIP001 }
//STRIP001 
//STRIP001 Point ImpGetPoint(Rectangle aRect, RECT_POINT eRP)
//STRIP001 {
//STRIP001 	switch(eRP) {
//STRIP001 		case RP_LT: return aRect.TopLeft();
//STRIP001 		case RP_MT: return aRect.TopCenter();
//STRIP001 		case RP_RT: return aRect.TopRight();
//STRIP001 		case RP_LM: return aRect.LeftCenter();
//STRIP001 		case RP_MM: return aRect.Center();
//STRIP001 		case RP_RM: return aRect.RightCenter();
//STRIP001 		case RP_LB: return aRect.BottomLeft();
//STRIP001 		case RP_MB: return aRect.BottomCenter();
//STRIP001 		case RP_RB: return aRect.BottomRight();
//STRIP001 	}
//STRIP001 	return Point(); // Sollte nicht vorkommen !
//STRIP001 }
//STRIP001 
//STRIP001 void SdrEditView::SetGeoAttrToMarked(const SfxItemSet& rAttr)
//STRIP001 {
//STRIP001 	Rectangle aRect(GetMarkedObjRect());
//STRIP001 	if (GetPageViewCount()==1) {
//STRIP001 		GetPageViewPvNum(0)->LogicToPagePos(aRect);
//STRIP001 	}
//STRIP001 	long nOldRotateAngle=GetMarkedObjRotate();
//STRIP001 	long nOldShearAngle=GetMarkedObjShear();
//STRIP001 	const SdrMarkList& rMarkList=GetMarkList();
//STRIP001 	ULONG nMarkCount=rMarkList.GetMarkCount();
//STRIP001 	SdrObject* pObj=NULL;
//STRIP001 
//STRIP001 	RECT_POINT eSizePoint=RP_MM;
//STRIP001 	long nPosDX=0;
//STRIP001 	long nPosDY=0;
//STRIP001 	long nSizX=0;
//STRIP001 	long nSizY=0;
//STRIP001 	long nRotateAngle=0;
//STRIP001 	
//STRIP001 	// #86909#
//STRIP001 	sal_Bool bModeIsRotate(eDragMode == SDRDRAG_ROTATE);
//STRIP001 	long nRotateX(0);
//STRIP001 	long nRotateY(0);
//STRIP001 	long nOldRotateX(0);
//STRIP001 	long nOldRotateY(0);
//STRIP001 	if(bModeIsRotate)
//STRIP001 	{
//STRIP001 		Point aRotateAxe(aRef1);
//STRIP001 		if(GetPageViewCount()==1)
//STRIP001 			GetPageViewPvNum(0)->LogicToPagePos(aRotateAxe);
//STRIP001 		nRotateX = nOldRotateX = aRotateAxe.X();
//STRIP001 		nRotateY = nOldRotateY = aRotateAxe.Y();
//STRIP001 	}
//STRIP001 	
//STRIP001 	long nNewShearAngle=0;
//STRIP001 	long nShearAngle=0;
//STRIP001 	long nShearX=0;
//STRIP001 	long nShearY=0;
//STRIP001 	BOOL bShearVert=FALSE;
//STRIP001 
//STRIP001 	BOOL bChgPos=FALSE;
//STRIP001 	BOOL bChgSiz=FALSE;
//STRIP001 	BOOL bChgHgt=FALSE;
//STRIP001 	BOOL bRotate=FALSE;
//STRIP001 	BOOL bShear =FALSE;
//STRIP001 
//STRIP001 	BOOL bSetAttr=FALSE;
//STRIP001 	SfxItemSet aSetAttr(pMod->GetItemPool());
//STRIP001 
//STRIP001 	const SfxPoolItem* pPoolItem=NULL;
//STRIP001 
//STRIP001 	// Position
//STRIP001 	if (SFX_ITEM_SET==rAttr.GetItemState(SID_ATTR_TRANSFORM_POS_X,TRUE,&pPoolItem)) {
//STRIP001 		nPosDX=((const SfxInt32Item*)pPoolItem)->GetValue()-aRect.Left();
//STRIP001 		bChgPos=TRUE;
//STRIP001 	}
//STRIP001 	if (SFX_ITEM_SET==rAttr.GetItemState(SID_ATTR_TRANSFORM_POS_Y,TRUE,&pPoolItem)){
//STRIP001 		nPosDY=((const SfxInt32Item*)pPoolItem)->GetValue()-aRect.Top();
//STRIP001 		bChgPos=TRUE;
//STRIP001 	}
//STRIP001 	// Groesse
//STRIP001 	if (SFX_ITEM_SET==rAttr.GetItemState(SID_ATTR_TRANSFORM_WIDTH,TRUE,&pPoolItem)) {
//STRIP001 		nSizX=((const SfxUInt32Item*)pPoolItem)->GetValue();
//STRIP001 		bChgSiz=TRUE;
//STRIP001 	}
//STRIP001 	if (SFX_ITEM_SET==rAttr.GetItemState(SID_ATTR_TRANSFORM_HEIGHT,TRUE,&pPoolItem)) {
//STRIP001 		nSizY=((const SfxUInt32Item*)pPoolItem)->GetValue();
//STRIP001 		bChgSiz=TRUE;
//STRIP001 		bChgHgt=TRUE;
//STRIP001 	}
//STRIP001 	if (bChgSiz) {
//STRIP001 		eSizePoint=(RECT_POINT)((const SfxAllEnumItem&)rAttr.Get(SID_ATTR_TRANSFORM_SIZE_POINT)).GetValue();
//STRIP001 	}
//STRIP001 
//STRIP001 	// Rotation
//STRIP001 	if (SFX_ITEM_SET==rAttr.GetItemState(SID_ATTR_TRANSFORM_ANGLE,TRUE,&pPoolItem)) {
//STRIP001 		nRotateAngle=((const SfxInt32Item*)pPoolItem)->GetValue()-nOldRotateAngle;
//STRIP001 		bRotate = (nRotateAngle != 0);
//STRIP001 	}
//STRIP001 
//STRIP001 	// #86909# pos rot point x
//STRIP001 	if(bRotate || SFX_ITEM_SET==rAttr.GetItemState(SID_ATTR_TRANSFORM_ROT_X, TRUE ,&pPoolItem)) 
//STRIP001 		nRotateX = ((const SfxInt32Item&)rAttr.Get(SID_ATTR_TRANSFORM_ROT_X)).GetValue();
//STRIP001 
//STRIP001 	// #86909# pos rot point y
//STRIP001 	if(bRotate || SFX_ITEM_SET==rAttr.GetItemState(SID_ATTR_TRANSFORM_ROT_Y, TRUE ,&pPoolItem)) 
//STRIP001 		nRotateY = ((const SfxInt32Item&)rAttr.Get(SID_ATTR_TRANSFORM_ROT_Y)).GetValue();
//STRIP001 
//STRIP001 	// Shear
//STRIP001 	if (SFX_ITEM_SET==rAttr.GetItemState(SID_ATTR_TRANSFORM_SHEAR,TRUE,&pPoolItem)) {
//STRIP001 		nNewShearAngle=((const SfxInt32Item*)pPoolItem)->GetValue();
//STRIP001 		if (nNewShearAngle>SDRMAXSHEAR) nNewShearAngle=SDRMAXSHEAR;
//STRIP001 		if (nNewShearAngle<-SDRMAXSHEAR) nNewShearAngle=-SDRMAXSHEAR;
//STRIP001 		if (nNewShearAngle!=nOldShearAngle) {
//STRIP001 			bShearVert=((const SfxBoolItem&)rAttr.Get(SID_ATTR_TRANSFORM_SHEAR_VERTICAL)).GetValue();
//STRIP001 			if (bShearVert) {
//STRIP001 				nShearAngle=nNewShearAngle;
//STRIP001 			} else {
//STRIP001 				if (nNewShearAngle!=0 && nOldShearAngle!=0) {
//STRIP001 					// Bugfix #25714#.
//STRIP001 					double nOld=tan((double)nOldShearAngle*nPi180);
//STRIP001 					double nNew=tan((double)nNewShearAngle*nPi180);
//STRIP001 					nNew-=nOld;
//STRIP001 					nNew=atan(nNew)/nPi180;
//STRIP001 					nShearAngle=Round(nNew);
//STRIP001 				} else {
//STRIP001 					nShearAngle=nNewShearAngle-nOldShearAngle;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			bShear=nShearAngle!=0;
//STRIP001 			if (bShear) {
//STRIP001 				nShearX=((const SfxInt32Item&)rAttr.Get(SID_ATTR_TRANSFORM_SHEAR_X)).GetValue();
//STRIP001 				nShearY=((const SfxInt32Item&)rAttr.Get(SID_ATTR_TRANSFORM_SHEAR_Y)).GetValue();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// AutoGrow
//STRIP001 	if (SFX_ITEM_SET==rAttr.GetItemState(SID_ATTR_TRANSFORM_AUTOWIDTH,TRUE,&pPoolItem)) {
//STRIP001 		BOOL bAutoGrow=((const SfxBoolItem*)pPoolItem)->GetValue();
//STRIP001 		aSetAttr.Put(SdrTextAutoGrowWidthItem(bAutoGrow));
//STRIP001 		bSetAttr=TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (SFX_ITEM_SET==rAttr.GetItemState(SID_ATTR_TRANSFORM_AUTOHEIGHT,TRUE,&pPoolItem)) {
//STRIP001 		BOOL bAutoGrow=((const SfxBoolItem*)pPoolItem)->GetValue();
//STRIP001 		aSetAttr.Put(SdrTextAutoGrowHeightItem(bAutoGrow));
//STRIP001 		bSetAttr=TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	// Eckenradius
//STRIP001 	if (bEdgeRadiusAllowed && SFX_ITEM_SET==rAttr.GetItemState(SDRATTR_ECKENRADIUS,TRUE,&pPoolItem)) {
//STRIP001 		long nRadius=((SdrEckenradiusItem*)pPoolItem)->GetValue();
//STRIP001 		aSetAttr.Put(SdrEckenradiusItem(nRadius));
//STRIP001 		bSetAttr=TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	ForcePossibilities();
//STRIP001 
//STRIP001 	BegUndo(ImpGetResStr(STR_EditTransform),aMark.GetMarkDescription());
//STRIP001 
//STRIP001 	if (bSetAttr) {
//STRIP001 		SetAttrToMarked(aSetAttr,FALSE);
//STRIP001 	}
//STRIP001 
//STRIP001 	// Groesse und Hoehe aendern
//STRIP001 	if (bChgSiz && (bResizeFreeAllowed || bResizePropAllowed)) {
//STRIP001 		Fraction aWdt(nSizX,aRect.Right()-aRect.Left());
//STRIP001 		Fraction aHgt(nSizY,aRect.Bottom()-aRect.Top());
//STRIP001 		Point aRef(ImpGetPoint(aRect,eSizePoint));
//STRIP001 		if (GetPageViewCount()==1) {
//STRIP001 			GetPageViewPvNum(0)->PagePosToLogic(aRef);
//STRIP001 		}
//STRIP001 		ResizeMarkedObj(aRef,aWdt,aHgt);
//STRIP001 	}
//STRIP001 
//STRIP001 	// Rotieren
//STRIP001 	if (bRotate && (bRotateFreeAllowed || bRotate90Allowed)) {
//STRIP001 		Point aRef(nRotateX,nRotateY);
//STRIP001 		if (GetPageViewCount()==1) {
//STRIP001 			GetPageViewPvNum(0)->PagePosToLogic(aRef);
//STRIP001 		}
//STRIP001 		RotateMarkedObj(aRef,nRotateAngle);
//STRIP001 	}
//STRIP001 
//STRIP001 	// #86909# set rotation point position
//STRIP001 	if(bModeIsRotate && (nRotateX != nOldRotateX || nRotateY != nOldRotateY))
//STRIP001 	{
//STRIP001 		Point aNewRef1(nRotateX, nRotateY);
//STRIP001 		if (GetPageViewCount()==1)
//STRIP001 			GetPageViewPvNum(0)->PagePosToLogic(aNewRef1);
//STRIP001 		SetRef1(aNewRef1);
//STRIP001 	}
//STRIP001 
//STRIP001 	// Shear
//STRIP001 	if (bShear && bShearAllowed) {
//STRIP001 		Point aRef(nShearX,nShearY);
//STRIP001 		if (GetPageViewCount()==1) {
//STRIP001 			GetPageViewPvNum(0)->PagePosToLogic(aRef);
//STRIP001 		}
//STRIP001 		ShearMarkedObj(aRef,nShearAngle,bShearVert);
//STRIP001 		long nTempAngle=GetMarkedObjShear();
//STRIP001 		if (nTempAngle!=0 && nTempAngle!=nNewShearAngle && !bShearVert) {
//STRIP001 			// noch eine 2. Iteration zur Kompensation der Rundungsfehler
//STRIP001 			double nOld=tan((double)nTempAngle*nPi180);
//STRIP001 			double nNew=tan((double)nNewShearAngle*nPi180);
//STRIP001 			nNew-=nOld;
//STRIP001 			nNew=atan(nNew)/nPi180;
//STRIP001 			nTempAngle=Round(nNew);
//STRIP001 			if (nTempAngle!=0) {
//STRIP001 				ShearMarkedObj(aRef,nTempAngle,bShearVert);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Position aendern
//STRIP001 	if (bChgPos && bMoveAllowed) {
//STRIP001 		MoveMarkedObj(Size(nPosDX,nPosDY));
//STRIP001 	}
//STRIP001 
//STRIP001 	// Position geschuetzt
//STRIP001 	if (SFX_ITEM_SET==rAttr.GetItemState(SID_ATTR_TRANSFORM_PROTECT_POS,TRUE,&pPoolItem))
//STRIP001 	{
//STRIP001 		BOOL bProtPos=((const SfxBoolItem*)pPoolItem)->GetValue();
//STRIP001 		for (ULONG i=0; i<nMarkCount; i++) {
//STRIP001 			pObj=rMarkList.GetMark(i)->GetObj();
//STRIP001 			pObj->SetMoveProtect(bProtPos);
//STRIP001 			if( bProtPos )
//STRIP001 				pObj->SetResizeProtect(true);
//STRIP001 		}
//STRIP001 		// BugFix 13897: hier muesste besser ein Broadcast her!
//STRIP001 		// Ausserdem fehlt Undo
//STRIP001 		// oder -> bProtPos/Size als Item (Interface)
//STRIP001 		bMoveProtect=bProtPos;
//STRIP001 		if( bProtPos )
//STRIP001 			bResizeProtect=true;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( !bMoveProtect )
//STRIP001 	{
//STRIP001 		// Groesse geschuetzt
//STRIP001 		if (SFX_ITEM_SET==rAttr.GetItemState(SID_ATTR_TRANSFORM_PROTECT_SIZE,TRUE,&pPoolItem))
//STRIP001 		{
//STRIP001 			BOOL bProtSize=((const SfxBoolItem*)pPoolItem)->GetValue();
//STRIP001 			for (ULONG i=0; i<nMarkCount; i++) {
//STRIP001 				pObj=rMarkList.GetMark(i)->GetObj();
//STRIP001 				pObj->SetResizeProtect(bProtSize);
//STRIP001 			}
//STRIP001 			// BugFix 13897: hier muesste besser ein Broadcast her!
//STRIP001 			// Ausserdem fehlt Undo
//STRIP001 			// oder -> bProtPos/Size als Item (Interface)
//STRIP001 			bResizeProtect=bProtSize;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	EndUndo();
//STRIP001 }
//STRIP001 
//STRIP001 ////////////////////////////////////////////////////////////////////////////////////////////////////
//STRIP001 
//STRIP001 BOOL SdrEditView::IsAlignPossible() const
//STRIP001 {  // Mindestens 2 markierte Objekte, davon mind. 1 beweglich
//STRIP001 	ForcePossibilities();
//STRIP001 	ULONG nAnz=aMark.GetMarkCount();
//STRIP001 	if (nAnz==0) return FALSE;         // Nix markiert!
//STRIP001 	if (nAnz==1) return bMoveAllowed;  // einzelnes Obj an der Seite ausrichten
//STRIP001 	return bOneOrMoreMovable;          // ansonsten ist MarkCount>=2
//STRIP001 }
//STRIP001 
//STRIP001 void SdrEditView::AlignMarkedObjects(SdrHorAlign eHor, SdrVertAlign eVert, BOOL bBoundRects)
//STRIP001 {
//STRIP001 	if (eHor==SDRHALIGN_NONE && eVert==SDRVALIGN_NONE) return;
//STRIP001 	aMark.ForceSort();
//STRIP001 	if (aMark.GetMarkCount()<1) return;
//STRIP001 	XubString aStr(aMark.GetMarkDescription());
//STRIP001 	if (eHor==SDRHALIGN_NONE) {
//STRIP001 		switch (eVert) {
//STRIP001 			case SDRVALIGN_TOP   : ImpTakeDescriptionStr(STR_EditAlignVTop   ,aStr); break;
//STRIP001 			case SDRVALIGN_BOTTOM: ImpTakeDescriptionStr(STR_EditAlignVBottom,aStr); break;
//STRIP001 			case SDRVALIGN_CENTER: ImpTakeDescriptionStr(STR_EditAlignVCenter,aStr); break;
//STRIP001 		}
//STRIP001 	} else if (eVert==SDRVALIGN_NONE) {
//STRIP001 		switch (eHor) {
//STRIP001 			case SDRHALIGN_LEFT  : ImpTakeDescriptionStr(STR_EditAlignHLeft  ,aStr); break;
//STRIP001 			case SDRHALIGN_RIGHT : ImpTakeDescriptionStr(STR_EditAlignHRight ,aStr); break;
//STRIP001 			case SDRHALIGN_CENTER: ImpTakeDescriptionStr(STR_EditAlignHCenter,aStr); break;
//STRIP001 		}
//STRIP001 	} else if (eHor==SDRHALIGN_CENTER && eVert==SDRVALIGN_CENTER) {
//STRIP001 		ImpTakeDescriptionStr(STR_EditAlignCenter,aStr);
//STRIP001 	} else {
//STRIP001 		ImpTakeDescriptionStr(STR_EditAlign,aStr);
//STRIP001 	}
//STRIP001 	BegUndo(aStr);
//STRIP001 	Rectangle aBound;
//STRIP001 	ULONG nMarkAnz=aMark.GetMarkCount();
//STRIP001 	ULONG nm;
//STRIP001 	BOOL bHasFixed=FALSE;
//STRIP001 	for (nm=0; nm<nMarkAnz; nm++) {
//STRIP001 		SdrMark* pM=aMark.GetMark(nm);
//STRIP001 		SdrObject* pObj=pM->GetObj();
//STRIP001 		SdrObjTransformInfoRec aInfo;
//STRIP001 		pObj->TakeObjInfo(aInfo);
//STRIP001 		if (!aInfo.bMoveAllowed || pObj->IsMoveProtect()) {
//STRIP001 			Point aOfs(pM->GetPageView()->GetOffset());
//STRIP001 			Rectangle aObjRect(bBoundRects?pObj->GetBoundRect():pObj->GetSnapRect());
//STRIP001 			aObjRect.Move(aOfs.X(),aOfs.Y());
//STRIP001 			aBound.Union(aObjRect);
//STRIP001 			bHasFixed=TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if (!bHasFixed) {
//STRIP001 		if (nMarkAnz==1) { // einzelnes Obj an der Seite ausrichten
//STRIP001 			const SdrObject* pObj=aMark.GetMark(0L)->GetObj();
//STRIP001 			const SdrPage* pPage=pObj->GetPage();
//STRIP001 			const SdrPageGridFrameList* pGFL=pPage->GetGridFrameList(aMark.GetMark(0L)->GetPageView(),&(pObj->GetSnapRect()));
//STRIP001 			const SdrPageGridFrame* pFrame=NULL;
//STRIP001 			if (pGFL!=NULL && pGFL->GetCount()!=0) { // Writer
//STRIP001 				pFrame=&((*pGFL)[0]);
//STRIP001 			}
//STRIP001 			if (pFrame!=NULL) { // Writer
//STRIP001 				aBound=pFrame->GetUserArea();
//STRIP001 			} else {
//STRIP001 				aBound=Rectangle(pPage->GetLftBorder(),pPage->GetUppBorder(),
//STRIP001 								 pPage->GetWdt()-pPage->GetRgtBorder(),
//STRIP001 								 pPage->GetHgt()-pPage->GetLwrBorder());
//STRIP001 			}
//STRIP001 		} else {
//STRIP001 			if (bBoundRects) aBound=GetMarkedObjBoundRect();
//STRIP001 			else aBound=GetMarkedObjRect();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	Point aCenter(aBound.Center());
//STRIP001 	for (nm=0; nm<nMarkAnz; nm++) {
//STRIP001 		SdrMark* pM=aMark.GetMark(nm);
//STRIP001 		SdrObject* pObj=pM->GetObj();
//STRIP001 		SdrObjTransformInfoRec aInfo;
//STRIP001 		pObj->TakeObjInfo(aInfo);
//STRIP001 		if (aInfo.bMoveAllowed && !pObj->IsMoveProtect()) {
//STRIP001 			SdrPageView* pPV=pM->GetPageView();
//STRIP001 			Point aOfs(pPV->GetOffset());
//STRIP001 			long nXMov=0;
//STRIP001 			long nYMov=0;
//STRIP001 			Rectangle aObjRect(bBoundRects?pObj->GetBoundRect():pObj->GetSnapRect());
//STRIP001 			switch (eVert) {
//STRIP001 				case SDRVALIGN_TOP   : nYMov=aBound.Top()   -aObjRect.Top()       -aOfs.Y(); break;
//STRIP001 				case SDRVALIGN_BOTTOM: nYMov=aBound.Bottom()-aObjRect.Bottom()    -aOfs.Y(); break;
//STRIP001 				case SDRVALIGN_CENTER: nYMov=aCenter.Y()    -aObjRect.Center().Y()-aOfs.Y(); break;
//STRIP001 			}
//STRIP001 			switch (eHor) {
//STRIP001 				case SDRHALIGN_LEFT  : nXMov=aBound.Left()  -aObjRect.Left()      -aOfs.X(); break;
//STRIP001 				case SDRHALIGN_RIGHT : nXMov=aBound.Right() -aObjRect.Right()     -aOfs.X(); break;
//STRIP001 				case SDRHALIGN_CENTER: nXMov=aCenter.X()    -aObjRect.Center().X()-aOfs.X(); break;
//STRIP001 			}
//STRIP001 			if (nXMov!=0 || nYMov!=0) 
//STRIP001 			{
//STRIP001 				// #104104# SdrEdgeObj needs an extra SdrUndoGeoObj since the
//STRIP001 				// connections may need to be saved
//STRIP001 				if(pObj && pObj->ISA(SdrEdgeObj))
//STRIP001 				{
//STRIP001 					AddUndo(new SdrUndoGeoObj(*pObj));
//STRIP001 				}
//STRIP001 
//STRIP001 				AddUndo(new SdrUndoMoveObj(*pObj,Size(nXMov,nYMov)));
//STRIP001 
//STRIP001 				pObj->Move(Size(nXMov,nYMov));
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	EndUndo();
//STRIP001 }

}
