/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: tpscaley.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:56:34 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SCH_TPSCALEY_HXX_
#define _SCH_TPSCALEY_HXX_

// header for SfxTabPage
#ifndef _SFXTABDLG_HXX
#include <sfx2/tabdlg.hxx>
#endif
// header for FixedText
#ifndef _SV_FIXED_HXX
#include <vcl/fixed.hxx>
#endif
// header for Edit
#ifndef _SV_EDIT_HXX
#include <vcl/edit.hxx>
#endif
// header for CheckBox
#ifndef _SV_BUTTON_HXX
#include <vcl/button.hxx>
#endif
// header for MetricField
#ifndef _SV_FIELD_HXX
#include <vcl/field.hxx>
#endif
// header for class FormattedField
#ifndef _FMTFIELD_HXX_
#include <svtools/fmtfield.hxx>
#endif

class ChartModel;
class SvNumberFormatter;

class SchScaleYAxisTabPage : public SfxTabPage
{
private:
	ChartModel          *pMyModel;

	FixedLine			aFlScale;
	FixedText			aTxtMin;
	FormattedField		aFmtFldMin;
	CheckBox			aCbxAutoMin;
	FixedText			aTxtMax;
	FormattedField		aFmtFldMax;
	CheckBox			aCbxAutoMax;
	FixedText           aTxtMain;
	FormattedField		aFmtFldStepMain;
	CheckBox			aCbxAutoStepMain;
	FixedText           aTxtHelp;
	FormattedField		aFmtFldStepHelp;
	MetricField         aMtStepHelp;
	CheckBox			aCbxAutoStepHelp;
	FixedText           aTxtOrigin;
	FormattedField		aFmtFldOrigin;
	CheckBox			aCbxAutoOrigin;
	CheckBox			aCbxLogarithm;

	FixedLine aFlTicks;
	CheckBox aCbxTicksInner;
	CheckBox aCbxTicksOuter;

	FixedLine aFlHelpTicks;
	CheckBox aCbxHelpTicksInner;
	CheckBox aCbxHelpTicksOuter;

	double				fMin;
	double				fMax;
	double				fStepMain;
	double				fStepHelp;
	double				fOrigin;
	int                 nAxisType;
	const SfxItemSet&	rOutAttrs;
	SvNumberFormatter*	pNumFormatter;

	BOOL				bLastStepMain;

	void CheckLogs ();
	void CheckLogControls ();

	BOOL GetHelpValue ();

	DECL_LINK( EnableValueHdl, CheckBox* );
	DECL_LINK( HandleLogs, CheckBox * );

public:
	SchScaleYAxisTabPage( Window* pParent, const SfxItemSet& rInAttrs );

	static SfxTabPage* Create( Window* pParent, const SfxItemSet& rInAttrs );
	virtual BOOL FillItemSet( SfxItemSet& rOutAttrs );
	virtual void Reset( const SfxItemSet& rInAttrs );
	virtual int DeactivatePage( SfxItemSet* pItemSet = NULL );

	void SetNumFormatter( SvNumberFormatter* pFormatter );
	void SetNumFormat();

	void SetModel( ChartModel *pModel )						{ pMyModel = pModel; }
};

#endif // _SCH_TPSCALEY_HXX_

