/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: unedtit.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 01:01:23 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SCH_UNEDTIT_HXX
#define _SCH_UNEDTIT_HXX

#include "schundo.hxx"

/*************************************************************************
|*
|* Undo fuer Titel editieren
|*
\************************************************************************/

class SchUndoEditTitle : public SchUndoAction
{
private:
	String aOldMainTitle;
	String aOldSubTitle;
	String aOldXAxisTitle;
	String aOldYAxisTitle;
	String aOldZAxisTitle;

	String aNewMainTitle;
	String aNewSubTitle;
	String aNewXAxisTitle;
	String aNewYAxisTitle;
	String aNewZAxisTitle;

public:
	TYPEINFO();

	SchUndoEditTitle(ChartModel& rChDoc,
					 const String& rOldMain, const String& rOldSub,
					 const String& rOldXAxis, const String& rOldYAxis,
					 const String& rOldZAxis,
					 const String& rNewMain, const String& rNewSub,
					 const String& rNewXAxis, const String& rNewYAxis,
					 const String& rNewZAxis) :
		SchUndoAction(rChDoc),
		aOldMainTitle(rOldMain),
		aOldSubTitle(rOldSub),
		aOldXAxisTitle(rOldXAxis),
		aOldYAxisTitle(rOldYAxis),
		aOldZAxisTitle(rOldZAxis),
		aNewMainTitle(rNewMain),
		aNewSubTitle(rNewSub),
		aNewXAxisTitle(rNewXAxis),
		aNewYAxisTitle(rNewYAxis),
		aNewZAxisTitle(rNewZAxis) {}

	virtual void Undo();
	virtual void Redo();

	virtual BOOL CanRepeat(SfxRepeatTarget& rView) const;
};

#endif	// _SCH_UNEDTIT_HXX

