/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: langtab.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 21:25:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

// include ---------------------------------------------------------------

#include "dialogs.hrc" // -> RID_SVXSTR_LANGUAGE_TABLE
#include "dialmgr.hxx"
#include "langtab.hxx"

#ifndef _SHL_HXX //autogen
#include <tools/shl.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

//------------------------------------------------------------------------

SvxLanguageTable::SvxLanguageTable() :

	ResStringArray( SVX_RES( RID_SVXSTR_LANGUAGE_TABLE ) )

{
}

//------------------------------------------------------------------------

SvxLanguageTable::~SvxLanguageTable()
{
}

//------------------------------------------------------------------------

const String& SvxLanguageTable::GetString( const LanguageType eType ) const
{
    // no_NO is an alias for nb_NO
    LanguageType eLang = (eType == LANGUAGE_NORWEGIAN ?
            LANGUAGE_NORWEGIAN_BOKMAL : eType);
	USHORT nPos = FindIndex( (long)eLang );

	if ( RESARRAY_INDEX_NOTFOUND != nPos && nPos < Count() )
		return ResStringArray::GetString( nPos );
	else
	{
        // If we knew what a simple "en" should alias to (en_US?) we could
        // generally raise an error.
        if ( LANGUAGE_ENGLISH != eLang )
            DBG_ERROR( "language entry not found in resource" );
        
        nPos = FindIndex( (long)LANGUAGE_DONTKNOW );

		if ( RESARRAY_INDEX_NOTFOUND != nPos && nPos < Count() )
			return ResStringArray::GetString( nPos );
	}
    static String aEmptyStr;
    return aEmptyStr;
}

//------------------------------------------------------------------------

LanguageType SvxLanguageTable::GetType( const String& rStr ) const
{
	LanguageType eType = LANGUAGE_DONTKNOW;
	USHORT nCount = Count();

	for ( USHORT i = 0; i < nCount; ++i )
		if ( rStr == ResStringArray::GetString( i ) )
		{
			eType = LanguageType( GetValue( i ) );
			break;
		}
	return eType;
}

//------------------------------------------------------------------------

USHORT SvxLanguageTable::GetEntryCount() const
{
	return Count();
}
	
//------------------------------------------------------------------------

LanguageType SvxLanguageTable::GetTypeAtIndex( USHORT nIndex ) const
{
	LanguageType nType = LANGUAGE_DONTKNOW;
	if (nIndex < Count())
		nType = LanguageType( GetValue( nIndex ) );
	return nType;
}

//------------------------------------------------------------------------

