/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: path.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:28:58 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef UDM_PATH_HXX
#define UDM_PATH_HXX



// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
#include <udm/step.hxx>
	// PARAMETERS


namespace udm
{


/** @description
*/
class Path
{
  public:
    // LIFECYCLE
                        Path();
                        ~Path();

    void                AddStep(
                            DYN Step &          let_drStep );
    // OPERATORS
    Object              operator()(
                            const Struct &      i_rData ) const;
  private:
    typedef std::vector< Step* >      StepList;
    StepList            aSteps;
};




// IMPLEMENTATION


inline void
Path::AddStep( DYN Step & let_drStep )
{
 	aSteps.push_back(&let_drStep);
}



}   // namespace udm



#endif


