
#ifndef __ACPID_DRIVER_NETLINK__
#define __ACPID_DRIVER_NETLINK__

#include <acpid/driver.h>

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <syslog.h>
#include <fcntl.h>
#include <net/if_arp.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <string.h>
#include <errno.h>
#include <time.h>
#include <sys/uio.h>

#include <asm/types.h>
#include <linux/netlink.h>

struct acpi_channel_private {
	int fd;
	struct sockaddr_nl local;
	__u32 seq;
};

#define NLMSG_TAIL(nlh) ((struct nlattr *) (((void *) (nlh)) + NLMSG_ALIGN((nlh)->nlmsg_len)))

#define NLA_OK(rta,len) ((len) >= (int)sizeof(struct nlattr) && \
			 (rta)->nla_len >= sizeof(struct nlattr) && \
			 (rta)->nla_len <= (len))
#define NLA_NEXT(rta,attrlen)	((attrlen) -= NLA_ALIGN((rta)->nla_len), \
				 (struct nlattr*)(((char*)(rta)) + NLA_ALIGN((rta)->nla_len)))
#define NLA_LENGTH(len)	(NLA_ALIGN(sizeof(struct nlattr)) + (len))
#define NLA_SPACE(len)	NLA_ALIGN(NLA_LENGTH(len))
#define NLA_DATA(rta)   ((void*)(((char*)(rta)) + NLA_LENGTH(0)))
#define NLA_PAYLOAD(rta) ((int)((rta)->nla_len) - NLA_LENGTH(0))

struct acpi_genl_event {
        char device_class[20];
        char bus_id[15];
        __u32 type;
        __u32 data;
};


#define GENL_NAMSIZ	16	/* length of family name */

#define GENL_MIN_ID	NLMSG_MIN_TYPE
#define GENL_MAX_ID	1023

struct genlmsghdr {
	__u8	cmd;
	__u8	version;
	__u16	reserved;
};

#define GENL_HDRLEN	NLMSG_ALIGN(sizeof(struct genlmsghdr))

#define GENL_ADMIN_PERM		0x01
#define GENL_CMD_CAP_DO		0x02
#define GENL_CMD_CAP_DUMP	0x04
#define GENL_CMD_CAP_HASPOL	0x08

/*
 * List of reserved static generic netlink identifiers:
 */
#define GENL_ID_GENERATE	0
#define GENL_ID_CTRL		NLMSG_MIN_TYPE

/**************************************************************************
 * Controller
 **************************************************************************/

enum {
	CTRL_CMD_UNSPEC,
	CTRL_CMD_NEWFAMILY,
	CTRL_CMD_DELFAMILY,
	CTRL_CMD_GETFAMILY,
	CTRL_CMD_NEWOPS,
	CTRL_CMD_DELOPS,
	CTRL_CMD_GETOPS,
	CTRL_CMD_NEWMCAST_GRP,
	CTRL_CMD_DELMCAST_GRP,
	CTRL_CMD_GETMCAST_GRP, /* unused */
	__CTRL_CMD_MAX,
};

#define CTRL_CMD_MAX (__CTRL_CMD_MAX - 1)

enum {
	CTRL_ATTR_UNSPEC,
	CTRL_ATTR_FAMILY_ID,
	CTRL_ATTR_FAMILY_NAME,
	CTRL_ATTR_VERSION,
	CTRL_ATTR_HDRSIZE,
	CTRL_ATTR_MAXATTR,
	CTRL_ATTR_OPS,
	CTRL_ATTR_MCAST_GROUPS,
	__CTRL_ATTR_MAX,
};

#define CTRL_ATTR_MAX (__CTRL_ATTR_MAX - 1)

enum {
	CTRL_ATTR_OP_UNSPEC,
	CTRL_ATTR_OP_ID,
	CTRL_ATTR_OP_FLAGS,
	__CTRL_ATTR_OP_MAX,
};

#define CTRL_ATTR_OP_MAX (__CTRL_ATTR_OP_MAX - 1)

enum {
	CTRL_ATTR_MCAST_GRP_UNSPEC,
	CTRL_ATTR_MCAST_GRP_NAME,
	CTRL_ATTR_MCAST_GRP_ID,
	__CTRL_ATTR_MCAST_GRP_MAX,
};
#define CTRL_ATTR_MCAST_GRP_MAX (__CTRL_ATTR_MCAST_GRP_MAX - 1)

/* attributes of acpi_genl_family */
enum {
        ACPI_GENL_ATTR_UNSPEC,
        ACPI_GENL_ATTR_EVENT,   /* ACPI event info needed by user space */
        __ACPI_GENL_ATTR_MAX,
};
#define ACPI_GENL_ATTR_MAX (__ACPI_GENL_ATTR_MAX - 1)

/* commands supported by the acpi_genl_family */
enum {
        ACPI_GENL_CMD_UNSPEC,
        ACPI_GENL_CMD_EVENT,    /* kernel->user notifications for ACPI events */        __ACPI_GENL_CMD_MAX,
};
#define ACPI_GENL_CMD_MAX (__ACPI_GENL_CMD_MAX - 1)
#define GENL_MAX_FAM_OPS        256
#define GENL_MAX_FAM_GRPS       256


#endif /* __ACPID_DRIVER_NETLINK__ */

