/*
                               Style Edit

	A widget used to display and edit GTK styles.
 */

#ifndef STYLE_EDIT_H
#define STYLE_EDIT_H

#include <gtk/gtk.h>


typedef struct _style_edit_struct	style_edit_struct;
#define STYLE_EDIT(p)		((style_edit_struct *)(p))


/*
 *	Total number of style states:
 *
 *	Must match number of GTK_STATE_*s.
 */
#define STYLE_EDIT_STATES		5


/*
 *	Style Edit:
 */
struct _style_edit_struct {

	GtkWidget	*toplevel,
			*state_previous_btn,
			*state_entry,
			*state_next_btn,
			*font_name_prompt,
			*fg_color_btn,
			*bg_color_btn,
			*text_color_btn,
			*base_color_btn,
			*bg_pixmap_name_entry,
			*preview_da;

	gint		freeze_count;

	GtkStateType	prev_state;
	GtkAdjustment	*state_adj;

	GtkRcStyle	*style;

	void		(*changed_cb)(
		style_edit_struct *,	/* Style Edit */
		gpointer		/* Data */
	);
	gpointer	changed_client_data;

};


GtkStateType StyleEditCurrentState(style_edit_struct *se);

extern style_edit_struct *StyleEditNew(
	GtkWidget *parent, const gchar *name
);
extern void StyleEditDelete(style_edit_struct *se);

extern void StyleEditSetStyle(style_edit_struct *se, const GtkRcStyle *style);
extern GtkRcStyle *StyleEditGetStyle(style_edit_struct *se);
extern void StyleEditRestoreDefaultStyle(style_edit_struct *se);

extern void StyleEditSetChangedCB(
	style_edit_struct *se,
	void (*changed_cb)(
		style_edit_struct *,
		gpointer
	),
        gpointer changed_client_data
);


#endif	/* STYLE_EDIT_H */
