# (c) 2006-10-17 by Nigel Tao <nigeltao@gnome.org>, GPL licensed.
#
# Shortcuts for Epiphany's searches, shared with the deskbar applet.


import epiphany, gnomevfs, os


def load_map():
	global sc_bm_map, shortcuts_file
	sc_bm_map.clear()
	try:
		for line in file(shortcuts_file):
			line = line.strip()
			if len(line) > 0:
				try:
					url, shortcut = line.split()
					sc_bm_map[shortcut] = url
				except ValueError:
					# Ignore badly formatted lines.
					pass
	except IOError:
		# The file probably does not exist.  Ignore the error.
		pass


def on_vfs_monitor(monitored_uri, altered_uri, event_type):
	load_map()


def resolve_address_cb(bookmarks, address, smart_bookmark_content):
	global sc_bm_map
	address = address.strip()
	n = address.find(' ')
	if n == -1:
		shortcut, args = address, ''
	else:
		shortcut, args = address[:n], address[n+1:]
	try:
		return sc_bm_map[shortcut].replace('%s', args)
	except KeyError:
		return None


def extension_initialize():
	global gnomevfs_id, shortcuts_file
	bookmarks = epiphany.ephy_shell_get_default().get_bookmarks()
	# bmsc stands for BookMark ShortCut.
	bookmarks._bmsc_signal = bookmarks.connect('resolve-address',
	                                           resolve_address_cb)
	load_map()
	gnomevfs_id = gnomevfs.monitor_add('file://' + shortcuts_file,
	                                   gnomevfs.MONITOR_FILE,
	                                   on_vfs_monitor)


def extension_finalize():
	global gnomevfs_id
	bookmarks = epiphany.ephy_shell_get_default().get_bookmarks()
	signal = bookmarks._bmsc_signal
	del bookmarks._bmsc_signal
	bookmarks.disconnect(signal)
	if gnomevfs_id != None:
		gnomevfs.monitor_cancel(gnomevfs_id)
		gnomevfs_id = None


def attach_window(window):
	# I don't think that there is a race condition with this a_w_c variable,
	# since this code all happens in the GUI thread...
	global attached_window_count
	if attached_window_count == 0:
		extension_initialize()
	attached_window_count = attached_window_count + 1


def detach_window(window):
	global attached_window_count
	attached_window_count = attached_window_count - 1
	if attached_window_count == 0:
		extension_finalize()


shortcuts_file = os.path.expanduser(
                 "~/.gnome2/deskbar-applet/search-bookmarks-shortcuts.txt")
attached_window_count = 0
gnomevfs_id = None
sc_bm_map = {}  # map from ShortCuts to (smart) BookMarks
