/*
 *	PROGRAM:	JRD Access Method
 *	MODULE:		MBLR.H
 *	DESCRIPTION:	Meta-data update language
 *
 * The contents of this file are subject to the Interbase Public
 * License Version 1.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy
 * of the License at http://www.Inprise.com/IPL.html
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code was created by Inprise Corporation
 * and its predecessors. Portions created by Inprise Corporation are
 * Copyright (C) Inprise Corporation.
 *
 * All Rights Reserved.
 * Contributor(s): ______________________________________.
 */

#ifndef JRD_MBLR_H
#define JRD_MBLR_H

const UCHAR mblr_null				= 0;

const UCHAR mblr$k_modify			= 1;
const UCHAR mblr$k_define			= 2;
const UCHAR mblr$k_delete			= 3;

const UCHAR mblr$k_version_1		= 1;

const UCHAR mblr$k_cdd_path			= 5;
const UCHAR mblr$k_change_field		= 6;
const UCHAR mblr$k_constraint		= 7;
const UCHAR mblr$k_constraint_def	= 8;
const UCHAR mblr$k_constraint_end	= 9;
const UCHAR mblr$k_descriptor		= 10;
const UCHAR mblr$k_define_field		= 11;
const UCHAR mblr$k_delete_field		= 12;
const UCHAR mblr$k_dtr_def_val		= 13;
const UCHAR mblr$k_dtr_edit_str		= 14;
const UCHAR mblr$k_dtr_qry_hdr		= 15;
const UCHAR mblr$k_dtr_qry_hdr_line	= 16;
const UCHAR mblr$k_dtr_qry_hdr_end	= 17;
const UCHAR mblr$k_duplicates		= 18;
const UCHAR mblr$k_field_def		= 19;
const UCHAR mblr$k_field_end		= 20;
const UCHAR mblr$k_field_expression	= 21;
const UCHAR mblr$k_field_name		= 22;
const UCHAR mblr$k_field_noupdate	= 23;
const UCHAR mblr$k_field_update		= 24;

const UCHAR mblr$k_index_def		= 26;
const UCHAR mblr$k_index_end		= 27;
const UCHAR mblr$k_missing_value	= 28;

const UCHAR mblr$k_relation_def		= 31;
const UCHAR mblr$k_relation_end		= 32;
const UCHAR mblr$k_relation_name	= 33;
const UCHAR mblr$k_rse				= 34;
const UCHAR mblr$k_valid_if			= 35;
const UCHAR mblr$k_view_def			= 36;
const UCHAR mblr$k_view_end			= 37;
const UCHAR mblr$k_change_attributes= 38;
const UCHAR mblr$k_delete_attributes= 39;
const UCHAR mblr$k_commit			= 40;
const UCHAR mblr$k_update			= 41;
const UCHAR mblr$k_dtr_qry_nam		= 42;
const UCHAR mblr$k_valid_if_source	= 43;
const UCHAR mblr$k_computed_by_source	= 44;
const UCHAR mblr$k_rse_source		= 45;
const UCHAR mblr$k_constraint_count	= 46;

const UCHAR mblr$k_description_source	= 51;
const UCHAR mblr$k_sub_type			= 52;
const UCHAR mblr$k_segment_length	= 53;

const UCHAR mblr$k_index_unknown1	= 75;
const UCHAR mblr$k_index_unknown2	= 76;

const UCHAR mblr_max				= 54;	/* the display table only goes this high */

// type it is as int in mblr.cpp but blr_ is defined as USHORT 
//
const int dsc$k_dtype_qu			= 5;	/* a segmented string */
const int dsc$k_dtype_b				= 6;	/* ? blr_text & special case to be length 1 ? */
const int dsc$k_dtype_w				= blr_short;
const int dsc$k_dtype_l				= blr_long;
const int dsc$k_dtype_q				= blr_quad;
const int dsc$k_dtype_f				= blr_float;
const int dsc$k_dtype_g				= blr_double;
const int dsc$k_dtype_d				= blr_d_float;
const int dsc$k_dtype_t				= blr_text;
const int dsc$k_dtype_vt			= blr_varying;
const int dsc$k_dtype_adt			= blr_timestamp;

#endif /* JRD_MBLR_H */
