#include "cmdline_hist.h"

#include "debug.h"

QString CmdLineHistory::getNext(QString key)
{
	kdebugf();
	if ( histSize == 0 )
		return QString::null;

	if ( !chatHistories.contains( key ) )
		return QString::null;

	QStringList* list = chatHistories[key];
	uint *idx = chatHistoryIndexes[key];

	if ( list->count() == 0 )
		return QString::null;

	// Incrementing index and returning the value
	uint index = (*idx);
	if ( index < list->count()-1 )
		index++;

	(*idx) = index;
	kdebugf2();
	return (*list)[index];
}

QString CmdLineHistory::getPrev(QString key, QString msg)
{
	kdebugf();
	if ( histSize == 0 )
		return QString::null;

	if ( !chatHistories.contains( key ) )
		return QString::null;

	QStringList* list = chatHistories[key];
	uint *idx = chatHistoryIndexes[key];

	if ( list->count() == 0 )
		return QString::null;

	uint index = (*idx);

	// Adding current contents to make returning to it possible
	if ( index == list->count() || index == list->count()-1 && lastTemp )
	{
		if ( lastTemp )
		{
			list->last() = msg;
		}
		else
		{
			addLine(key, msg);
			lastTemp = true;
		}
	}

	// Decrementing index and returning the value
	if ( index > 0 )
		index--;

	(*idx) = index;
	kdebugf2();
	return (*list)[index];
}

void CmdLineHistory::messageSent(QString key, QString msg)
{
	kdebugf();
	if ( histSize == 0 )
		return;

	QStringList* list = 0;
	uint *idx = 0;
	if ( !chatHistories.contains( key ) )
	{
		list = new QStringList();
		idx = new uint(0);
		chatHistories[key] = list;
		chatHistoryIndexes[key] = idx;
	}
	else
	{
		list = chatHistories[key];
		idx = chatHistoryIndexes[key];
	}

	// Removing last element if it was marked as templorary
	if ( lastTemp )
	{
		if (!list->isEmpty())
			list->pop_back();
		lastTemp = false;
	}

	bool found = false;
	for ( QStringList::Iterator it = list->begin(); it != list->end(); ++it )
	{
		if ( (*it) == msg )
		{
			found = true;
			break;
		}
	}
	if ( !found )
		addLine(key, msg);

	(*idx) = list->count();
	kdebugf2();
}

void CmdLineHistory::reset(QString key)
{
	kdebugf();
	if ( histSize == 0 )
		return;

	QStringList* list = 0;
	uint *idx = 0;
	if ( !chatHistories.contains( key ) )
	{
		list = new QStringList();
		idx = new uint(0);
	}
	else
	{
		list = chatHistories[key];
		idx = chatHistoryIndexes[key];
	}

	if ( list->count() == 0 )
		return;

	(*idx) = list->count();
	kdebugf2();
}

void CmdLineHistory::addLine(QString key, QString msg)
{
	kdebugf();
	if ( histSize == 0 )
		return;

	if ( !chatHistories.contains( key ) )
		return;

	QStringList* list = chatHistories[key];

	list->append( msg );
	if ( lastTemp )
	{
		while ( list->count() > histSize )
			list->pop_front();
	}
	else
	{
		while ( list->count() > histSize+1 )
			list->pop_front();
	}
	kdebugf2();
}
