/***************************************************************************
                          kmessapplication.h -  description
                             -------------------
    begin                : Wed 7 13 2005
    copyright            : (C) 2005 by Diederik van der Boor
    email                : vdboor --at-- codingdomain.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMESSAPPLICATION_H
#define KMESSAPPLICATION_H

#include <kapplication.h>
#include <kdeversion.h>

class KMess;

/**
 * @author Mike K. Bennett (original work), Diederik van der Boor (new class)
 */
class KMessApplication : public KApplication
{
  public:
    // Constructor
                KMessApplication();

    // Destructor
    virtual    ~KMessApplication();

#if KDE_IS_VERSION(3,1,1)
    // KDE has a sessionSaving() method
#else
    // QApplication wants to save the session
    virtual void commitData(QSessionManager &sm);
    // Return true if we're saving the session (for queryExit())
    bool         sessionSaving() const;
#endif

    // Return true if quit was selected
    bool         quitSelected() const;
    // Tell the application that quit was selected
    void         setQuitSelected(bool quitSelected);

  private:
    // True when entering the commitData() method
    bool         savingSession_;
    // True when quit was selected
    bool         quitSelected_;
};

#endif
