/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Sun Jan  5 15:18:36 CST 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include "kmess.h"
#include "kmesstest.h"
#include "kmessdebug.h"
#include "kmessapplication.h"

#ifdef HAVE_CONFIG_H
 #include "config.h"
#endif

#ifdef ENABLE_BINRELOC
// Required for autopackage support, this
// defines PREFIX as a dynamic/run-time version.
#include "prefix.h"
#include <string.h>
#include <kiconloader.h>
#include <kstandarddirs.h>
#endif


// Command line options
static KCmdLineOptions kmessOptions[] =
{
  { "autologin ", I18N_NOOP("Autologin with the given email address"), 0 },
  { 0, 0, 0 }
};


// Main starting point of the application
int main(int argc, char *argv[])
{
  // Information for Tab 1 (general)
  KAboutData aboutData( "kmess",                 /* internal app name */
                        I18N_NOOP("KMess"),      /* real program name */
                        VERSION,                 /* app version (from config.h, generated with Makefile.am) */
                        "KMess",                 /* description of the app */
                        KAboutData::License_GPL, /* license */
                        "(c) 2002-2005, Mike K. Bennett\n"        /* copyright */
                        "(c) 2005, Diederik van der Boor\n",
                        "A MSN Messenger client for KDE",    /* free form text */
                        "http://kmess.sourceforge.net/",     /* project home page */
                        "codingdomain@users.sourceforge.net" /* address for bugs */
                      );

  // Information for Tab 2 (authors)
  // TOOD: escape the special characters to some Unicode format. (how?)
  aboutData.addAuthor("Mike K. Bennett", 0, "mkb137@users.sourceforge.net");
  aboutData.addAuthor("Michael Curtis", 0, "mdcurtis@users.sourceforge.net");
  aboutData.addAuthor("Jan Tönjes", 0,"jan.toenjes@web.de");
  aboutData.addAuthor("Lin Haoxiang",0,"linhaoxiang@hotmail.com");
  aboutData.addAuthor("Diederik van der Boor",0,"vdboor@codingdomain.com");

  // Information for Tab 3 (credits)
  aboutData.addCredit("Jan Tönjes",I18N_NOOP("German translation, testing, documentation, web master, project management, etc..."),"jan.toenjes@web.de");
  aboutData.addCredit("Dane Harnett", I18N_NOOP("Web design"), "dynamitedane@hotmail.com");
  aboutData.addCredit("Christian Lundgren", I18N_NOOP("Swedish translation"), "zeflunk@gmail.com");
  aboutData.addCredit("Matjaž kaše", I18N_NOOP("Slovenian translation"), "matjaz.kase@g-kabel.si");
  aboutData.addCredit("Johanna Gersch",I18N_NOOP("Spanish translation"));
  aboutData.addCredit("Gorkem Cetin",I18N_NOOP("Turkish translation"),"gorkem@gelecek.com.tr");
  aboutData.addCredit("Mauricio Rother",I18N_NOOP("Brazilian Portuguese translation"),"mauricio@digicomm.com.br");
  aboutData.addCredit("David Vignoni",I18N_NOOP("The main and yellow/blue/violet emoticon sets and Italian translation"),"dvgn@libero.it");
  aboutData.addCredit("Laurence Anderson",I18N_NOOP("Original file receive code"),"l.d.anderson@warwick.ac.uk");
  aboutData.addCredit("J.C.A. Javi",I18N_NOOP("more Spanish translation"),"yovoya30ks@hotmail.com");
  aboutData.addCredit("Arend van Beelen Jr.",I18N_NOOP("Dutch translation"),"arend@auton.nl");
  aboutData.addCredit("Scott Morgan",I18N_NOOP("Xinerama fixes"),"blumf@blumf.freeserve.co.uk");
  aboutData.addCredit("Julien Joubin",I18N_NOOP("Cartoon emoticons"),"jujubinche@netscape.net");
  aboutData.addCredit("Christian Müller",I18N_NOOP("Default sound theme"),"cmue81@gmx.de");
  aboutData.addCredit("Mohamed Aser",I18N_NOOP("Arabic translation, internationalization of file saving fix."),"mohasr@link.net");
  aboutData.addCredit("Choe Hwanjin",I18N_NOOP("Various internationalization fixes."),"hjchoe@hancom.com");
  aboutData.addCredit("Choplair",I18N_NOOP("French translation"),"pachilor@yahoo.co.jp");
  aboutData.addCredit("Vincent Fretin", I18N_NOOP("More French translation, MSN6 emoticon definitions"),"fretinvincent@hotmail.com");
  aboutData.addCredit("Park Dong Cheon",I18N_NOOP("Korean translation"),"pdc@kaist.ac.kr");
  aboutData.addCredit("Øyvind Sæther",I18N_NOOP("Norsk Bokmal tranlation"),"oyvind@sather.tk");
  aboutData.addCredit("Rachan Hongpairote",I18N_NOOP("Thai tranlation"),"rachanh@yahoo.com");
  aboutData.addCredit("Lin Haoxiang",I18N_NOOP("Simplified Chinese tranlation, file send bug fix"),"linhaoxiang@hotmail.com");
  aboutData.addCredit("Yen-chou Chen",I18N_NOOP("Traditional Chinese tranlation"),"yenchou.mse90@nctu.edu.tw");
  aboutData.addCredit("Jaume Cornadó",I18N_NOOP("Catalan tranlation"),"jaumec@lleida.net");
  aboutData.addCredit("Barbaros Ulutas",I18N_NOOP("More Turkish translation"),"tebarul@yahoo.com");
  aboutData.addCredit("Tobias Tönjes",I18N_NOOP("Guy with a bag over his head"),"");
  aboutData.addCredit("Damien Sandras",I18N_NOOP("GnomeMeeting developer"),"dsandras@seconix.com");
  aboutData.addCredit("Lars Sommer",I18N_NOOP("Danish tranlation"),"admin@lasg.dk");
  aboutData.addCredit("Jyri Toomessoo",I18N_NOOP("Estonian tranlation"),"nuubik@hotmail.com");
  aboutData.addCredit("Alejandro Araiza Alvarado",I18N_NOOP("more Spanish translation"),"mebrelith@gmail.com");
  aboutData.addCredit("KMerlin (kmerlin.olsd.de)",I18N_NOOP("Inspiration and assorted code"));
  aboutData.addCredit("Kopete (kopete.kde.org)", I18N_NOOP("Popup Balloon code, initial p2p code"));
  aboutData.addCredit("KScreensaver",I18N_NOOP("Idle timer code"));

  aboutData.setTranslator(I18N_NOOP("_: NAME OF TRANSLATORS\nYour names"),I18N_NOOP("_: EMAIL OF TRANSLATORS\nYour emails"));


  // Register the command line parameters
  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( kmessOptions );


  // Fetch the command line arguments
  KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
  QString autologinHandle = args->getOption("autologin");


  // Create the KApplication object
  KMessApplication a;


#ifdef ENABLE_BINRELOC
  // Register run-time detected PREFIX for Autopackage support
  // This also prevents the "square boxes images" problem from happening
  // if the --prefix was incorrect.
  KGlobal::dirs()       -> addPrefix( strdup(PREFIX)  );
  KGlobal::iconLoader() -> addAppDir( strdup(DATADIR) );
#endif

  // Create the main window  (inherits KMessInterface and KMainWindow)
  KMess *kmess = new KMess(0, "mainwindow");

  // Initialize the main window
  if( kmess->initialize() )
  {
    // Set as main widget
    a.setMainWidget(kmess);
    kmess->show();
    kmess->checkAutologin( autologinHandle );

/*
    // For debugging:
#ifdef KMESSTEST
    KMessTest *kmessTest = new KMessTest(kmess);
    kmessTest->test();
    delete kmessTest;
#endif
*/
  }

  // Start the application + event loop
  return a.exec();
}
