/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   @description This class imports a certificate                             *
*                                                                         *
*   @author Christoph Thielecke <crissi99@gmx.de>                    *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
//BEGIN includes
#include "importcertificatedialog.h"
#include <kmessagebox.h>
#include <klocale.h>
#include <kurlrequester.h>
#include <kpassdlg.h>
#include <kcombobox.h>
#include <kdebug.h>
#include <klineedit.h>
#include <iostream>
#include <qfile.h>
#include <qdir.h>
#include <qtextstream.h>
#include <qcursor.h>
#include <qurl.h>
#include <iostream>
#include "kvpncconfig.h"
#include "utils.h"
//END includes

ImportCertificateDialog::ImportCertificateDialog( QWidget *parent, const char* caption, KVpncConfig *GlobalConfig)
		: KDialogBase( parent, i18n("Import Certificate").ascii(), true, caption,
		               KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, true )
{
	main = new ImportCertificateDialogBase(this);
	setMainWidget(main);
	main->setMinimumSize(main->sizeHint());

	this->GlobalConfig = GlobalConfig;
	filename = "";
	certHash = "";
	CertFullPath="";
	CaCertFullPath="";
	importOk = false;
	importSuccess = true;
	doHash = false;
	doExit=true;
	certName = "";
	certpath = "/etc/racoon/certs/";
	pathToOpenSSL = GlobalConfig->pathToOpenssl;
	main->RacoonCertificatePathUrlrequester->setMode( 2 ); // directory
	main->FilenameUrlrequester->setFilter( "*.p12" );

	connect (main->ImporttypeComboBox, SIGNAL(activated(int)), this, SLOT(typeToggeled(int)));
	typeToggeled( main->ImporttypeComboBox->currentItem() );


	// TMP
	/*
		main->FilenameUrlrequester->setURL( "/home/crissi/thielecke.p12" );
		//main->RacoonCertificatePathUrlrequester->setURL( "/etc/racoon/certs/" );
	main->ImporttypeComboBox->setCurrentItem( 1 );
		main->PrivateKeyPasswordEdit->setText( "12345678" );
		main->PrivateKeyAgainPasswordEdit->setText( "12345678" );
	*/
	//main->ImportPasswordEdit->setText( "blah99" );


}

ImportCertificateDialog::~ImportCertificateDialog()
{
	delete main;
}

void ImportCertificateDialog::accept()
{

	importOk = true;
	done=false;

	filename = main->FilenameUrlrequester->url();
	importpassword = main->ImportPasswordEdit->text();
	certpath = main->RacoonCertificatePathUrlrequester->url();

	if ( filename.isEmpty() )
	{
		KMessageBox::sorry( 0, i18n( "File name cannot be empty!" ), i18n( "Empty File Name" ) );
		importOk = false;
		importSuccess=false;
		return;
	}

	// 	if ( filename.right( 3 ) != "p12" || filename.right (3) != "der" || filename.right (3) != "crt" ) {
	// 		KMessageBox::sorry( 0, i18n( "File name isnt ended by \'p12\', 'der' or \'crt\'!" ), i18n( "Wrong File Name" ) );
	// 		importOk = false;
	// 		return;
	// 	}

	GlobalConfig->appPointer->setOverrideCursor( QCursor(Qt::WaitCursor) );

	QFile f( filename );
	if ( f.exists() )
	{
		if ( f.open( IO_ReadOnly ) )
		{
			f.close();
		}
		else
		{
			KMessageBox::sorry( 0, i18n( "File does not exist!" ), i18n( "No File" ) );
			GlobalConfig->appendLogEntry ( i18n( "Certificate import: file \"%1\" does not exist." ).arg( filename ),GlobalConfig->error );

			importOk = false;
			GlobalConfig->appPointer->restoreOverrideCursor();
			return;
		}
	}
	else
	{
		KMessageBox::sorry( 0, i18n( "File not readable!" ), i18n( "Insufficient Rights" ) );

		GlobalConfig->appendLogEntry ( i18n( "Certificate import: file \"%1\" is not readable." ).arg( filename ),GlobalConfig->error );
		importOk = false;
		GlobalConfig->appPointer->restoreOverrideCursor();
		return;
	}

	if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan )
	{
		certpath="/etc/ipsec.d";
		if ( !QDir(certpath).exists())
		{
			if (!QDir().mkdir(certpath))
			{
				KMessageBox::error( this, i18n( "\"%1\" could not be created!" ).arg( "/etc/ipsec.d" ) );
				GlobalConfig->appendLogEntry ( i18n( "Certificate import: directory \"%1\" does not exist and could not be created." ).arg( "/etc/ipsec.d" ),GlobalConfig->error );
			}
			else
			{
				if (GlobalConfig->KvpncDebugLevel > 0 )
					GlobalConfig->appendLogEntry ( i18n( "Certificate import: directory \"%1\" does not exist but was successful created." ).arg( "/etc/ipsec.d" ),GlobalConfig->debug );
				if ( !QDir("/etc/ipsec.d/certs").exists())
				{
					if (!QDir().mkdir("/etc/ipsec.d/certs"))
					{
						KMessageBox::error( this, i18n( "\"%1\" could not be created!" ).arg( "/etc/ipsec.d/certs" ) );
						GlobalConfig->appendLogEntry ( i18n( "Certificate import: directory \"%1\" does not exist and could not be created." ).arg("/etc/ipsec.d/certs" ),GlobalConfig->error );
					}
					else
					{
						GlobalConfig->appendLogEntry ( i18n( "Certificate import: directory \"%1\" does not exist but was successful created." ).arg( "/etc/ipsec.d/certs" ),GlobalConfig->debug );
						if ( !QDir("/etc/ipsec.d/cacerts").exists())
							if (!QDir().mkdir("/etc/ipsec.d/cacerts"))
							{
								KMessageBox::error( this, i18n( "\"%1\" could not be created!" ).arg( "/etc/ipsec.d/cacerts" ) );
								GlobalConfig->appendLogEntry ( i18n( "Certificate import: directory \"%1\" does not exist and could not  be created." ).arg( "/etc/ipsec.d/cacerts" ),GlobalConfig->error );
							}
							else
							{
								if (GlobalConfig->KvpncDebugLevel > 0 )
									GlobalConfig->appendLogEntry ( i18n( "Certificate import: directory \"%1\" does not exist but was successful created." ).arg( "/etc/ipsec.d/cacerts" ),GlobalConfig->debug );
							}
					}
				}
			}
		}
	}
	else if ( main->ImporttypeComboBox->currentItem() == pkcs12_racoon || main->ImporttypeComboBox->currentItem() == ca_der )
	{
		certpath="/etc/racoon/certs";
		if ( !QDir(certpath).exists())
			if (!QDir().mkdir(certpath))
			{
				KMessageBox::error( this, i18n( "\"%1\" could not be created!" ).arg( certpath ) );
				GlobalConfig->appendLogEntry ( i18n( "Certificate import: directory \"%1\" does not exist." ).arg( certpath ),GlobalConfig->error );
			}
			else
			{
				if (GlobalConfig->KvpncDebugLevel > 0 )
					GlobalConfig->appendLogEntry ( i18n( "Certificate import: directory \"%1\" does not exist but was successful created." ).arg( certpath ),GlobalConfig->debug );
			}
	}
	else if ( main->ImporttypeComboBox->currentItem() == pkcs12_openvpn )
	{
		certpath="/etc/openvpn";
		if ( !QDir(certpath).exists())
			if (!QDir().mkdir(certpath))
			{
				KMessageBox::error( this, i18n( "\"%1\" could not be created!" ).arg( certpath ) );
				GlobalConfig->appendLogEntry ( i18n( "Certificate import: directory \"%1\" does not exist." ).arg( certpath ),GlobalConfig->error );
			}
			else
			{
				if (GlobalConfig->KvpncDebugLevel > 0 )
					GlobalConfig->appendLogEntry ( i18n( "Certificate import: directory \"%1\" does not exist but was successful created." ).arg( certpath ),GlobalConfig->debug );
			}
	}

// 	if ( (main->ImporttypeComboBox->currentItem() == pkcs12_freeswan ||
// 	        main->ImporttypeComboBox->currentItem() == pkcs12_racoon ||
// 					main->ImporttypeComboBox->currentItem() == pkcs12_racoon
// 			) &&
// 	        importpassword.isEmpty() )
// 	{
// 		importOk = false;
// 		KMessageBox::sorry( 0, i18n( "Password can't be empty!" ), i18n( "Empty Password" ) );
// 		return;
// 	}

	if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan )
	{
		if ( main->PrivateKeyPasswordEdit->text().isEmpty() || main->PrivateKeyPasswordEdit->text().length() < 4  )
		{
			importOk = false;
			KMessageBox::sorry( 0, i18n( "Private key password field can not be empty or less than 4 characters!" ), i18n( "Password Empty or Too Short" ) );
			return;
		}

		if ( main->PrivateKeyAgainPasswordEdit->text().isEmpty() || main->PrivateKeyAgainPasswordEdit->text().length() < 4 )
		{
			importOk = false;
			KMessageBox::sorry( 0, i18n( "Private key password (again) field can not be empty!" ), i18n( "Password Empty or Too Short" ) );
			return;
		}
		if ( importOk )
		{
			if ( main->PrivateKeyPasswordEdit->text() != main->PrivateKeyAgainPasswordEdit->text() )
			{
				importOk = false;
				KMessageBox::sorry( 0, i18n( "Private key passwords does not match!" ), i18n( "Passwords Do Not Match" ) );
				return;
			}
			else
			{
				privatekeypassword= main->PrivateKeyAgainPasswordEdit->text();
			}
		}
	}

	if (GlobalConfig->KvpncDebugLevel > 0 )
		kdDebug() << "file: " << filename << ", type: " << main->ImporttypeComboBox->currentItem() << endl;

	// looking for openssl
	bool found=true;
	QString bin="openssl";
	ToolInfo *tool = Utils(GlobalConfig).getToolInfo(GlobalConfig,"openssl");
	//std::cout << "Tool (bin): " << bin << std::endl;

	if (tool->PathToExec.section('/',-1) != bin )
	{
		// program is NOT installed
		KMessageBox::error ( this, i18n( "The required tool (%1) is not installed, please install it first and restart kvpnc.").arg(bin), i18n( "Tool Missing" ) );
		found=false;
	}

	if( !found)
	{
		KMessageBox::error( this, i18n( "Unable to find \"%1\"!" ).arg("openssl") );
		GlobalConfig->appendLogEntry(i18n( "Unable to find \"%1\"!" ).arg("openssl") ,GlobalConfig->error);
		importOk = false;
	}


	QString file = QUrl ( filename ).fileName();
	certName = file.left( file.length() - 4 ); // peter_pan.p12 -> peter_pan

	if ( main->ImporttypeComboBox->currentItem() == pkcs12_racoon || main->ImporttypeComboBox->currentItem() == pkcs12_openvpn )
	{
		QString type="";
		if ( main->ImporttypeComboBox->currentItem() == pkcs12_racoon)
			type="racoon";
		else
			type="OpenVPN";

		QFile certpathtest( certpath + "/." );

		if ( !certpathtest.exists() )
		{
			KMessageBox::error( this, i18n( "%1 certificate path (%2) does not exist!" ).arg(type).arg( certpath ) );
			GlobalConfig->appendLogEntry(i18n( "%1 certificate path (%2) does not exist!" ).arg(type).arg( certpath ) ,GlobalConfig->error);
			importOk=false;
		}
		else
		{
			QFile testfile ( QString(certpath + "/test" ));
			if ( !testfile.open( IO_WriteOnly ) )
			{
				KMessageBox::error( this, i18n( "%1 certificate path (%2) is not writeable!" ).arg(type).arg( certpath ) );
				GlobalConfig->appendLogEntry(i18n( "%1 certificate path (%2) is not writeable!" ).arg(type).arg( certpath )  ,GlobalConfig->error);
				importOk = false;
			}
			else
			{
				testfile.remove();
			}
		}
	}

	// here we go
	if ( importOk )
	{

		/*
		FreeSWAN/Racoon:
		openssl pkcs12 -in cert.p12 -clcerts -out /etc/racoon/certs/mykeys_company.pem -nodes

		DER:
		openssl x509 -in cert.crt -out ca_company.pem -inform DER

		*/
		// 		 		std::cout << "[std]:" << "settings ok." << std::endl;

		ImportProcess = new QProcess( this )
		                ;
		ImportProcess->addArgument( pathToOpenSSL );

		if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan ||
		        main->ImporttypeComboBox->currentItem() == pkcs12_racoon ||
						main->ImporttypeComboBox->currentItem() == pkcs12_openvpn
		   )
		{
			ImportProcess->addArgument( "pkcs12" );
			ImportProcess->addArgument( "-in" );
			ImportProcess->addArgument( filename );
			ImportProcess->addArgument( "-nodes" );
			ImportProcess->addArgument( "-clcerts" );
			ImportProcess->addArgument( "-out" );
		}
		else if ( main->ImporttypeComboBox->currentItem() == ca_der )
		{
			ImportProcess->addArgument( "x509" );
			ImportProcess->addArgument( "-in" );
			ImportProcess->addArgument( filename );
			ImportProcess->addArgument( "-out" );
			ImportProcess->addArgument( certpath + "/ca_" + certName + ".pem" );
			ImportProcess->addArgument( "-inform" );
			ImportProcess->addArgument( "DER" );
		}
		if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan )
		{
			ImportProcess->addArgument( "/etc/ipsec.d/certs/mykeys_" + certName + ".pem" ); // warning: static
		}
		else if( main->ImporttypeComboBox->currentItem() == pkcs12_racoon || main->ImporttypeComboBox->currentItem() == pkcs12_openvpn )
		{
			ImportProcess->addArgument( certpath + "/mykeys_" + certName + ".pem" );
		}


		connect( ImportProcess, SIGNAL( readyReadStdout() ), this, SLOT( readFromStdout_import() ) );
		connect( ImportProcess, SIGNAL( readyReadStderr() ), this, SLOT( readFromStderr_import() ) );
		if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan ||
		        main->ImporttypeComboBox->currentItem() == pkcs12_racoon ||
						main->ImporttypeComboBox->currentItem() == pkcs12_openvpn
		   )
		{
			connect( ImportProcess, SIGNAL( processExited () ), this, SLOT( doCacert() ) );
		}
		if ( main->ImporttypeComboBox->currentItem() == ca_der)
		{
			connect( ImportProcess, SIGNAL( processExited () ), this, SLOT( doCreateHash() ) );
		}

		if ( !ImportProcess->start() )
		{
			KMessageBox::sorry( this, i18n( "Unable to start process (%1)!" ).arg("openssl") );
		}
		else
		{
			doExit=true;
			if (GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n( "Process (%1) started." ).arg( "openssl" ),GlobalConfig->debug );
		}
	}
}

void ImportCertificateDialog::canAccept()
{
	if (importSuccess)
	{
		KMessageBox::information( 0, i18n( "Certificate was sucessfully imported." ), i18n( "Import Successful" ) );
		if (GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry ( i18n( "Certificate import: certificate was successfully imported." ),GlobalConfig->debug );
	}
	else
	{
		KMessageBox::sorry( 0, i18n( "Certificate import failed." ), i18n( "Import Failed" ) );
		GlobalConfig->appendLogEntry ( i18n( "Certificate import: certificate could not be imported." ),GlobalConfig->error );
	}

	if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan)
	{
		QString bin="ipsec";
		ToolInfo *tool;
		//std::cout << "Tool (bin): " << bin << std::endl;
		if (!GlobalConfig->ToolList->isEmpty())
		{
			for ( tool = GlobalConfig->ToolList->first(); tool; tool = GlobalConfig->ToolList->next() )
			{
				if (bin == tool->Name)
				{
					if (tool->PathToExec.section('/',-1) != bin )
					{
						// program is NOT installed
						KMessageBox::information ( this, i18n( "The required tool (%1) is not installed, please install it before you are connecting and restart kvpnc.").arg(bin), i18n( "Tool Missing" ) );
					}
					break;
				}
			}
		}
	}
	else if ( main->ImporttypeComboBox->currentItem() == pkcs12_racoon)
	{
		QString bin="racoon";
		ToolInfo *tool;
		//std::cout << "Tool (bin): " << bin << std::endl;
		if (!GlobalConfig->ToolList->isEmpty())
		{
			for ( tool = GlobalConfig->ToolList->first(); tool; tool = GlobalConfig->ToolList->next() )
			{
				if (bin == tool->Name)
				{
					if (tool->PathToExec.section('/',-1) != bin )
					{
						// program is NOT installed
						KMessageBox::information ( this, i18n( "The required tool (%1) is not installed, please install it before you are connecting and restart kvpnc.").arg(bin), i18n( "Tool Missing" ) );
					}
					break;
				}
			}
		}
	}
	else if ( main->ImporttypeComboBox->currentItem() == pkcs12_openvpn)
	{
		QString bin="openvpn";
		ToolInfo *tool;
		//std::cout << "Tool (bin): " << bin << std::endl;
		if (!GlobalConfig->ToolList->isEmpty())
		{
			for ( tool = GlobalConfig->ToolList->first(); tool; tool = GlobalConfig->ToolList->next() )
			{
				if (bin == tool->Name)
				{
					if (tool->PathToExec.section('/',-1) != bin )
					{
						// program is NOT installed
						KMessageBox::information ( this, i18n( "The required tool (%1) is not installed, please install it before you are connecting and restart kvpnc.").arg(bin), i18n( "Tool Missing" ) );
					}
					break;
				}
			}
		}
	}
	GlobalConfig->appPointer->restoreOverrideCursor();

		if (doExit)
			QDialog::accept();
}

void ImportCertificateDialog::doCacert()
{
	if ( ImportProcess->normalExit () )
	{
		if (GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry ( i18n( "Certificate import: doCacert()" ),GlobalConfig->debug );
		disconnect( ImportProcess, SIGNAL( processExited () ), this, SLOT( doCacert() ) );

		if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan )
		{
			Utils(GlobalConfig,this).doChmod("/etc/ipsec.d/certs/mykeys_" + certName + ".pem","go-rwx");
		}
		else if( main->ImporttypeComboBox->currentItem() == pkcs12_racoon || main->ImporttypeComboBox->currentItem() == pkcs12_openvpn )
		{
			Utils(GlobalConfig,this).doChmod(certpath + "/mykeys_" + certName + ".pem","go-rwx");
		}

		/*
		openssl pkcs12 -in cert.p12 -nokeys -cacerts -out /etc/racoon/certs/ca_company.pem -nodes
		*/
		ImportProcess->clearArguments();
		ImportProcess->addArgument( pathToOpenSSL );
		ImportProcess->addArgument( "pkcs12" );
		ImportProcess->addArgument( "-in" );
		ImportProcess->addArgument( filename );
		ImportProcess->addArgument( "-nokeys" );
		ImportProcess->addArgument( "-cacerts" );
		ImportProcess->addArgument( "-out" );

		if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan )
		{
			ImportProcess->addArgument( "/etc/ipsec.d/cacerts/ca_" + certName + ".pem" ); // warning: static
			CaCertFullPath="/etc/ipsec.d/cacerts/ca_" + certName + ".pem";
		}
		else
		{
			ImportProcess->addArgument( certpath + "/ca_" + certName + ".pem" );
			CaCertFullPath=certpath + "/ca_" + certName + ".pem";
		}

		ImportProcess->addArgument( "-nodes" );

		connect( ImportProcess, SIGNAL( processExited () ), this, SLOT( doCreateHash() ) );

		if (! ImportProcess->start() )
		{
			KMessageBox::error( 0, i18n( "Unable to extract CA certificate!" ), i18n( "Extract Failed" ) );
			GlobalConfig->appendLogEntry ( i18n( "Certificate import: CA certificate could not be extracted." ),GlobalConfig->error );
			importSuccess=false;
		}
		else
		{
			doExit=true;
			if (GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n( "Certificate import: CA certificate successful extracted." ),GlobalConfig->debug );
		}
	}
}

void ImportCertificateDialog::doPrivateKey()
{
	if ( ImportProcess->normalExit () )
	{
		//GlobalConfig->appendLogEntry("[dbg]: doPrivateKey()",GlobalConfig->debug);
		disconnect( ImportProcess, SIGNAL( processExited () ), this, SLOT( doPrivateKey() ) );
		/*
		openssl pkcs12 -in cert.p12 -nocerts -out /etc/racoon/certs/ca_company.pem
		*/
		ImportProcess->clearArguments();
		ImportProcess->addArgument( pathToOpenSSL );
		ImportProcess->addArgument( "pkcs12" );
		ImportProcess->addArgument( "-nocerts" );
		ImportProcess->addArgument( "-in" );
		ImportProcess->addArgument( filename );
		ImportProcess->addArgument( "-out" );


		ImportProcess->addArgument( certpath+"/private/" + certName + ".pem" ); // warning: static
		if (!certpath.isEmpty())
			CertFullPath=certpath+"/private/" + certName + ".pem";

		connect( ImportProcess, SIGNAL( processExited () ), this, SLOT( exit() ) );

		//LogOutput->append( "priv key: we starting..." );
		if ( !ImportProcess->start( ) )
		{
			KMessageBox::sorry( this, i18n( "Unable to start process (private key)!" ) );

			GlobalConfig->appendLogEntry ( i18n( "Certificate import: private key could not extracted." ),GlobalConfig->error );
			importSuccess=false;
		}
		else
		{
			doExit=true;
			privatekeypassword = main->PrivateKeyPasswordEdit->text();
			if (GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n( "Certificate import: private key successful extracted." ),GlobalConfig->debug );
		}

	}
}

void ImportCertificateDialog::doCreateHash()
{
	if ( ImportProcess->normalExit () )
	{

		disconnect( ImportProcess, SIGNAL( processExited () ), this, SLOT( doCreateHash() ) );

		if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan )
			Utils(GlobalConfig,this).doChmod(certpath+"/cacerts/ca_" + certName + ".pem","go-rwx");
		else
			Utils(GlobalConfig,this).doChmod(certpath + "/ca_" + certName + ".pem","go-rwx");

		/*
		openssl x509 -noout -hash < /etc/racoon/certs/ca_company.pem
		*/
		ImportProcess->clearArguments();
		ImportProcess->addArgument( pathToOpenSSL );
		ImportProcess->addArgument( "x509" );
		ImportProcess->addArgument( "-noout" );
		ImportProcess->addArgument( "-hash" );
		ImportProcess->addArgument( "-in" );
		if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan )
			ImportProcess->addArgument( certpath+"/cacerts/ca_" + certName + ".pem" ); // warning: static
		else
			ImportProcess->addArgument( certpath + "/ca_" + certName + ".pem" );

		connect( ImportProcess, SIGNAL( processExited () ), this, SLOT( doLink() ) );


		//		LogOutput->append( "hash: we starting..." );
		if ( !ImportProcess->start( ) )
		{
			KMessageBox::sorry( this, i18n( "Unable to start process (%1)!" ).arg("hash") );
			GlobalConfig->appendLogEntry ( i18n( "Certificate import: hash could not created." ),GlobalConfig->error );
			importSuccess=false;
		}
		else
		{
			doExit=true;
			doHash = true;
			if (GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n( "Certificate import: hash successful created." ),GlobalConfig->debug );
		}
	}
}

void ImportCertificateDialog::doLink()
{
	if ( ImportProcess->normalExit () )
	{
		disconnect( ImportProcess, SIGNAL( processExited () ), this, SLOT( doLink() ) );
		doHash = false;
		ImportProcess->clearArguments();
		/*
		ln -s /etc/racoon/certs/ca_company.pem /etc/racoon/certs/<hash>.0
		*/
		ImportProcess->addArgument( "ln" );
		ImportProcess->addArgument( "-s" );
		if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan )
		{
			ImportProcess->addArgument( certpath+"/cacerts/ca_" + certName + ".pem" );
			ImportProcess->addArgument( certpath+"/cacerts/" + certHash + ".0" );
		}
		else
		{
			ImportProcess->addArgument( certpath + "/ca_" + certName + ".pem" );
			ImportProcess->addArgument( certpath + certHash + ".0" );
		}

		if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan )
			connect( ImportProcess, SIGNAL( processExited () ), this, SLOT( doPrivateKey() ) );
		else
			connect( ImportProcess, SIGNAL( processExited () ), this, SLOT( exit() ) );


		if ( !ImportProcess->start( ) )
		{
			KMessageBox::sorry( this, i18n( "Unable to start process (%1)!" ).arg("ln -s") );
				GlobalConfig->appendLogEntry ( i18n( "Certificate import: Link could not created." ),GlobalConfig->error );
			importSuccess=false;
		}
		else
		{
			doExit=true;
			if (GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry ( i18n( "Certificate import: Link successful created." ),GlobalConfig->debug );
		}
	}
}

void ImportCertificateDialog::exit()
{
	// 	if ( ImportProcess->normalExit() )
	// 		importOk=true;
	if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan )
		Utils(GlobalConfig,this).doChmod(certpath+"/private/" + certName + ".pem","go-rwx");
	done=true;
	canAccept();
}

void ImportCertificateDialog::readFromStdout_import()
{
	QString line = QString( ImportProcess->readStdout() );

	if (GlobalConfig->KvpncDebugLevel > 0 )
		GlobalConfig->appendLogEntry ( i18n( "Certificate import stdout: %1" ).arg( line ),GlobalConfig->debug );
	if ( doHash )
	{
		certHash = line.left( line.length() - 1 );
		doHash = false;
		//		LogOutput->append( "<font color=\"red\">[std]: hash" + line + "</font>" );
	}

	if ( line.find( "Enter Import Pass" , 0, FALSE ) > -1 )
	{
		if (GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry ( i18n( "Certificate import: %1 was requested, send it..." ).arg(i18n(" import password")),GlobalConfig->debug );

		ImportProcess->writeToStdin( importpassword + "\n" );
	}

	if ( line.find( "Enter PEM pass phrase" , 0, FALSE ) > -1 )
	{

		if (GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry ( i18n( "Certificate import: %1 was requested, send it..." ).arg(i18n("private key password")),GlobalConfig->debug );
		ImportProcess->writeToStdin( main->PrivateKeyPasswordEdit->text() + "\n" );
	}

}

void ImportCertificateDialog::readFromStderr_import()
{
	QString line = QString( ImportProcess->readStderr() );

	if (line.find("Error",9, FALSE ) > -1 )
	{
		GlobalConfig->appendLogEntry ( i18n( "Certificate import: %2" ).arg(line),GlobalConfig->error );
		importSuccess=false;
		doExit=false;
	}

	if ( line.find( "invalid password" , 0, FALSE ) > -1 )
	{
		KMessageBox::sorry( 0, i18n( "Wrong password." ), i18n( "Password Failed" ) );
		GlobalConfig->appendLogEntry ( i18n( "Certificate import: password was invalid" ),GlobalConfig->error );
		importSuccess=false;
		doExit=false;
		GlobalConfig->appPointer->restoreOverrideCursor();
	}

	if ( line.find( "Enter Import Pass", 0, FALSE ) > -1 )
	{

		if (GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry ( i18n( "Certificate import: %1 was requested, send it..." ).arg(i18n("import password")),GlobalConfig->debug );
		ImportProcess->writeToStdin( importpassword + "\n" );
	}

	if ( line.find( "Enter PEM pass phrase", 0, FALSE ) > -1 )
	{

		if (GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry ( i18n( "Certificate import: password was requested, send it..." ).arg(i18n("private key password")),GlobalConfig->debug );
		ImportProcess->writeToStdin( main->PrivateKeyPasswordEdit->text() + "\n" );
	}

	// 	if ( line.contains( "Verifying - Enter PEM pass phrase" ) > 0 ) {
	// 		LogOutput->append( "<font color=\"green\">[in]: write the private key password (again)</font>" );
	// 		ImportProcess->writeToStdin( importpassword + "\n" );
	// 	}
	if ( line.find( "unable to load certificate", 0, FALSE ) > -1 )
	{
		KMessageBox::error( 0, i18n( "Unable to load certificate!" ), i18n( "Load Failed" ) );
		GlobalConfig->appendLogEntry( i18n( "Unable to load certificate!" ) ,GlobalConfig->error);
		importOk=true;
		importSuccess=false;
		doExit=false;
		GlobalConfig->appPointer->restoreOverrideCursor();
		if (ImportProcess->isRunning())
		{
			ImportProcess->kill();
		}
		done=true;
	}



}

void ImportCertificateDialog::typeToggeled( int type )
{
	//GlobalConfig->appendLogEntry( QString("type: "+QString().setNum(type)),GlobalConfig->info);
	if ( type == pkcs12_freeswan )
	{
		certpath = "/etc/ipsec.d/certs";
		main->PrivateKeyPasswordEdit->setEnabled( true );
		main->PrivateKeyAgainPasswordEdit->setEnabled( true );
		main->RacoonCertificatePathUrlrequester->setEnabled( false );
		main->ImportPasswordEdit->setEnabled( true );
		main->P12GroupBox->setEnabled( true );
		main->FreeswanGroupBox->setEnabled( true );
		main->FilenameUrlrequester->setFilter( "*.p12" );
	}
	else if ( type == pkcs12_racoon )
	{
		certpath = "/etc/racoon/certs/";
		main->PrivateKeyPasswordEdit->setEnabled( false );
		main->PrivateKeyAgainPasswordEdit->setEnabled( false );
		main->RacoonCertificatePathUrlrequester->setEnabled( true );
		main->ImportPasswordEdit->setEnabled( true );
		main->P12GroupBox->setEnabled( true );
		main->FreeswanGroupBox->setEnabled( false );
		main->FilenameUrlrequester->setFilter( "*.p12" );
	}
	else if ( type == ca_der )
	{
		certpath = "/etc/certs/";
		main->PrivateKeyPasswordEdit->setEnabled( false );
		main->PrivateKeyAgainPasswordEdit->setEnabled( false );
		main->RacoonCertificatePathUrlrequester->setEnabled( true );
		main->ImportPasswordEdit->setEnabled( false );
		main->P12GroupBox->setEnabled( false );
		main->FreeswanGroupBox->setEnabled( false );
		main->FilenameUrlrequester->setFilter( "*.der *.crt" );
	}
	else if ( type == pkcs12_openvpn )
	{
		certpath = "/etc/openvpn";
		main->PrivateKeyPasswordEdit->setEnabled( true );
		main->PrivateKeyAgainPasswordEdit->setEnabled( true );
		main->RacoonCertificatePathUrlrequester->setEnabled( false );
		main->ImportPasswordEdit->setEnabled( true );
		main->P12GroupBox->setEnabled( true );
		main->FreeswanGroupBox->setEnabled( false );
		main->FilenameUrlrequester->setFilter( "*.p12" );
	}
	main->RacoonCertificatePathUrlrequester->setURL(certpath);
}


#include "importcertificatedialog.moc"
