/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef __KVPNCCONFIG_H__
#define __KVPNCCONFIG_H__

//BEGIN INCLUDES
#include <qobject.h>
#include <qptrlist.h>
#include <qstring.h>
#include <qapplication.h>
#include <qcolor.h>
#include <qpoint.h>
#include <qsize.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qtextedit.h>
#include <kconfig.h>
#include <kwallet.h>

#include "toolinfo.h"
#include "vpnaccountdata.h"
//END INCLUDES

/**
This class holds global configuration data.
@author Christoph Thielecke <crissi99@gmx.de>
*/
class KVpncConfig : public QObject
{
	Q_OBJECT
public:
	KVpncConfig(QWidget *parent);
	~KVpncConfig();

public:
	enum ConnectionStatus {disconnected=0, connecting=1, connected=2};
	enum LogType {info=0, remote=1, error=2, success=3, debug=4};

	QString pathToVpnc;
	QString pathToRacoon;
	QString pathToSetkey;
	QString pathToIptables;
	QString pathToOpenssl;
	QString pathToFreeswan;
	QString pathToPppd;
	QString pathToPptp;
	QString pathToKill;
	QString pathToKillall;
	QString pathToPing;
	QString pathToOpenvpn;
	QString pathToIp;
	QString pathToIfconfig;
	QString pathToRoute;
	QString AutoConnectProfile;
	QString RacoonDebugLevel;
	QString Vpnc_pid_file;
	QString Pppd_pid_file;
	QString lastProfile;
	QString logfileName;

	bool minimizeAfterConnect;
	bool showDebugConsole;
	bool writeLogFile;
	bool useDefaultPaths;
	bool useSilentQuit;
	bool holdGeneratedScripts;
	bool programsInPath;
	bool enableDebugPppd;
	bool enableFreeswanVerbose;
	bool enableDebugOpenvpn;
	bool useColorizedLogOutput;
	bool showInterfaceIPinTooltip;
	bool dontQuitOnCloseEvent;
	bool doAutoConnectAtStartup;
	bool useKwallet;
	bool showStatusBar;
	bool showToolBar;
	bool PppdDebugLevel;
	bool firstUseOfKwallet; //< for importing passwords if there are stored before
	bool shutdownIsCalled;
	bool skipKwalletStoring; //< true if save should skip saving into kwallet
	bool hideOnCloseInfo;

	int VpncDebugLevel;
	int KvpncDebugLevel;
	int OpenvpnDebugLevel;
	int PptpDebugLevel;
	int LogViewerFontSize;
	int mainwindow_pos_x;
	int mainwindow_pos_y;
	int mainwindow_height;
	int mainwindow_width;
	int connectSleepDelay; //< time beetween retry
	int connectSleepRetry; //< count of retries
	int tryConnectTimeout; //< timeout in at connecting
	int connectionStartTime;
	int runningCheckCounter;
	int runningCheckTimeout;
	QPtrList<ToolInfo> *ToolList;
	QPtrList<VpnAccountData> *AccountList;
	VpnAccountData *currentProfile;

	QColor InfoLogColor;
	QColor RemoteLogColor;
	QColor ErrorLogColor;
	QColor SuccessLogColor;
	QColor DebugLogColor;

	QApplication *appPointer;
	QPoint pos;
	ConnectionStatus status;
	QFile logfile;
	QTextStream logFileStream;
	QTextEdit *LogOutput;
	KWallet::Wallet *wallet;
	KConfig* config; //< configuration data

	QPoint WindowPos;
	QSize WindowSize;

	QWidget *parent;

	/**
	 * Appends a log enty to debug console and log file
	 * @param msg the text to append
	 * @param type the type of the msg (info, debug, error, etc)
	 */
	void appendLogEntry( QString msg, LogType type );

	/**
	 *  Sets the output textedit for debug output
	 * @param LogOutput
	 */
	void setLogOutput(QTextEdit *LogOutput);

	/**
	* save configuration
	*/
	void saveOptions();

	/**
	* load configuration
	*/
	void loadOptions();

	/**
	 *  collects the information of the external helper programs
	 */
	void getToolsInfo();


	/**
	 *  removes a entry from configuration file
	 * @param Name the entry which should be removed
	 */
	void removeEntry(QString Name);

};

#endif
