/***************************************************************************
 *   Copyright (C) 2005 - 2006 by Christian Muehlhaeuser, Last.fm Ltd.            *
 *   chris@last.fm                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifndef __SETTINGSDIALOG_H__
#define __SETTINGSDIALOG_H__

#include <QtCore>

#include "ui_settingsdialog.h"
#include "ui_settingsdialog_general.h"
#include "ui_settingsdialog_connection.h"
#include "ui_settingsdialog_system.h"

class SettingsDialog : public QDialog
{
    Q_OBJECT

    public:
        SettingsDialog( QWidget *parent = 0 );

    public slots:
        void okPressed();
        void applyPressed();
        void signUp();

    private slots:
        void configChanged();
        void pageChanged( int currentRow );

    private:
        Ui::SettingsDialog ui;
        Ui::SettingsDialogGeneral ui_general;
        Ui::SettingsDialogConnection ui_connection;
        Ui::SettingsDialogSystem ui_system;

        QString originalUsername;
        QString originalPassword;

        QString originalProxyHost;
        QString originalProxyUsername;
        QString originalProxyPassword;
        int originalProxyPort;
        bool originalProxyUsage;

        int originalSoundCard;
        int originalSoundSystem;
};

#endif
