/***************************************************************************
 *   Copyright (C) 2005 - 2006 by Christian Muehlhaeuser, Last.fm Ltd.     *
 *   chris@last.fm                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include <QtGui>

#include "urldialog.h"
#include "webserviceconnector.h"


UrlDialog::UrlDialog( QWidget *parent )
    : QDialog( parent, Qt::Dialog )
{
    ui.setupUi( this );

    connect( ui.okButton, SIGNAL( clicked() ), this, SLOT( okPressed() ) );
}


void
UrlDialog::okPressed()
{
    if ( !ui.urlEdit->text().startsWith( "lastfm://" ) )
        QMessageBox::critical( 0, "Error", "This is not a valid Last.fm address!\n" );
    else
        WebserviceConnector::instance()->changeStation( ui.urlEdit->text().remove( 0, 9 ) );
}

