#
# spec file for package OpenOffice_org (Version 2.4.1.7)
#
# Copyright (c) 2008 SUSE LINUX Products GmbH, Nuernberg, Germany.
# This file and all modifications and additions to the pristine
# package are under the same license as the package itself.
#
# Please submit bugfixes or comments via http://bugs.opensuse.org/
#

# norootforbuild

Name:           OpenOffice_org-help
Version:        3.0.0.2
Release:        5
%define         ooo_build_version 3.0.0.2b
%define         piece      help
%define	      ooo_build_version 3.0.0.2b
# test_build_langs:   	   1 = de and cs
#			   2 = all supported languages 
%define		test_build_langs 	1
# build_module_in_parallel 0 = no
#			   1 = yes (the number is defined be the number of cpus)
#			   2,3,4... = yes (force the number of modules to be built in parallel)
%define		build_module_in_parallel	1
# prepare_build:	   0 = no
#			   1 = yes (just build, install and create packages; without %%prep section and configure)
%define		prepare_build 		1
#
%if %test_build_langs == 0
%define       ooo_langs		"en-US"
%else
%if %test_build_langs == 1
%define       ooo_langs		"en-US cs de"
%else
%define       ooo_langs		"en-US cs de es fr it"
%endif
%endif
%define	      ooo_basis_dir	basis3.0
%define	      ooo_home		ooo3
BuildRequires:  java-devel unzip zip
BuildRequires:  OpenOffice_org-artwork-devel = %version
BuildRequires:  OpenOffice_org-libs-core-devel = %version
%define	      ooo_prefix	%_libdir
%define	      ooo_home		ooo3
%define	      ooo_build_tag     ooo300-m4
License:        LGPL v2.1 only; LGPL v3 only
Group:          Productivity/Office/Suite
AutoReqProv:    on
Summary:        Help content
Url:            http://www.openoffice.org/
Source:         %ooo_build_tag-l10n.tar.bz2
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
BuildArch:      noarch

%description
This package provides various icon themes for the OpenOffice.org office
suite.

####################################################
# Start of a section generated by ooo-l10n-gen-spec
# Do not edit!
####################################################

#
# help packages
#

%if %test_build_langs >= 2

%package -n OpenOffice_org-help-ar
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Arabic Help Localization for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:ar)
Provides:       OpenOffice_org-ar:%_prefix/ooo-2.0/help/cs/default.css
PreReq:         OpenOffice_org-ure = %version
Supplements:    OpenOffice_org-l10n-ar

%description -n OpenOffice_org-help-ar
Arabic help localization for OpenOffice.org.
The other localized stuff is in OpenOffice.org-l10n-ar.

%endif
%if %test_build_langs >= 1

%package -n OpenOffice_org-help-cs
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Czech Help Localization for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:cs)
Provides:       OpenOffice_org-cs:%_prefix/ooo-2.0/help/cs/default.css
PreReq:         OpenOffice_org-ure = %version
Supplements:    OpenOffice_org-l10n-cs

%description -n OpenOffice_org-help-cs
Czech help localization for OpenOffice.org.
The other localized stuff is in OpenOffice.org-l10n-cs.

%endif
%if %test_build_langs >= 2

%package -n OpenOffice_org-help-da
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Danish Help Localization for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:da)
Provides:       OpenOffice_org-da:%_prefix/ooo-2.0/help/cs/default.css
PreReq:         OpenOffice_org-ure = %version
Supplements:    OpenOffice_org-l10n-da

%description -n OpenOffice_org-help-da
Danish help localization for OpenOffice.org.
The other localized stuff is in OpenOffice.org-l10n-da.

%endif
%if %test_build_langs >= 1

%package -n OpenOffice_org-help-de
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        German Help Localization for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:de)
Provides:       OpenOffice_org-de:%_prefix/ooo-2.0/help/cs/default.css
PreReq:         OpenOffice_org-ure = %version
Supplements:    OpenOffice_org-l10n-de

%description -n OpenOffice_org-help-de
German help localization for OpenOffice.org.
The other localized stuff is in OpenOffice.org-l10n-de.

%endif
%if %test_build_langs >= 2

%package -n OpenOffice_org-help-en-GB
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        British Help Localization for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:en_GB)
Provides:       OpenOffice_org-en-GB:%_prefix/ooo-2.0/help/cs/default.css
PreReq:         OpenOffice_org-ure = %version
Supplements:    OpenOffice_org-l10n-en-GB

%description -n OpenOffice_org-help-en-GB
British help localization for OpenOffice.org.
The other localized stuff is in OpenOffice.org-l10n-en-GB.

%endif

%package -n OpenOffice_org-help-en-US
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        American Help Localization for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:en_US)
Provides:       OpenOffice_org:%_prefix/ooo-2.0/help/cs/default.css
PreReq:         OpenOffice_org-ure = %version
Supplements:    OpenOffice_org-l10n-en-US

%description -n OpenOffice_org-help-en-US
American help localization for OpenOffice.org.
The other localized stuff is in OpenOffice.org-l10n-en-US.

%if %test_build_langs >= 2

%package -n OpenOffice_org-help-en-ZA
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        South Africa English Help Localization for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:en_ZA)
Provides:       OpenOffice_org-en-ZA:%_prefix/ooo-2.0/help/cs/default.css
PreReq:         OpenOffice_org-ure = %version
Supplements:    OpenOffice_org-l10n-en-ZA

%description -n OpenOffice_org-help-en-ZA
South Africa English help localization for OpenOffice.org.
The other localized stuff is in OpenOffice.org-l10n-en-ZA.

%package -n OpenOffice_org-help-es
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Spanish Help Localization for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:es)
Provides:       OpenOffice_org-es:%_prefix/ooo-2.0/help/cs/default.css
PreReq:         OpenOffice_org-ure = %version
Supplements:    OpenOffice_org-l10n-es

%description -n OpenOffice_org-help-es
Spanish help localization for OpenOffice.org.
The other localized stuff is in OpenOffice.org-l10n-es.

%package -n OpenOffice_org-help-et
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Estonian Help Localization for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:et)
Provides:       OpenOffice_org-et:%_prefix/ooo-2.0/help/cs/default.css
PreReq:         OpenOffice_org-ure = %version
Supplements:    OpenOffice_org-l10n-et

%description -n OpenOffice_org-help-et
Estonian help localization for OpenOffice.org.
The other localized stuff is in OpenOffice.org-l10n-et.

%package -n OpenOffice_org-help-fr
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        French Help Localization for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:fr)
Provides:       OpenOffice_org-fr:%_prefix/ooo-2.0/help/cs/default.css
PreReq:         OpenOffice_org-ure = %version
Supplements:    OpenOffice_org-l10n-fr

%description -n OpenOffice_org-help-fr
French help localization for OpenOffice.org.
The other localized stuff is in OpenOffice.org-l10n-fr.

%package -n OpenOffice_org-help-gl
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Galician Help Localization for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:gl)
Provides:       OpenOffice_org-gl:%_prefix/ooo-2.0/help/cs/default.css
PreReq:         OpenOffice_org-ure = %version
Supplements:    OpenOffice_org-l10n-gl

%description -n OpenOffice_org-help-gl
Galician help localization for OpenOffice.org.
The other localized stuff is in OpenOffice.org-l10n-gl.

%package -n OpenOffice_org-help-gu-IN
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Gujarati Help Localization for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:gu_IN)
Provides:       OpenOffice_org-gu-IN:%_prefix/ooo-2.0/help/cs/default.css
PreReq:         OpenOffice_org-ure = %version
Supplements:    OpenOffice_org-l10n-gu-IN

%description -n OpenOffice_org-help-gu-IN
Gujarati help localization for OpenOffice.org.
The other localized stuff is in OpenOffice.org-l10n-gu-IN.

%package -n OpenOffice_org-help-hi-IN
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Hindi Help Localization for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:hi_IN)
Provides:       OpenOffice_org-hi-IN:%_prefix/ooo-2.0/help/cs/default.css
PreReq:         OpenOffice_org-ure = %version
Supplements:    OpenOffice_org-l10n-hi-IN

%description -n OpenOffice_org-help-hi-IN
Hindi help localization for OpenOffice.org.
The other localized stuff is in OpenOffice.org-l10n-hi-IN.

%endif
%if %test_build_langs >= 1

%package -n OpenOffice_org-help-hu
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Hungarian Help Localization for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:hu)
Provides:       OpenOffice_org-hu:%_prefix/ooo-2.0/help/cs/default.css
PreReq:         OpenOffice_org-ure = %version
Supplements:    OpenOffice_org-l10n-hu

%description -n OpenOffice_org-help-hu
Hungarian help localization for OpenOffice.org.
The other localized stuff is in OpenOffice.org-l10n-hu.

%endif
%if %test_build_langs >= 2

%package -n OpenOffice_org-help-it
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Italian Help Localization for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:it)
Provides:       OpenOffice_org-it:%_prefix/ooo-2.0/help/cs/default.css
PreReq:         OpenOffice_org-ure = %version
Supplements:    OpenOffice_org-l10n-it

%description -n OpenOffice_org-help-it
Italian help localization for OpenOffice.org.
The other localized stuff is in OpenOffice.org-l10n-it.

%endif
%if %test_build_langs >= 1

%package -n OpenOffice_org-help-ja
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Japanese Help Localization for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:ja)
Provides:       OpenOffice_org-ja:%_prefix/ooo-2.0/help/cs/default.css
PreReq:         OpenOffice_org-ure = %version
Supplements:    OpenOffice_org-l10n-ja

%description -n OpenOffice_org-help-ja
Japanese help localization for OpenOffice.org.
The other localized stuff is in OpenOffice.org-l10n-ja.

%endif
%if %test_build_langs >= 2

%package -n OpenOffice_org-help-km
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Khmer Help Localization for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:km)
Provides:       OpenOffice_org-km:%_prefix/ooo-2.0/help/cs/default.css
PreReq:         OpenOffice_org-ure = %version
Supplements:    OpenOffice_org-l10n-km

%description -n OpenOffice_org-help-km
Khmer help localization for OpenOffice.org.
The other localized stuff is in OpenOffice.org-l10n-km.

%package -n OpenOffice_org-help-ko
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Korean Help Localization for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:ko)
Provides:       OpenOffice_org-ko:%_prefix/ooo-2.0/help/cs/default.css
PreReq:         OpenOffice_org-ure = %version
Supplements:    OpenOffice_org-l10n-ko

%description -n OpenOffice_org-help-ko
Korean help localization for OpenOffice.org.
The other localized stuff is in OpenOffice.org-l10n-ko.

%package -n OpenOffice_org-help-nl
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Dutch Help Localization for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:nl)
Provides:       OpenOffice_org-nl:%_prefix/ooo-2.0/help/cs/default.css
PreReq:         OpenOffice_org-ure = %version
Supplements:    OpenOffice_org-l10n-nl

%description -n OpenOffice_org-help-nl
Dutch help localization for OpenOffice.org.
The other localized stuff is in OpenOffice.org-l10n-nl.

%package -n OpenOffice_org-help-pa-IN
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Punjabi Help Localization for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:pa_IN)
Provides:       OpenOffice_org-pa-IN:%_prefix/ooo-2.0/help/cs/default.css
PreReq:         OpenOffice_org-ure = %version
Supplements:    OpenOffice_org-l10n-pa-IN

%description -n OpenOffice_org-help-pa-IN
Punjabi help localization for OpenOffice.org.
The other localized stuff is in OpenOffice.org-l10n-pa-IN.

%package -n OpenOffice_org-help-pl
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Polish Help Localization for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:pl)
Provides:       OpenOffice_org-pl:%_prefix/ooo-2.0/help/cs/default.css
PreReq:         OpenOffice_org-ure = %version
Supplements:    OpenOffice_org-l10n-pl

%description -n OpenOffice_org-help-pl
Polish help localization for OpenOffice.org.
The other localized stuff is in OpenOffice.org-l10n-pl.

%package -n OpenOffice_org-help-pt
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Portuguese Help Localization for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:pt)
Provides:       OpenOffice_org-pt:%_prefix/ooo-2.0/help/cs/default.css
PreReq:         OpenOffice_org-ure = %version
Supplements:    OpenOffice_org-l10n-pt

%description -n OpenOffice_org-help-pt
Portuguese help localization for OpenOffice.org.
The other localized stuff is in OpenOffice.org-l10n-pt.

%package -n OpenOffice_org-help-pt-BR
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Brazilian Portuguese Help Localization for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:pt_BR)
Provides:       OpenOffice_org-pt-BR:%_prefix/ooo-2.0/help/cs/default.css
PreReq:         OpenOffice_org-ure = %version
Supplements:    OpenOffice_org-l10n-pt-BR

%description -n OpenOffice_org-help-pt-BR
Brazilian Portuguese help localization for OpenOffice.org.
The other localized stuff is in OpenOffice.org-l10n-pt-BR.

%package -n OpenOffice_org-help-ru
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Russian Help Localization for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:ru)
Provides:       OpenOffice_org-ru:%_prefix/ooo-2.0/help/cs/default.css
PreReq:         OpenOffice_org-ure = %version
Supplements:    OpenOffice_org-l10n-ru

%description -n OpenOffice_org-help-ru
Russian help localization for OpenOffice.org.
The other localized stuff is in OpenOffice.org-l10n-ru.

%package -n OpenOffice_org-help-sl
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Slovene Help Localization for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:sl)
Provides:       OpenOffice_org-sl:%_prefix/ooo-2.0/help/cs/default.css
PreReq:         OpenOffice_org-ure = %version
Supplements:    OpenOffice_org-l10n-sl

%description -n OpenOffice_org-help-sl
Slovene help localization for OpenOffice.org.
The other localized stuff is in OpenOffice.org-l10n-sl.

%package -n OpenOffice_org-help-sv
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Swedish Help Localization for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:sv)
Provides:       OpenOffice_org-sv:%_prefix/ooo-2.0/help/cs/default.css
PreReq:         OpenOffice_org-ure = %version
Supplements:    OpenOffice_org-l10n-sv

%description -n OpenOffice_org-help-sv
Swedish help localization for OpenOffice.org.
The other localized stuff is in OpenOffice.org-l10n-sv.

%package -n OpenOffice_org-help-zh-CN
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Chinese Simplified Help Localization for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:zh_CN)
Provides:       OpenOffice_org-zh-CN:%_prefix/ooo-2.0/help/cs/default.css
PreReq:         OpenOffice_org-ure = %version
Supplements:    OpenOffice_org-l10n-zh-CN

%description -n OpenOffice_org-help-zh-CN
Chinese Simplified help localization for OpenOffice.org.
The other localized stuff is in OpenOffice.org-l10n-zh-CN.

%package -n OpenOffice_org-help-zh-TW
License:        GPL v2 or later; LGPL v2.1 or later
Summary:        Chinese Traditional Help Localization for OpenOffice.org
Group:          Productivity/Office/Suite
Provides:       locale(OpenOffice_org:zh_TW)
Provides:       OpenOffice_org-zh-TW:%_prefix/ooo-2.0/help/cs/default.css
PreReq:         OpenOffice_org-ure = %version
Supplements:    OpenOffice_org-l10n-zh-TW

%description -n OpenOffice_org-help-zh-TW
Chinese Traditional help localization for OpenOffice.org.
The other localized stuff is in OpenOffice.org-l10n-zh-TW.

%endif

####################################################
# End of a section generated by ooo-l10n-gen-spec
####################################################

%prep
%setup -q -n %ooo_build_tag-l10n
rm -rf extras readlicense_oo

%build
# setup env.
export OO_INSTDIR=%{_libdir}/%ooo_home
export OO_TOOLSDIR=$OO_INSTDIR/ooo-build/bin
export VERBOSE=1
# don't build help 8x since - well - it needs a shed load of memory.
export EXTRA_BUILD_FLAGS=%{?jobs:-P2}
export EXTRA_DMAKE_FLAGS="%{?jobs:-- -P2}"
# no help content in this package
export BUILD_HELP_SEPARATELY=YES
$OO_TOOLSDIR/piece/build-generic %piece %ooo_build_tag

%install

# setup env.
export OO_INSTDIR=%{_libdir}/%ooo_home
export OO_TOOLSDIR=$OO_INSTDIR/ooo-build/bin
export DESTDIR=$RPM_BUILD_ROOT

$OO_TOOLSDIR/piece/install-generic %piece %ooo_build_tag
# prune redundant files the scp2 likes to make for us
rm -Rf \
    "$DESTDIR/$OO_INSTDIR/basis-link" \
    "$DESTDIR/$OO_INSTDIR/ure"

%clean
rm -rf $RPM_BUILD_ROOT

####################################################
# Start of a section generated by ooo-l10n-gen-spec
# Do not edit!
####################################################

# FIXME: call script that links noarch stuff to the ooo-home
# it will be better to fix OOo to find the noarch stuff
# on the right place

#
# help scripts
#

%if %test_build_langs >= 2

# ar
%posttrans -n OpenOffice_org-help-ar
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-help-ar.txt || true

%preun -n OpenOffice_org-help-ar
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-help-ar.txt || true

%endif
%if %test_build_langs >= 1

# cs
%posttrans -n OpenOffice_org-help-cs
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-help-cs.txt || true

%preun -n OpenOffice_org-help-cs
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-help-cs.txt || true

%endif
%if %test_build_langs >= 2

# da
%posttrans -n OpenOffice_org-help-da
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-help-da.txt || true

%preun -n OpenOffice_org-help-da
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-help-da.txt || true

%endif
%if %test_build_langs >= 1

# de
%posttrans -n OpenOffice_org-help-de
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-help-de.txt || true

%preun -n OpenOffice_org-help-de
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-help-de.txt || true

%endif
%if %test_build_langs >= 2

# en-GB
%posttrans -n OpenOffice_org-help-en-GB
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-help-en_GB.txt || true

%preun -n OpenOffice_org-help-en-GB
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-help-en_GB.txt || true

%endif

# en-US
%posttrans -n OpenOffice_org-help-en-US
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-help-en_US.txt || true

%preun -n OpenOffice_org-help-en-US
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-help-en_US.txt || true

%if %test_build_langs >= 2

# en-ZA
%posttrans -n OpenOffice_org-help-en-ZA
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-help-en_ZA.txt || true

%preun -n OpenOffice_org-help-en-ZA
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-help-en_ZA.txt || true

# es
%posttrans -n OpenOffice_org-help-es
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-help-es.txt || true

%preun -n OpenOffice_org-help-es
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-help-es.txt || true

# et
%posttrans -n OpenOffice_org-help-et
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-help-et.txt || true

%preun -n OpenOffice_org-help-et
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-help-et.txt || true

# fr
%posttrans -n OpenOffice_org-help-fr
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-help-fr.txt || true

%preun -n OpenOffice_org-help-fr
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-help-fr.txt || true

# gl
%posttrans -n OpenOffice_org-help-gl
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-help-gl.txt || true

%preun -n OpenOffice_org-help-gl
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-help-gl.txt || true

# gu-IN
%posttrans -n OpenOffice_org-help-gu-IN
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-help-gu_IN.txt || true

%preun -n OpenOffice_org-help-gu-IN
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-help-gu_IN.txt || true

# hi-IN
%posttrans -n OpenOffice_org-help-hi-IN
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-help-hi_IN.txt || true

%preun -n OpenOffice_org-help-hi-IN
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-help-hi_IN.txt || true

%endif
%if %test_build_langs >= 1

# hu
%posttrans -n OpenOffice_org-help-hu
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-help-hu.txt || true

%preun -n OpenOffice_org-help-hu
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-help-hu.txt || true

%endif
%if %test_build_langs >= 2

# it
%posttrans -n OpenOffice_org-help-it
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-help-it.txt || true

%preun -n OpenOffice_org-help-it
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-help-it.txt || true

%endif
%if %test_build_langs >= 1

# ja
%posttrans -n OpenOffice_org-help-ja
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-help-ja.txt || true

%preun -n OpenOffice_org-help-ja
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-help-ja.txt || true

%endif
%if %test_build_langs >= 2

# km
%posttrans -n OpenOffice_org-help-km
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-help-km.txt || true

%preun -n OpenOffice_org-help-km
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-help-km.txt || true

# ko
%posttrans -n OpenOffice_org-help-ko
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-help-ko.txt || true

%preun -n OpenOffice_org-help-ko
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-help-ko.txt || true

# nl
%posttrans -n OpenOffice_org-help-nl
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-help-nl.txt || true

%preun -n OpenOffice_org-help-nl
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-help-nl.txt || true

# pa-IN
%posttrans -n OpenOffice_org-help-pa-IN
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-help-pa_IN.txt || true

%preun -n OpenOffice_org-help-pa-IN
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-help-pa_IN.txt || true

# pl
%posttrans -n OpenOffice_org-help-pl
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-help-pl.txt || true

%preun -n OpenOffice_org-help-pl
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-help-pl.txt || true

# pt
%posttrans -n OpenOffice_org-help-pt
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-help-pt.txt || true

%preun -n OpenOffice_org-help-pt
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-help-pt.txt || true

# pt-BR
%posttrans -n OpenOffice_org-help-pt-BR
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-help-pt_BR.txt || true

%preun -n OpenOffice_org-help-pt-BR
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-help-pt_BR.txt || true

# ru
%posttrans -n OpenOffice_org-help-ru
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-help-ru.txt || true

%preun -n OpenOffice_org-help-ru
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-help-ru.txt || true

# sl
%posttrans -n OpenOffice_org-help-sl
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-help-sl.txt || true

%preun -n OpenOffice_org-help-sl
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-help-sl.txt || true

# sv
%posttrans -n OpenOffice_org-help-sv
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-help-sv.txt || true

%preun -n OpenOffice_org-help-sv
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-help-sv.txt || true

# zh-CN
%posttrans -n OpenOffice_org-help-zh-CN
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-help-zh_CN.txt || true

%preun -n OpenOffice_org-help-zh-CN
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-help-zh_CN.txt || true

# zh-TW
%posttrans -n OpenOffice_org-help-zh-TW
%_datadir/%ooo_home/link-to-ooo-home %_datadir/%ooo_home/files-help-zh_TW.txt || true

%preun -n OpenOffice_org-help-zh-TW
test "$1" = "0" && %_datadir/%ooo_home/link-to-ooo-home --unlink %_datadir/%ooo_home/files-help-zh_TW.txt || true

%endif

#
# help files
#

%if %test_build_langs >= 2

%files -f files-help-ar.txt -n OpenOffice_org-help-ar
%defattr(-,root,root)

%endif
%if %test_build_langs >= 1

%files -f files-help-cs.txt -n OpenOffice_org-help-cs
%defattr(-,root,root)

%endif
%if %test_build_langs >= 2

%files -f files-help-da.txt -n OpenOffice_org-help-da
%defattr(-,root,root)

%endif
%if %test_build_langs >= 1

%files -f files-help-de.txt -n OpenOffice_org-help-de
%defattr(-,root,root)

%endif
%if %test_build_langs >= 2

%files -f files-help-en_GB.txt -n OpenOffice_org-help-en-GB
%defattr(-,root,root)

%endif

%files -f files-help-en_US.txt -n OpenOffice_org-help-en-US
%defattr(-,root,root)

%if %test_build_langs >= 2

%files -f files-help-en_ZA.txt -n OpenOffice_org-help-en-ZA
%defattr(-,root,root)

%files -f files-help-es.txt -n OpenOffice_org-help-es
%defattr(-,root,root)

%files -f files-help-et.txt -n OpenOffice_org-help-et
%defattr(-,root,root)

%files -f files-help-fr.txt -n OpenOffice_org-help-fr
%defattr(-,root,root)

%files -f files-help-gl.txt -n OpenOffice_org-help-gl
%defattr(-,root,root)

%files -f files-help-gu_IN.txt -n OpenOffice_org-help-gu-IN
%defattr(-,root,root)

%files -f files-help-hi_IN.txt -n OpenOffice_org-help-hi-IN
%defattr(-,root,root)

%endif
%if %test_build_langs >= 1

%files -f files-help-hu.txt -n OpenOffice_org-help-hu
%defattr(-,root,root)

%endif
%if %test_build_langs >= 2

%files -f files-help-it.txt -n OpenOffice_org-help-it
%defattr(-,root,root)

%endif
%if %test_build_langs >= 1

%files -f files-help-ja.txt -n OpenOffice_org-help-ja
%defattr(-,root,root)

%endif
%if %test_build_langs >= 2

%files -f files-help-km.txt -n OpenOffice_org-help-km
%defattr(-,root,root)

%files -f files-help-ko.txt -n OpenOffice_org-help-ko
%defattr(-,root,root)

%files -f files-help-nl.txt -n OpenOffice_org-help-nl
%defattr(-,root,root)

%files -f files-help-pa_IN.txt -n OpenOffice_org-help-pa-IN
%defattr(-,root,root)

%files -f files-help-pl.txt -n OpenOffice_org-help-pl
%defattr(-,root,root)

%files -f files-help-pt.txt -n OpenOffice_org-help-pt
%defattr(-,root,root)

%files -f files-help-pt_BR.txt -n OpenOffice_org-help-pt-BR
%defattr(-,root,root)

%files -f files-help-ru.txt -n OpenOffice_org-help-ru
%defattr(-,root,root)

%files -f files-help-sl.txt -n OpenOffice_org-help-sl
%defattr(-,root,root)

%files -f files-help-sv.txt -n OpenOffice_org-help-sv
%defattr(-,root,root)

%files -f files-help-zh_CN.txt -n OpenOffice_org-help-zh-CN
%defattr(-,root,root)

%files -f files-help-zh_TW.txt -n OpenOffice_org-help-zh-TW
%defattr(-,root,root)

%endif

####################################################
# End of a section generated by ooo-l10n-gen-spec
####################################################


%changelog
* Fri Aug 29 2008 pmladek@suse.cz
- added build dependency on exact version of
  OpenOffice_org-icon-themes-prebuilt to avoid inconsistent state [bnc#421559]
* Wed Aug 27 2008 pmladek@suse.cz
- updated to version 3.0.0.2
* Thu Aug 21 2008 pmladek@suse.cz
- updated to version 3.0.0.1
* Fri Aug 15 2008 pmladek@suse.cz
- updated to version 3.0.0
* Fri Jul 18 2008 pmladek@suse.cz
- updated to version 2.99.25
* Thu Jul 03 2008 pmladek@suse.cz
- updated to version 2.99.21
- updated for the new three layer structure (basis subdir dir)
* Tue Jun 24 2008 pmladek@suse.cz
- updated to version 2.4.1.7
* Thu Jun 05 2008 pmladek@suse.cz
- updated ooo-build to version 2.4.0.14
* Thu May 22 2008 pmladek@suse.cz
- updated ooo-build to version 2.4.0.13
* Fri May 09 2008 pmladek@suse.cz
- updated ooo-build to ooo-build-2.4.0.10
* Thu Apr 24 2008 pmladek@suse.cz
- updated ooo-build to ooo-build-2.4.0.8
* Mon Apr 14 2008 pmladek@suse.cz
- split from the OpenOffice_org-i18n source package to get it faster
