/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef OOX_OLE_VBAPROJECTFILTER_HXX
#define OOX_OLE_VBAPROJECTFILTER_HXX

#include "oox/core/binaryfilterbase.hxx"

namespace oox {
namespace ole {

// ============================================================================

class VbaProjectFilterBase : public ::oox::core::BinaryFilterBase
{
public:
    explicit            VbaProjectFilterBase(
                            const ::com::sun::star::uno::Reference< ::com::sun::star::uno::XComponentContext >& rxContext,
                            const ::rtl::OUString& rAppName,
                            const ::rtl::OUString& rStorageName )
                            throw( ::com::sun::star::uno::RuntimeException );

    virtual bool        importDocument() throw();
    virtual bool        exportDocument() throw();

private:
    virtual VbaProject* implCreateVbaProject() const;

private:
    ::rtl::OUString     maAppName;
    ::rtl::OUString     maStorageName;
};

// ============================================================================

class WordVbaProjectFilter : public VbaProjectFilterBase
{
public:
    explicit            WordVbaProjectFilter(
                            const ::com::sun::star::uno::Reference< ::com::sun::star::uno::XComponentContext >& rxContext )
                            throw( ::com::sun::star::uno::RuntimeException );

private:
    virtual ::rtl::OUString implGetImplementationName() const;
};

// ============================================================================

} // namespace ole
} // namespace oox

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
