#include "config.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <adplug/adplug.h>
#include <adplug/players.h>
#include <adplug/player.h>
#include "types.h"
extern "C" {
#include "boot/plinkman.h"
#include "filesel/mdb.h"
#include "filesel/pfilesel.h"
#include "stuff/compat.h"
}

static int oplReadMemInfo(struct moduleinfostruct *m, const char *buf, size_t len)
{
	CPlayers::const_iterator i;
	int j;
	
	char name[13];
	strncpy(name, m->name, 12);
	name[12]=0;

	for(i = CAdPlug::players.begin(); i != CAdPlug::players.end(); i++)
		for(j = 0; (*i)->get_extension(j); j++)
		{
			if(CFileProvider::extension(name, (*i)->get_extension(j)))
			{
				snprintf(m->comment, sizeof(m->comment), "%s", (*i)->filetype.c_str());
				m->modtype=mtOPL;
				return 0; /* we are not a dominant plugin */
			}
		}
	return 0;
}
static int oplReadInfo(struct moduleinfostruct *m, FILE *f, const char *buf, size_t len)
{
	return oplReadMemInfo(m, buf, len);
}

static void oplEvent(int event)
{
	switch (event)
	{
		case mdbEvInit:
		{
			CPlayers::const_iterator i;
			int j;
			const char *s;
			char _s[6];
			for(i = CAdPlug::players.begin(); i != CAdPlug::players.end(); i++)
				for(j = 0; (s=(*i)->get_extension(j)); j++)
				{
					strncpy(_s, s+1, 5);
					_s[5]=0;
					strupr(_s);
					fsRegisterExt(_s);
				}
		}
	}
}

extern "C" {

	struct mdbreadnforegstruct oplReadInfoReg = {oplReadMemInfo, oplReadInfo, oplEvent};
	char *dllinfo = "readinfos oplReadInfoReg";
	struct linkinfostruct dllextinfo = {"opltype", "OpenCP OPL Detection (c) 2005 Stian Skjelstad", DLLVERSION, 0};
}
