/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: animationinfo.hxx,v $
 * $Revision: 1.4 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _SDR_ANIMATION_ANIMATIONINFO_HXX
#define _SDR_ANIMATION_ANIMATIONINFO_HXX

#include <sal/types.h>
#include <tools/gen.hxx>

//////////////////////////////////////////////////////////////////////////////
// predeclarations

namespace sdr
{
	namespace mixer
	{
		class BasicMixer;
	} // end of namespace mixer
	namespace contact
	{
		class ViewObjectContact;
		class DisplayInfo;
	} // end of namespace contact
	namespace animation
	{
		class AnimationState;
	} // end of namespace animation
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace animation
	{
		class AnimationInfo
		{
		protected:
			// This needs to be called whenever a defining parameter changes.
			// Default does nothing.
			virtual void ParameterChange();

		public:
			// basic constructor.
			AnimationInfo();

			// destructor
			virtual ~AnimationInfo();

			// This method has to create a fitting AnimationState for the
			// AnimationInfo. It gets the ViewObjectContact it is intended for. This
			// method has to return an Incarnation in every case.
			// Default incarnates standard AnimationState.
			virtual AnimationState* CreateAnimationState(sdr::contact::ViewObjectContact& rVOContact);

			// test if to register at ObjectAnimator again after given time.
			// Fill in the new time value and return accordingly.
			virtual sal_Bool DoRegisterAgain(sal_uInt32 nTime, sal_uInt32& rNewTime, const AnimationState& rAssociatedAS) const = 0;

			// paint method. These needs to paint the object in state of given time point. For
			// this, normally object parameters are changed, then paint from the associated
			// ViewContact is called, then object parameters restored. Default just calls the
			// paint at ViewContact.
			virtual sal_Bool PaintObjectAtTime(sal_uInt32 nTime, sdr::contact::DisplayInfo& rDisplayInfo, 
				Rectangle& rPaintRectangle, const sdr::contact::ViewObjectContact& rAssociatedVOC);

			// Get animation start time, the time it needs to be triggered the
			// first time. Default returns 0L which means to start at once.
			virtual sal_uInt32 GetStartTime() const;

			// React on changes of the object of this AnimationInfo. Default
			// does nothing.
			virtual void ActionChanged();

			// Decide if animation is allowed for the given VOC. Default always returns
			// sal_True. Maybe necessary to switch off for accessibility (e.g.)
			virtual sal_Bool IsAnimationAllowed(const sdr::contact::ViewObjectContact& rVOContact) const;

			// Return smallest/biggest time unit in ms which is handled
			static sal_uInt32 GetSmallestStepTime();
			static sal_uInt32 GetBiggestStepTime();
		};
	} // end of namespace animation
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace animation
	{
		class AInfoDummy : public AnimationInfo
		{
		public:
			// basic constructor.
			AInfoDummy();

			// destructor
			virtual ~AInfoDummy();

			// test if to register at ObjectAnimator again after given time.
			// Fill in the new time value and return accordingly.
			virtual sal_Bool DoRegisterAgain(sal_uInt32 nTime, sal_uInt32& rNewTime, const AnimationState& rAssociatedAS) const;
		};
	} // end of namespace animation
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace animation
	{
		class AInfoMixer : public AnimationInfo
		{
		private:
			// This is the object mixer member to create the in-between states for the
			// Loops between 0.0 and 1.0
			sdr::mixer::BasicMixer*					mpMixer;

			// Create the BasicMixer, called from GetBasicMixer on demand
			virtual sdr::mixer::BasicMixer* CreateBasicMixer() = 0;

		protected:
			// Access the BasicMixer, plus creation on demand. Will use CreateBasicMixer() then.
			sdr::mixer::BasicMixer& GetBasicMixer() const;

			// calculate the MixerState value for given time
			virtual double GetMixerState(sal_uInt32 nTime, sdr::contact::DisplayInfo& rDisplayInfo) const = 0;

		public:
			// basic constructor.
			AInfoMixer();

			// destructor
			virtual ~AInfoMixer();

			// paint method. This implementation uses the mixer to paint the object
			// in the current state.
			virtual sal_Bool PaintObjectAtTime(sal_uInt32 nTime, sdr::contact::DisplayInfo& rDisplayInfo, 
				Rectangle& rPaintRectangle, const sdr::contact::ViewObjectContact& rAssociatedVOC);
		};
	} // end of namespace animation
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

#endif //_SDR_ANIMATION_ANIMATIONINFO_HXX

// eof
