/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: overlaypolypolygon.hxx,v $
 * $Revision: 1.4 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _SDR_OVERLAY_OVERLAYPOLYPOLYGON_HXX
#define _SDR_OVERLAY_OVERLAYPOLYPOLYGON_HXX

#include <svx/sdr/overlay/overlayobject.hxx>
#include <basegfx/polygon/b2dpolypolygon.hxx>

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace overlay
	{
		class SVX_DLLPUBLIC OverlayPolyPolygonStriped : public OverlayObject
		{
		protected:
			// geometry
			basegfx::B2DPolyPolygon				maPolyPolygon;

			// Draw geometry
			virtual void drawGeometry(OutputDevice& rOutputDevice);

			// Create the BaseRange. This method needs to calculate maBaseRange.
			virtual void createBaseRange(OutputDevice& rOutputDevice);

			// eventually remove curves from polygon data (maPolyPolygon)
			virtual void preparePolygonData();

		public:
			OverlayPolyPolygonStriped(const basegfx::B2DPolyPolygon& rPolyPolygon);
			virtual ~OverlayPolyPolygonStriped();

			// change geometry
			basegfx::B2DPolyPolygon getPolyPolygon() const { return maPolyPolygon; }
			void setPolyPolygon(const basegfx::B2DPolyPolygon& rNew);

			// Hittest with logical coordinates
			virtual sal_Bool isHit(const basegfx::B2DPoint& rPos, double fTol = 0.0) const;

			// transform object coordinates. Needs to transform maSecondPosition
			// and maThirdPosition.
			virtual void transform(const basegfx::B2DHomMatrix& rMatrix);
		};
	} // end of namespace overlay
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace overlay
	{
		class OverlayPolyPolygon : public OverlayPolyPolygonStriped
		{
		protected:
			// Draw geometry
			virtual void drawGeometry(OutputDevice& rOutputDevice);

			// eventually remove curves from polygon data (maPolyPolygon)
			virtual void preparePolygonData();

		public:
			OverlayPolyPolygon(
				const basegfx::B2DPolyPolygon& rPolyPolygon,
				Color aPolygonColor = Color(COL_BLACK));
			virtual ~OverlayPolyPolygon();
		};
	} // end of namespace overlay
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

#endif //_SDR_OVERLAY_OVERLAYPOLYPOLYGON_HXX

// eof
