/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: ainfotext.cxx,v $
 * $Revision: 1.8 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svx.hxx"
#include <svx/sdr/animation/ainfotext.hxx>
#include <svx/sdr/mixer/basicmixer.hxx>
#include <svx/svdotext.hxx>
#include <svx/sdr/properties/properties.hxx>
#include <svx/sdtaiitm.hxx>
#include <svx/sdtacitm.hxx>
#include <svx/sdtayitm.hxx>
#include <svx/sdr/contact/viewobjectcontact.hxx>
#include <svx/sdr/contact/objectcontact.hxx>
#include <svtools/itemset.hxx>

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace mixer
	{
		class TextBlinkMixer : public BasicMixer
		{
			// The animated object
			SdrObject&								mrObject;

			// bitfield
			// remember if text output was on or off
			unsigned								mbTextWasHidden : 1;

		protected:
			// internal access to SdrObject
			SdrObject& GetSdrObject() const
			{
				return mrObject;
			}

			// setup associated object for paint at given state
			virtual void SetupObject(double fMixerState, sdr::contact::DisplayInfo& rDisplayInfo);

			// restore associated object to original state
			virtual void RestoreObject(sdr::contact::DisplayInfo& rDisplayInfo);

		public:
			// basic constructor.
			TextBlinkMixer(SdrObject& rObject);

			// destructor
			virtual ~TextBlinkMixer();
		};
	} // end of namespace mixer
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace mixer
	{
		// setup associated object for paint at given state
		void TextBlinkMixer::SetupObject(double fMixerState, sdr::contact::DisplayInfo& /*rDisplayInfo*/)
		{
			SdrTextObj& rTextObj = (SdrTextObj&)GetSdrObject();
			mbTextWasHidden = rTextObj.GetTextHidden();

			if(fMixerState < 0.5)
			{
				// show text
				rTextObj.NbcSetTextHidden(sal_False);
			}
			else
			{
				// hide text
				rTextObj.NbcSetTextHidden(sal_True);
			}
		}

		// restore associated object to original state
		void TextBlinkMixer::RestoreObject(sdr::contact::DisplayInfo& /*rDisplayInfo*/)
		{
			SdrTextObj& rTextObj = (SdrTextObj&)GetSdrObject();
			rTextObj.NbcSetTextHidden(mbTextWasHidden);
		}

		TextBlinkMixer::TextBlinkMixer(SdrObject& rObject)
		:	mrObject(rObject)
		{
		}

		TextBlinkMixer::~TextBlinkMixer()
		{
		}
	} // end of namespace mixer
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace animation
	{
		// Access the BasicMixer, plus creation on demand.
		sdr::mixer::BasicMixer* AInfoBlinkText::CreateBasicMixer()
		{
			return new sdr::mixer::TextBlinkMixer(GetSdrObject());
		}

		// calculate the MixerState value for given time
		double AInfoBlinkText::GetMixerState(sal_uInt32 nTime, sdr::contact::DisplayInfo& /*rDisplayInfo*/) const
		{
			double fRetval(0.0);
			sal_Bool bDone(sal_False);
			const sal_uInt32 nLoopTime(2 * mnFrequency);

			if(mnRepeat)
			{
				const sal_uInt32 nEndTime(mnRepeat * nLoopTime);

				if(nTime >= nEndTime)
				{
					if(mbVisisbleWhenStopped)
					{
						fRetval = 0.0;
					}
					else
					{
						fRetval = 1.0;
					}

					bDone = sal_True;
				}
			}

			if(!bDone)
			{
				sal_uInt32 nTimeInLoop(nTime % nLoopTime);
				fRetval = (double)nTimeInLoop / (double)nLoopTime;
			}

			return fRetval;
		}

		// local initializations
		void AInfoBlinkText::ImplInit()
		{
			// get animation values
			const SfxItemSet& rSet = GetSdrObject().GetProperties().GetObjectItemSet();

			// set repeat count
			sal_uInt16 nMaxCount = ((SdrTextAniCountItem&)rSet.Get(SDRATTR_TEXT_ANICOUNT)).GetValue();
			mnRepeat = (sal_uInt32)nMaxCount;

			// set visible when stopped
			mbVisisbleWhenStopped = ((SdrTextAniStopInsideItem&)rSet.Get(SDRATTR_TEXT_ANISTOPINSIDE)).GetValue();
			mbVisisbleWhenStarted = ((SdrTextAniStartInsideItem&)rSet.Get(SDRATTR_TEXT_ANISTOPINSIDE )).GetValue();

			// set frequency
			sal_uInt32 nDelay = (sal_uInt32)((SdrTextAniDelayItem&)rSet.Get(SDRATTR_TEXT_ANIDELAY)).GetValue();
			if(nDelay)
			{
				// set delay if not automatic
				mnFrequency = nDelay;
			}
		}

		// basic constructor.
		AInfoBlinkText::AInfoBlinkText(SdrObject& rObject, sal_uInt32 nDefaultFrequency)
		:	mrObject(rObject),
			mnFrequency(nDefaultFrequency),
			mnRepeat(0L),
			mbVisisbleWhenStopped(sal_True)
		{
			// local initialization
			ImplInit();
		}

		// destructor
		AInfoBlinkText::~AInfoBlinkText()
		{
		}

		// test if to register at ObjectAnimator again after given time.
		// Fill in the new time value and return accordingly.
		sal_Bool AInfoBlinkText::DoRegisterAgain(sal_uInt32 nTime, sal_uInt32& rNewTime, const AnimationState& /*rAssociatedAS*/) const
		{
			sal_Bool bRetval(sal_True);
			const sal_uInt32 nLoopTime(2 * mnFrequency);

			if(mnRepeat)
			{
				const sal_uInt32 nEndTime(mnRepeat * nLoopTime);

				if(nTime >= nEndTime)
				{
					bRetval = sal_False;
				}
			}

			if(bRetval)
			{
				rNewTime = nTime + mnFrequency;
			}

			return bRetval;
		}

		// React on changes of the object of this AnimationInfo.
		void AInfoBlinkText::ActionChanged()
		{
			// call parent
			AInfoMixer::ActionChanged();

			// work on own changes
			ImplInit();
		}

		// Access to VisibleWhenSTarted flags
		sal_Bool AInfoBlinkText::IsVisibleWhenStarted() const
		{
			return mbVisisbleWhenStarted;
		}

		sal_Bool AInfoBlinkText::IsVisibleWhenStopped() const
		{
			return mbVisisbleWhenStopped;
		}

		// Decide if animation is allowed for the given VOC.
		sal_Bool AInfoBlinkText::IsAnimationAllowed(const sdr::contact::ViewObjectContact& rVOContact) const
		{
			// for accessibility, text animation may be forbidden
			return rVOContact.GetObjectContact().IsTextAnimationAllowed();
		}
	} // end of namespace animation
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// eof
