/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef COMPHELPER_ACCESSIBLE_COMPONENT_HELPER_HXX
#define COMPHELPER_ACCESSIBLE_COMPONENT_HELPER_HXX

#include <com/sun/star/accessibility/XAccessibleComponent.hpp>
#include <com/sun/star/accessibility/XAccessibleExtendedComponent.hpp>
#include <comphelper/accessiblecontexthelper.hxx>
#include <cppuhelper/implbase1.hxx>
#include <comphelper/uno3.hxx>
#include "comphelper/comphelperdllapi.h"

//.........................................................................
namespace comphelper
{
//.........................................................................

	//=====================================================================
	//= OCommonAccessibleComponent
	//=====================================================================
	/** base class encapsulating common functionality for the helper classes implementing
		the XAccessibleComponent respectively XAccessibleExtendendComponent
	*/
	class COMPHELPER_DLLPUBLIC OCommonAccessibleComponent : public OAccessibleContextHelper
	{
	protected:
		OCommonAccessibleComponent();
		/// see the respective base class ctor for an extensive comment on this, please
		OCommonAccessibleComponent( IMutex* _pExternalLock );
		~OCommonAccessibleComponent();

	protected:
		/// implements the calculation of the bounding rectangle - still waiting to be overwritten
		virtual ::com::sun::star::awt::Rectangle SAL_CALL implGetBounds(  ) throw (::com::sun::star::uno::RuntimeException) = 0;

	protected:
		/** non-virtual versions of the methods which can be implemented using <method>implGetBounds</method>
			note: getLocationOnScreen relies on a valid parent (XAccessibleContext::getParent()->getAccessibleContext()),
			     which itself implements XAccessibleComponent
		*/
		sal_Bool SAL_CALL containsPoint( const ::com::sun::star::awt::Point& aPoint ) throw (::com::sun::star::uno::RuntimeException);
		::com::sun::star::awt::Point SAL_CALL getLocation(  ) throw (::com::sun::star::uno::RuntimeException);
		::com::sun::star::awt::Point SAL_CALL getLocationOnScreen(  ) throw (::com::sun::star::uno::RuntimeException);
		::com::sun::star::awt::Size SAL_CALL getSize(  ) throw (::com::sun::star::uno::RuntimeException);
		::com::sun::star::awt::Rectangle SAL_CALL getBounds(  ) throw (::com::sun::star::uno::RuntimeException);
	};

	//=====================================================================
	//= OAccessibleComponentHelper
	//=====================================================================

	struct OAccessibleComponentHelper_Base :
		public ::cppu::ImplHelper1< ::com::sun::star::accessibility::XAccessibleComponent >
	{};

	/** a helper class for implementing an AccessibleContext which at the same time
		supports an XAccessibleComponent interface.
	*/
	class COMPHELPER_DLLPUBLIC OAccessibleComponentHelper
			:public OCommonAccessibleComponent
			,public OAccessibleComponentHelper_Base
	{
	protected:
		OAccessibleComponentHelper( );
		/// see the respective base class ctor for an extensive comment on this, please
		OAccessibleComponentHelper( IMutex* _pExternalLock );

	public:
		// XInterface
		DECLARE_XINTERFACE( )
		DECLARE_XTYPEPROVIDER( )

		// XAccessibleComponent - default implementations
		virtual sal_Bool SAL_CALL containsPoint( const ::com::sun::star::awt::Point& aPoint ) throw (::com::sun::star::uno::RuntimeException);
		virtual ::com::sun::star::awt::Point SAL_CALL getLocation(  ) throw (::com::sun::star::uno::RuntimeException);
		virtual ::com::sun::star::awt::Point SAL_CALL getLocationOnScreen(  ) throw (::com::sun::star::uno::RuntimeException);
		virtual ::com::sun::star::awt::Size SAL_CALL getSize(  ) throw (::com::sun::star::uno::RuntimeException);
		virtual ::com::sun::star::awt::Rectangle SAL_CALL getBounds(  ) throw (::com::sun::star::uno::RuntimeException);
	};

	//=====================================================================
	//= OAccessibleExtendedComponentHelper
	//=====================================================================

	typedef	::cppu::ImplHelper1	<	::com::sun::star::accessibility::XAccessibleExtendedComponent
								>	OAccessibleExtendedComponentHelper_Base;

	/** a helper class for implementing an AccessibleContext which at the same time
		supports an XAccessibleExtendedComponent interface.
	*/
	class COMPHELPER_DLLPUBLIC OAccessibleExtendedComponentHelper
			:public OCommonAccessibleComponent
			,public OAccessibleExtendedComponentHelper_Base
	{
	protected:
		OAccessibleExtendedComponentHelper( );
		/// see the respective base class ctor for an extensive comment on this, please
		OAccessibleExtendedComponentHelper( IMutex* _pExternalLock );

	public:
		// XInterface
		DECLARE_XINTERFACE( )
		DECLARE_XTYPEPROVIDER( )

		// XAccessibleComponent - default implementations
		virtual sal_Bool SAL_CALL containsPoint( const ::com::sun::star::awt::Point& aPoint ) throw (::com::sun::star::uno::RuntimeException);
		virtual ::com::sun::star::awt::Point SAL_CALL getLocation(  ) throw (::com::sun::star::uno::RuntimeException);
		virtual ::com::sun::star::awt::Point SAL_CALL getLocationOnScreen(  ) throw (::com::sun::star::uno::RuntimeException);
		virtual ::com::sun::star::awt::Size SAL_CALL getSize(  ) throw (::com::sun::star::uno::RuntimeException);
		virtual ::com::sun::star::awt::Rectangle SAL_CALL getBounds(  ) throw (::com::sun::star::uno::RuntimeException);
	};

//.........................................................................
}	// namespace comphelper
//.........................................................................

#endif // COMPHELPER_ACCESSIBLE_COMPONENT_HELPER_HXX


