/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _INTERCEPT_HXX_
#define _INTERCEPT_HXX_

#include <osl/mutex.hxx>
#include <cppuhelper/implbase3.hxx>
#include <cppuhelper/interfacecontainer.hxx>
#include <com/sun/star/frame/XDispatchProviderInterceptor.hpp>
#include <com/sun/star/frame/XInterceptorInfo.hpp>
#include <com/sun/star/frame/XDispatch.hpp>


class StatusChangeListenerContainer;
class DocumentHolder;

class Interceptor : public ::cppu::WeakImplHelper3< ::com::sun::star::frame::XDispatchProviderInterceptor,
				   									::com::sun::star::frame::XInterceptorInfo,
				   									::com::sun::star::frame::XDispatch>
{
public:

	Interceptor( DocumentHolder* pDocHolder );
	~Interceptor();

	void DisconnectDocHolder();
	// overwritten to release the statuslistner.

	// XComponent
	virtual void SAL_CALL
	addEventListener(
		const com::sun::star::uno::Reference< com::sun::star::lang::XEventListener >& xListener )
		throw( com::sun::star::uno::RuntimeException );
	
	virtual void SAL_CALL
	removeEventListener( const com::sun::star::uno::Reference< com::sun::star::lang::XEventListener >& aListener )
		throw( com::sun::star::uno::RuntimeException );
	
	//XDispatch
	virtual void SAL_CALL 
	dispatch( 
		const ::com::sun::star::util::URL& URL,
		const ::com::sun::star::uno::Sequence<
		::com::sun::star::beans::PropertyValue >& Arguments )
		throw (::com::sun::star::uno::RuntimeException);
	
    virtual void SAL_CALL
	addStatusListener( 
		const ::com::sun::star::uno::Reference< 
		::com::sun::star::frame::XStatusListener >& Control, 
		const ::com::sun::star::util::URL& URL )
		throw (
			::com::sun::star::uno::RuntimeException
		);
	
    virtual void SAL_CALL
	removeStatusListener( 
		const ::com::sun::star::uno::Reference< 
		::com::sun::star::frame::XStatusListener >& Control, 
		const ::com::sun::star::util::URL& URL ) 
		throw (
			::com::sun::star::uno::RuntimeException
		);
	
	//XInterceptorInfo
	virtual ::com::sun::star::uno::Sequence< ::rtl::OUString > 
	SAL_CALL getInterceptedURLs(  )
		throw (
			::com::sun::star::uno::RuntimeException
		);
	
	//XDispatchProvider ( inherited by XDispatchProviderInterceptor )
    virtual ::com::sun::star::uno::Reference< 
	::com::sun::star::frame::XDispatch > SAL_CALL
	queryDispatch( 
		const ::com::sun::star::util::URL& URL,
		const ::rtl::OUString& TargetFrameName, 
		sal_Int32 SearchFlags )
		throw (
			::com::sun::star::uno::RuntimeException
		);
	
    virtual ::com::sun::star::uno::Sequence< 
	::com::sun::star::uno::Reference< 
	::com::sun::star::frame::XDispatch > > SAL_CALL
	queryDispatches( 
		const ::com::sun::star::uno::Sequence<
		::com::sun::star::frame::DispatchDescriptor >& Requests )
		throw (
			::com::sun::star::uno::RuntimeException
		);
	
	
	//XDispatchProviderInterceptor
    virtual ::com::sun::star::uno::Reference<
	::com::sun::star::frame::XDispatchProvider > SAL_CALL 
	getSlaveDispatchProvider(  ) 
		throw (
			::com::sun::star::uno::RuntimeException
		);
	
    virtual void SAL_CALL
	setSlaveDispatchProvider( 
		const ::com::sun::star::uno::Reference< 
		::com::sun::star::frame::XDispatchProvider >& NewDispatchProvider )
		throw (
			::com::sun::star::uno::RuntimeException
		);

    virtual ::com::sun::star::uno::Reference< 
	::com::sun::star::frame::XDispatchProvider > SAL_CALL
	getMasterDispatchProvider(  ) 
		throw (
			::com::sun::star::uno::RuntimeException
		);
	
    virtual void SAL_CALL
	setMasterDispatchProvider( 
		const ::com::sun::star::uno::Reference< 
		::com::sun::star::frame::XDispatchProvider >& NewSupplier )
		throw (
			::com::sun::star::uno::RuntimeException
		);	
	
	
private:
	
	osl::Mutex   m_aMutex;
	
	DocumentHolder*   m_pDocHolder;

	::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchProvider > m_xSlaveDispatchProvider;
	::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchProvider > m_xMasterDispatchProvider;

	static ::com::sun::star::uno::Sequence< ::rtl::OUString > m_aInterceptedURL;

	cppu::OInterfaceContainerHelper*    m_pDisposeEventListeners;
	StatusChangeListenerContainer*    m_pStatCL;
};

#endif

