/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef _SDR_CONTACT_VIEWCONTACTOFSDROBJ_HXX
#define _SDR_CONTACT_VIEWCONTACTOFSDROBJ_HXX

#include <sal/types.h>
#include <svx/sdr/contact/viewcontact.hxx>
#include <svx/sdtakitm.hxx>
#include "svx/svxdllapi.h"

//////////////////////////////////////////////////////////////////////////////
// predeclarations

class SdrObject;
class GeoStat;
class Bitmap;

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace contact
	{
		class SVX_DLLPUBLIC ViewContactOfSdrObj : public ViewContact
		{
		protected:
			// the owner of this ViewContact. Set from constructor and not
			// to be changed in any way.
			SdrObject&										mrObject;

			// Remember AnimationKind of object. Used to find out if that kind
			// has changed in ActionChanged()
			SdrTextAniKind									meRememberedAnimationKind;

			// Create a Object-Specific ViewObjectContact, set ViewContact and
			// ObjectContact. Always needs to return something.
			virtual ViewObjectContact& CreateObjectSpecificViewObjectContact(ObjectContact& rObjectContact);

		public:
			// access to SdrObject
			SdrObject& GetSdrObject() const
			{
				return mrObject;
			}

			// basic constructor, used from SdrObject.
			ViewContactOfSdrObj(SdrObject& rObj);
			virtual ~ViewContactOfSdrObj();

			// Access to possible sub-hierarchy
			virtual sal_uInt32 GetObjectCount() const;
			virtual ViewContact& GetViewContact(sal_uInt32 nIndex) const;
			virtual ViewContact* GetParentContact() const;

			// React on changes of the object of this ViewContact
			virtual void ActionChanged();

			// overload for acessing the SdrObject
			virtual SdrObject* TryToGetSdrObject() const;

			//////////////////////////////////////////////////////////////////////////////
			// primitive stuff

			// add Gluepoints (if available)
			virtual drawinglayer::primitive2d::Primitive2DSequence createGluePointPrimitive2DSequence() const;
		};
	} // end of namespace contact
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

#endif //_SDR_CONTACT_VIEWCONTACTOFSDROBJ_HXX

// eof
