/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svx.hxx"

#ifdef SVX_DLLIMPLEMENTATION
#undef SVX_DLLIMPLEMENTATION
#endif

// include ---------------------------------------------------------------
#include <sfx2/app.hxx>
#include <sfx2/module.hxx>
#include <tools/shl.hxx>

#include <svx/dialogs.hrc>
#include <svx/svddef.hxx>
#include <svx/sdtditm.hxx>
#include <svx/sdtagitm.hxx>
#include <svx/sdtaitm.hxx>
#include <svx/sdtfsitm.hxx>
#include <svx/sdtcfitm.hxx>
#include <svx/svdobj.hxx>
#include <svx/svdmark.hxx>
#include <svx/svdview.hxx>
#include <svx/svdotext.hxx>


#ifndef _SVX_TEXTATTR_CXX
#define _SVX_TEXTATTR_CXX
#endif
#include "textattr.hxx"
#include "textattr.hrc"
#include <svx/dialmgr.hxx>
#include "dlgutil.hxx"
#include <sfx2/request.hxx> //add CHINA001
#include <ofaitem.hxx> //add CHINA001 
#include <svx/svxids.hrc> //add CHINA001
#include <svx/writingmodeitem.hxx>

static USHORT pRanges[] =
{
	SDRATTR_MISC_FIRST, SDRATTR_TEXT_HORZADJUST,
	SDRATTR_TEXT_WORDWRAP, SDRATTR_TEXT_AUTOGROWSIZE,
	0
};

/*************************************************************************
|*
|* Dialog zum Kopieren von Objekten
|*
\************************************************************************/

//CHINA001 SvxTextAttrDialog::SvxTextAttrDialog( Window* pParent, const SfxItemSet& rInAttrs,
//CHINA001 								const SdrView* pSdrView ) :
//CHINA001 		SfxSingleTabDialog( pParent, rInAttrs, RID_SVXPAGE_TEXTATTR )
//CHINA001 {
//CHINA001 SvxTextAttrPage* pPage = new SvxTextAttrPage( this, rInAttrs );
//CHINA001 
//CHINA001 pPage->SetView( pSdrView );
//CHINA001 pPage->Construct();
//CHINA001 
//CHINA001 SetTabPage( pPage );
//CHINA001 SetText( pPage->GetText() );
//CHINA001 }
//CHINA001 
/*************************************************************************
|*
|* Dtor
|*
\************************************************************************/

//CHINA001 SvxTextAttrDialog::~SvxTextAttrDialog()
//CHINA001 {
//CHINA001 }

/*************************************************************************
|*
|* Dialog (Seite) zum Kopieren von Objekten
|*
\************************************************************************/

SvxTextAttrPage::SvxTextAttrPage( Window* pWindow, const SfxItemSet& rInAttrs ) :
				SvxTabPage		( pWindow, SVX_RES( RID_SVXPAGE_TEXTATTR ),
								  rInAttrs ),

				aFlText			( this, SVX_RES( FL_TEXT ) ),
				aTsbAutoGrowWidth  ( this, SVX_RES( TSB_AUTOGROW_WIDTH ) ),
				aTsbAutoGrowHeight ( this, SVX_RES( TSB_AUTOGROW_HEIGHT ) ),
				aTsbFitToSize	( this, SVX_RES( TSB_FIT_TO_SIZE ) ),
				aTsbContour  	( this, SVX_RES( TSB_CONTOUR ) ),
				aTsbWordWrapText( this, SVX_RES( TSB_WORDWRAP_TEXT ) ),
				aTsbAutoGrowSize( this, SVX_RES( TSB_AUTOGROW_SIZE ) ),
				aFlDistance		( this, SVX_RES( FL_DISTANCE ) ),
				aFtLeft			( this, SVX_RES( FT_LEFT ) ),
				aMtrFldLeft		( this, SVX_RES( MTR_FLD_LEFT ) ),
				aFtRight		( this, SVX_RES( FT_RIGHT ) ),
				aMtrFldRight	( this, SVX_RES( MTR_FLD_RIGHT ) ),
				aFtTop			( this, SVX_RES( FT_TOP ) ),
				aMtrFldTop		( this, SVX_RES( MTR_FLD_TOP ) ),
				aFtBottom		( this, SVX_RES( FT_BOTTOM ) ),
				aMtrFldBottom	( this, SVX_RES( MTR_FLD_BOTTOM ) ),

				aFlSeparator	( this, SVX_RES( FL_SEPARATOR ) ),

				aFlPosition		( this, SVX_RES( FL_POSITION ) ),
				aCtlPosition 	( this, SVX_RES( CTL_POSITION ),
											RP_MM, 240, 100 ),
				aTsbFullWidth 	( this, SVX_RES( TSB_FULL_WIDTH ) ),

				rOutAttrs		( rInAttrs )
{
	FreeResource();

	FieldUnit eFUnit = GetModuleFieldUnit( &rInAttrs );
	SetFieldUnit( aMtrFldLeft, eFUnit );
	SetFieldUnit( aMtrFldRight, eFUnit );
	SetFieldUnit( aMtrFldTop, eFUnit );
	SetFieldUnit( aMtrFldBottom, eFUnit );

	Link aLink( LINK( this, SvxTextAttrPage, ClickHdl_Impl ) );
	aTsbAutoGrowWidth.SetClickHdl( aLink );
	aTsbAutoGrowHeight.SetClickHdl( aLink );
	aTsbFitToSize.SetClickHdl( aLink );
	aTsbContour.SetClickHdl( aLink );

	aTsbFullWidth.SetClickHdl(
		LINK( this, SvxTextAttrPage, ClickFullWidthHdl_Impl ) );
}

/*************************************************************************
|*
|* Dtor
|*
\************************************************************************/

SvxTextAttrPage::~SvxTextAttrPage()
{
}

/*************************************************************************
|*
|* Liest uebergebenen Item-Set
|*
\************************************************************************/

void __EXPORT SvxTextAttrPage::Reset( const SfxItemSet& rAttrs )
{
	SfxItemPool* pPool = rAttrs.GetPool();
	DBG_ASSERT( pPool, "Wo ist der Pool" );
	SfxMapUnit eUnit = pPool->GetMetric( SDRATTR_TEXT_LEFTDIST );

	// Linker Abstand vom Rahmen
	const SfxPoolItem* pItem = GetItem( rAttrs, SDRATTR_TEXT_LEFTDIST );

	if( !pItem )
		pItem = &pPool->GetDefaultItem( SDRATTR_TEXT_LEFTDIST );
	if( pItem )
	{
		long nValue = ( ( const SdrTextLeftDistItem* )pItem )->GetValue();
		SetMetricValue( aMtrFldLeft, nValue, eUnit );
	}
	else
		aMtrFldLeft.SetText( String() );
	aMtrFldLeft.SaveValue();

	// Rechter Abstand vom Rahmen
	pItem = GetItem( rAttrs, SDRATTR_TEXT_RIGHTDIST );
	if( !pItem )
		pItem = &pPool->GetDefaultItem( SDRATTR_TEXT_RIGHTDIST );
	if( pItem )
	{
		long nValue = ( ( const SdrTextRightDistItem* )pItem )->GetValue();
		SetMetricValue( aMtrFldRight, nValue, eUnit );
	}
	else
		aMtrFldRight.SetText( String() );
	aMtrFldRight.SaveValue();

	// Oberer Abstand vom Rahmen
	pItem = GetItem( rAttrs, SDRATTR_TEXT_UPPERDIST );
	if( !pItem )
		pItem = &pPool->GetDefaultItem( SDRATTR_TEXT_UPPERDIST );
	if( pItem )
	{
		long nValue = ( ( const SdrTextUpperDistItem* )pItem )->GetValue();
		SetMetricValue( aMtrFldTop, nValue, eUnit );
	}
	else
		aMtrFldTop.SetText( String() );
	aMtrFldTop.SaveValue();

	// Unterer Abstand vom Rahmen
	pItem = GetItem( rAttrs, SDRATTR_TEXT_LOWERDIST );
	if( !pItem )
		pItem = &pPool->GetDefaultItem( SDRATTR_TEXT_LOWERDIST );
	if( pItem )
	{
		long nValue = ( ( const SdrTextLowerDistItem* )pItem )->GetValue();
		SetMetricValue( aMtrFldBottom, nValue, eUnit );
	}
	else
		aMtrFldBottom.SetText( String() );
	aMtrFldBottom.SaveValue();

	// An Hoehe anpassen
	if ( rAttrs.GetItemState( SDRATTR_TEXT_AUTOGROWHEIGHT ) != SFX_ITEM_DONTCARE )
	{
		aTsbAutoGrowHeight.SetState( ( ( const SdrTextAutoGrowHeightItem& )rAttrs.Get( SDRATTR_TEXT_AUTOGROWHEIGHT ) ).
						GetValue() ? STATE_CHECK : STATE_NOCHECK );
		aTsbAutoGrowHeight.EnableTriState( FALSE );
	}
	else
		aTsbAutoGrowHeight.SetState( STATE_DONTKNOW );
	aTsbAutoGrowHeight.SaveValue();

	// An Breite anpassen
	if ( rAttrs.GetItemState( SDRATTR_TEXT_AUTOGROWWIDTH ) != SFX_ITEM_DONTCARE )
	{
		aTsbAutoGrowWidth.SetState( ( ( const SdrTextAutoGrowWidthItem& )rAttrs.Get( SDRATTR_TEXT_AUTOGROWWIDTH ) ).
						GetValue() ? STATE_CHECK : STATE_NOCHECK );
		aTsbAutoGrowWidth.EnableTriState( FALSE );
	}
	else
		aTsbAutoGrowWidth.SetState( STATE_DONTKNOW );
	aTsbAutoGrowWidth.SaveValue();

	// autogrowsize 
	if ( rAttrs.GetItemState( SDRATTR_TEXT_AUTOGROWSIZE ) != SFX_ITEM_DONTCARE )
	{
		aTsbAutoGrowSize.SetState( ( ( const SdrTextAutoGrowHeightItem& )rAttrs.Get( SDRATTR_TEXT_AUTOGROWHEIGHT ) ).
						GetValue() ? STATE_CHECK : STATE_NOCHECK );
		aTsbAutoGrowSize.EnableTriState( FALSE );
	}
	else
		aTsbAutoGrowSize.SetState( STATE_DONTKNOW );
	aTsbAutoGrowSize.SaveValue();

	// wordwrap text
	if ( rAttrs.GetItemState( SDRATTR_TEXT_WORDWRAP ) != SFX_ITEM_DONTCARE )
	{
		aTsbWordWrapText.SetState( ( ( const SdrTextWordWrapItem& )rAttrs.Get( SDRATTR_TEXT_WORDWRAP ) ).
						GetValue() ? STATE_CHECK : STATE_NOCHECK );
		aTsbWordWrapText.EnableTriState( FALSE );
	}
	else
		aTsbWordWrapText.SetState( STATE_DONTKNOW );
	aTsbWordWrapText.SaveValue();


	// #103516# Do the setup based on states of hor/ver adjust
	// Setup center field and FullWidth
	SfxItemState eVState = rAttrs.GetItemState( SDRATTR_TEXT_VERTADJUST );
	SfxItemState eHState = rAttrs.GetItemState( SDRATTR_TEXT_HORZADJUST );

	if(SFX_ITEM_DONTCARE != eVState && SFX_ITEM_DONTCARE != eHState)
	{
		// VertAdjust and HorAdjust are unequivocal, thus 
		SdrTextVertAdjust eTVA = (SdrTextVertAdjust)((const SdrTextVertAdjustItem&)rAttrs.Get(SDRATTR_TEXT_VERTADJUST)).GetValue();
		SdrTextHorzAdjust eTHA = (SdrTextHorzAdjust)((const SdrTextHorzAdjustItem&)rAttrs.Get(SDRATTR_TEXT_HORZADJUST)).GetValue();
		RECT_POINT eRP = RP_LB;
	
		aTsbFullWidth.EnableTriState( FALSE );

        // Translate item values into local anchor position.
		switch (eTVA)
        {
            case SDRTEXTVERTADJUST_TOP:
			{
                switch (eTHA)
                {
                    case SDRTEXTHORZADJUST_LEFT: eRP = RP_LT; break;
                    case SDRTEXTHORZADJUST_BLOCK:
                    case SDRTEXTHORZADJUST_CENTER: eRP = RP_MT; break;
                    case SDRTEXTHORZADJUST_RIGHT: eRP = RP_RT; break;
                }
                break;
			}
            case SDRTEXTVERTADJUST_BLOCK:
            case SDRTEXTVERTADJUST_CENTER:
			{
                switch (eTHA)
                {
                    case SDRTEXTHORZADJUST_LEFT: eRP = RP_LM; break;
                    case SDRTEXTHORZADJUST_BLOCK:
                    case SDRTEXTHORZADJUST_CENTER: eRP = RP_MM; break;
                    case SDRTEXTHORZADJUST_RIGHT: eRP = RP_RM; break;
                }
                break;
			}
            case SDRTEXTVERTADJUST_BOTTOM:
			{
                switch (eTHA)
                {
                    case SDRTEXTHORZADJUST_LEFT: eRP = RP_LB; break;
                    case SDRTEXTHORZADJUST_BLOCK:
                    case SDRTEXTHORZADJUST_CENTER: eRP = RP_MB; break;
                    case SDRTEXTHORZADJUST_RIGHT: eRP = RP_RB; break;
                }
				break;
			}
			default:
				break;
		}

        // See if we have to check the "full width" check button.
        sal_Bool bLeftToRight(IsTextDirectionLeftToRight());
        
		if((bLeftToRight && (SDRTEXTHORZADJUST_BLOCK == eTHA)) || (!bLeftToRight && (SDRTEXTVERTADJUST_BLOCK == eTVA)))
        {
            // Move anchor to valid position.
            ClickFullWidthHdl_Impl(NULL);
            aTsbFullWidth.SetState(STATE_CHECK);
        }

		aCtlPosition.SetActualRP( eRP );
	}
	else
	{
		// VertAdjust or HorAdjust is not unequivocal
		aCtlPosition.Reset();
		
		aCtlPosition.SetState(STATE_DONTKNOW);
		aCtlPosition.DoCompletelyDisable(sal_True);

		aTsbFullWidth.SetState(STATE_DONTKNOW);
		aTsbFullWidth.Enable( sal_False );
		aFlPosition.Enable( sal_False );
	}

	// Am Rahmen anpassen
	if ( rAttrs.GetItemState( SDRATTR_TEXT_FITTOSIZE ) != SFX_ITEM_DONTCARE )
	{
		SdrFitToSizeType eFTS = (SdrFitToSizeType)
					( ( const SdrTextFitToSizeTypeItem& )rAttrs.Get( SDRATTR_TEXT_FITTOSIZE ) ).GetValue();
		aTsbFitToSize.SetState( eFTS == SDRTEXTFIT_NONE ? STATE_NOCHECK : STATE_CHECK );
		aTsbFitToSize.EnableTriState( FALSE );
	}
	else
		aTsbFitToSize.SetState( STATE_DONTKNOW );
	aTsbFitToSize.SaveValue();

	// Konturfluss
	if( rAttrs.GetItemState( SDRATTR_TEXT_CONTOURFRAME ) != SFX_ITEM_DONTCARE )
	{
		BOOL bContour = ( ( const SdrTextContourFrameItem& )rAttrs.Get( SDRATTR_TEXT_CONTOURFRAME ) ).GetValue();
		aTsbContour.SetState( bContour ? STATE_CHECK : STATE_NOCHECK );
		aTsbContour.EnableTriState( FALSE );
	}
	else
		aTsbContour.SetState( STATE_DONTKNOW );
	aTsbContour.SaveValue();

	ClickHdl_Impl( NULL );
}

/*************************************************************************
|*
|* Fuellt uebergebenen Item-Set mit Dialogbox-Attributen
|*
\************************************************************************/

BOOL SvxTextAttrPage::FillItemSet( SfxItemSet& rAttrs)
{
	SfxItemPool* pPool = rAttrs.GetPool();
	DBG_ASSERT( pPool, "Wo ist der Pool" );
	SfxMapUnit eUnit = pPool->GetMetric( SDRATTR_TEXT_LEFTDIST );

	INT32	 nValue;
	TriState eState;

	if( aMtrFldLeft.GetText() != aMtrFldLeft.GetSavedValue() )
	{
		nValue = GetCoreValue( aMtrFldLeft, eUnit );
		rAttrs.Put( SdrTextLeftDistItem( nValue ) );
	}

	if( aMtrFldRight.GetText() != aMtrFldRight.GetSavedValue() )
	{
		nValue = GetCoreValue( aMtrFldRight, eUnit );
		rAttrs.Put( SdrTextRightDistItem( nValue ) );
	}

	if( aMtrFldTop.GetText() != aMtrFldTop.GetSavedValue() )
	{
		nValue = GetCoreValue( aMtrFldTop, eUnit );
		rAttrs.Put( SdrTextUpperDistItem( nValue ) );
	}

	if( aMtrFldBottom.GetText() != aMtrFldBottom.GetSavedValue() )
	{
		nValue = GetCoreValue( aMtrFldBottom, eUnit );
		rAttrs.Put( SdrTextLowerDistItem( nValue ) );
	}

	eState = aTsbAutoGrowHeight.GetState();
	if( eState != aTsbAutoGrowHeight.GetSavedValue() )
	{
		rAttrs.Put( SdrTextAutoGrowHeightItem( (BOOL) STATE_CHECK == eState ) );
	}

	eState = aTsbAutoGrowWidth.GetState();
	if( eState != aTsbAutoGrowWidth.GetSavedValue() )
	{
		rAttrs.Put( SdrTextAutoGrowWidthItem( (BOOL) STATE_CHECK == eState ) );
	}

	eState = aTsbAutoGrowSize.GetState();
	if( eState != aTsbAutoGrowSize.GetSavedValue() )
	{
		rAttrs.Put( SdrTextAutoGrowHeightItem( (BOOL) STATE_CHECK == eState ) );
	}

	eState = aTsbWordWrapText.GetState();
	if( eState != aTsbWordWrapText.GetSavedValue() )
	{
		rAttrs.Put( SdrTextWordWrapItem( (BOOL) STATE_CHECK == eState ) );
	}

	// Konturfluss
	eState = aTsbContour.GetState();
	if( eState != aTsbContour.GetSavedValue() )
	{
		rAttrs.Put( SdrTextContourFrameItem( (BOOL) STATE_CHECK == eState ) );
	}

	eState = aTsbFitToSize.GetState();
	if( eState != aTsbFitToSize.GetSavedValue() )
	{
		SdrFitToSizeType eFTS;
		switch( eState )
		{
            default: ; //prevent warning
				DBG_ERROR( "svx::SvxTextAttrPage::FillItemSet(), unhandled state!" );
			case STATE_NOCHECK: eFTS = SDRTEXTFIT_NONE; break;
			//case STATE_CHECK: eFTS = SDRTEXTFIT_RESIZEATTR; break;
			case STATE_CHECK: eFTS = SDRTEXTFIT_PROPORTIONAL; break;
		}
		rAttrs.Put( SdrTextFitToSizeTypeItem( eFTS ) );
	}

	// zentriert
	RECT_POINT eRP = aCtlPosition.GetActualRP();
	SdrTextVertAdjust eTVA, eOldTVA;
	SdrTextHorzAdjust eTHA, eOldTHA;

	switch( eRP )
	{
		default:
		case RP_LT: eTVA = SDRTEXTVERTADJUST_TOP;
					eTHA = SDRTEXTHORZADJUST_LEFT; break;
		case RP_LM: eTVA = SDRTEXTVERTADJUST_CENTER;
					eTHA = SDRTEXTHORZADJUST_LEFT; break;
		case RP_LB: eTVA = SDRTEXTVERTADJUST_BOTTOM;
					eTHA = SDRTEXTHORZADJUST_LEFT; break;
		case RP_MT: eTVA = SDRTEXTVERTADJUST_TOP;
					eTHA = SDRTEXTHORZADJUST_CENTER; break;
		case RP_MM: eTVA = SDRTEXTVERTADJUST_CENTER;
					eTHA = SDRTEXTHORZADJUST_CENTER; break;
		case RP_MB: eTVA = SDRTEXTVERTADJUST_BOTTOM;
					eTHA = SDRTEXTHORZADJUST_CENTER; break;
		case RP_RT: eTVA = SDRTEXTVERTADJUST_TOP;
					eTHA = SDRTEXTHORZADJUST_RIGHT; break;
		case RP_RM: eTVA = SDRTEXTVERTADJUST_CENTER;
					eTHA = SDRTEXTHORZADJUST_RIGHT; break;
		case RP_RB: eTVA = SDRTEXTVERTADJUST_BOTTOM;
					eTHA = SDRTEXTHORZADJUST_RIGHT; break;
	}

	// #103516# Do not change values if adjust controls were disabled.
	sal_Bool bIsDisabled(aCtlPosition.IsCompletelyDisabled());

	if(!bIsDisabled)
	{
		if( aTsbFullWidth.GetState() == STATE_CHECK )
		{
			if (IsTextDirectionLeftToRight())
				eTHA = SDRTEXTHORZADJUST_BLOCK;
			else
				eTVA = SDRTEXTVERTADJUST_BLOCK;
		}

		if ( rOutAttrs.GetItemState( SDRATTR_TEXT_VERTADJUST ) != SFX_ITEM_DONTCARE )
		{
			eOldTVA = (SdrTextVertAdjust)
						( ( const SdrTextVertAdjustItem& )rOutAttrs.Get( SDRATTR_TEXT_VERTADJUST ) ).GetValue();
			if( eOldTVA != eTVA )
				rAttrs.Put( SdrTextVertAdjustItem( eTVA ) );
		}
		else
			rAttrs.Put( SdrTextVertAdjustItem( eTVA ) );

		if ( rOutAttrs.GetItemState( SDRATTR_TEXT_HORZADJUST ) != SFX_ITEM_DONTCARE )
		{
			eOldTHA = (SdrTextHorzAdjust)
						( ( const SdrTextHorzAdjustItem& )rOutAttrs.Get( SDRATTR_TEXT_HORZADJUST ) ).GetValue();
			if( eOldTHA != eTHA )
				rAttrs.Put( SdrTextHorzAdjustItem( eTHA ) );
		}
		else
			rAttrs.Put( SdrTextHorzAdjustItem( eTHA ) );
	}

	return( TRUE );
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SvxTextAttrPage::Construct()
{
	DBG_ASSERT( pView, "Keine gueltige View Uebergeben!" );

	bFitToSizeEnabled = bContourEnabled = TRUE;
	bWordWrapTextEnabled = bAutoGrowSizeEnabled = bAutoGrowWidthEnabled = bAutoGrowHeightEnabled = FALSE;

	const SdrMarkList& rMarkList = pView->GetMarkedObjectList();
	if( rMarkList.GetMarkCount() == 1 )
	{
		const SdrObject* pObj = rMarkList.GetMark( 0 )->GetMarkedSdrObj();
		SdrObjKind eKind = (SdrObjKind) pObj->GetObjIdentifier();
		if( pObj->GetObjInventor() == SdrInventor )
		{
			switch( eKind )
			{
				case OBJ_TEXT :
				case OBJ_TITLETEXT :
				case OBJ_OUTLINETEXT :
				case OBJ_CAPTION :
				{
					if ( ((SdrTextObj*)pObj)->HasText() )
					{
						// Konturfluss ist NICHT bei reinen Textobjekten m�glich
						bContourEnabled = FALSE;

						// Breite und Hoehe anpassen ist NUR bei reinen Textobjekten m�glich
						bAutoGrowWidthEnabled = bAutoGrowHeightEnabled = TRUE;
					}
				}
				break;
				case OBJ_CUSTOMSHAPE :
				{
					bFitToSizeEnabled = bContourEnabled = FALSE;
					bAutoGrowSizeEnabled = TRUE;
					bWordWrapTextEnabled = TRUE;
				}
				break;
                default: ;//prevent warning
			}
		}
	}
	aTsbAutoGrowHeight.Enable( bAutoGrowHeightEnabled );
	aTsbAutoGrowWidth.Enable( bAutoGrowWidthEnabled );
	aTsbFitToSize.Enable( bFitToSizeEnabled );
	aTsbContour.Enable( bContourEnabled );
	aTsbAutoGrowSize.Enable( bAutoGrowSizeEnabled );
	aTsbWordWrapText.Enable( bWordWrapTextEnabled );
}

/*************************************************************************
|*
|* Erzeugt die Seite
|*
\************************************************************************/

SfxTabPage* SvxTextAttrPage::Create( Window* pWindow,
				const SfxItemSet& rAttrs )
{
	return( new SvxTextAttrPage( pWindow, rAttrs ) );
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

USHORT*	SvxTextAttrPage::GetRanges()
{
	return( pRanges );
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

/** Check whether we have to uncheck the "Full width" check box.
*/
void SvxTextAttrPage::PointChanged( Window*, RECT_POINT eRP )
{
    if (aTsbFullWidth.GetState() == STATE_CHECK)
    {
        // Depending on write direction and currently checked anchor we have
        // to uncheck the "full width" button.
        if (IsTextDirectionLeftToRight())
            switch( eRP )
            {
                case RP_LT:
                case RP_LM:
                case RP_LB:
                case RP_RT:
                case RP_RM:
                case RP_RB:
                    aTsbFullWidth.SetState( STATE_NOCHECK );
                break;
                default: ;//prevent warning
            }
        else
            switch (eRP)
            {
                case RP_LT:
                case RP_MT:
                case RP_RT:
                case RP_LB:
                case RP_MB:
                case RP_RB:
                    aTsbFullWidth.SetState( STATE_NOCHECK );
                break;
                default: ;//prevent warning
            }
	}
}

/*************************************************************************
|*
|* Aendert evtl. die Position des Positions-Controls
|*
\************************************************************************/

/** When switching the "full width" check button on the text anchor may have
    to be moved to a valid and adjacent position.  This position depends on
    the current anchor position and the text writing direction.
*/
IMPL_LINK( SvxTextAttrPage, ClickFullWidthHdl_Impl, void *, EMPTYARG )
{
	if( aTsbFullWidth.GetState() == STATE_CHECK )
	{
        if (IsTextDirectionLeftToRight())
        {
            // Move text anchor to horizontal middle axis.
            switch( aCtlPosition.GetActualRP() )
            {
                case RP_LT:
                case RP_RT:
                    aCtlPosition.SetActualRP( RP_MT );
                    break;
                    
                case RP_LM:
                case RP_RM:
                    aCtlPosition.SetActualRP( RP_MM );
                    break;
                    
                case RP_LB:
                case RP_RB:
                    aCtlPosition.SetActualRP( RP_MB );
                    break;
                default: ;//prevent warning
            }
        }
        else
        {
            // Move text anchor to vertical middle axis.
            switch( aCtlPosition.GetActualRP() )
            {
                case RP_LT:
                case RP_LB:
                    aCtlPosition.SetActualRP( RP_LM );
                    break;
                    
                case RP_MT:
                case RP_MB:
                    aCtlPosition.SetActualRP( RP_MM );
                    break;
                    
                case RP_RT:
                case RP_RB:
                    aCtlPosition.SetActualRP( RP_RM );
                break;
                default: ;//prevent warning
            }
        }
	}
	return( 0L );
}

/*************************************************************************
|*
|* Enabled/Disabled "Groesse an Text" oder "Am Rahmen Anpassen"
|*
\************************************************************************/

IMPL_LINK( SvxTextAttrPage, ClickHdl_Impl, void *, EMPTYARG )
{
	BOOL bAutoGrowWidth  = aTsbAutoGrowWidth.GetState() == STATE_CHECK;
	BOOL bAutoGrowHeight = aTsbAutoGrowHeight.GetState() == STATE_CHECK;
	BOOL bFitToSize 	 = aTsbFitToSize.GetState() == STATE_CHECK;
	BOOL bContour		 = aTsbContour.GetState() == STATE_CHECK;

	aTsbContour.Enable( !bFitToSize &&
						!( ( bAutoGrowWidth && bAutoGrowWidthEnabled ) || ( bAutoGrowHeight && bAutoGrowHeightEnabled ) ) &&
						bContourEnabled );

	aTsbAutoGrowWidth.Enable( !bFitToSize &&
							  !( bContour && bContourEnabled ) &&
							  bAutoGrowWidthEnabled );

	aTsbAutoGrowHeight.Enable( !bFitToSize &&
							   !( bContour && bContourEnabled ) &&
							   bAutoGrowHeightEnabled );

	aTsbFitToSize.Enable( !( ( bAutoGrowWidth && bAutoGrowWidthEnabled ) || ( bAutoGrowHeight && bAutoGrowHeightEnabled ) ) &&
						  !( bContour && bContourEnabled ) &&
						  bFitToSizeEnabled );

	// #101901# enable/disable metric fields and decorations dependent of contour
    aMtrFldLeft.Enable(!bContour);
    aMtrFldRight.Enable(!bContour);
    aMtrFldTop.Enable(!bContour);
    aMtrFldBottom.Enable(!bContour);
    aFlDistance.Enable(!bContour);
    aFtLeft.Enable(!bContour);
    aFtRight.Enable(!bContour);
    aFtTop.Enable(!bContour);
    aFtBottom.Enable(!bContour);

	if( bContour && bContourEnabled )
	{
		aMtrFldLeft.SetValue( 0 );
		aMtrFldRight.SetValue( 0 );
		aMtrFldTop.SetValue( 0 );
		aMtrFldBottom.SetValue( 0 );
	}

	// #103516# Do the setup based on states of hor/ver adjust
	SfxItemState eVState = rOutAttrs.GetItemState( SDRATTR_TEXT_VERTADJUST );
	SfxItemState eHState = rOutAttrs.GetItemState( SDRATTR_TEXT_HORZADJUST );
	sal_Bool bHorAndVer(SFX_ITEM_DONTCARE == eVState || SFX_ITEM_DONTCARE == eHState);

	// #83698# enable/disable text anchoring dependent of contour
	aCtlPosition.Enable(!bContour && !bHorAndVer);
	aTsbFullWidth.Enable(!bContour && !bHorAndVer);
	aFlPosition.Enable(!bContour && !bHorAndVer);

	return( 0L );
}


bool SvxTextAttrPage::IsTextDirectionLeftToRight (void) const
{
    // Determine the text writing direction with left to right as default.
    bool bLeftToRightDirection = true;
	SfxItemState eState = rOutAttrs.GetItemState(SDRATTR_TEXTDIRECTION);

    if(SFX_ITEM_DONTCARE != eState)
    {
        const SvxWritingModeItem& rItem = static_cast<const SvxWritingModeItem&> (
            rOutAttrs.Get (SDRATTR_TEXTDIRECTION));
        if (rItem.GetValue() == com::sun::star::text::WritingMode_TB_RL)
            bLeftToRightDirection = false;
    }
    return bLeftToRightDirection;
}

//add CHINA001 begin
void SvxTextAttrPage::PageCreated(SfxAllItemSet aSet)
{
	SFX_ITEMSET_ARG (&aSet,pViewItem,OfaPtrItem,SID_SVXTEXTATTRPAGE_VIEW,sal_False);
	
	if (pViewItem)
		SetView( static_cast<SdrView *>(pViewItem->GetValue()));
	
	Construct();
}

//end of CHINA001
