/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_vcl.hxx"
#include <vcl/unohelp2.hxx>
#include <sot/exchange.hxx>
#include <sot/formats.hxx>
#include <tools/debug.hxx>
#include <vcl/svapp.hxx>
#include <com/sun/star/datatransfer/clipboard/XClipboard.hpp>
#include <com/sun/star/datatransfer/clipboard/XFlushableClipboard.hpp>


using namespace ::com::sun::star;

namespace vcl { namespace unohelper {

	TextDataObject::TextDataObject( const String& rText ) : maText( rText )
	{
	}

	TextDataObject::~TextDataObject()
	{
	}
			
    void TextDataObject::CopyStringTo( const String& rContent,
        const uno::Reference< datatransfer::clipboard::XClipboard >& rxClipboard )
    {
        DBG_ASSERT( rxClipboard.is(), "TextDataObject::CopyStringTo: invalid clipboard!" );
        if ( !rxClipboard.is() )
            return;

        TextDataObject* pDataObj = new TextDataObject( rContent );

        const sal_uInt32 nRef = Application::ReleaseSolarMutex();
        try
	    {
            rxClipboard->setContents( pDataObj, NULL );

            uno::Reference< datatransfer::clipboard::XFlushableClipboard > xFlushableClipboard( rxClipboard, uno::UNO_QUERY );
	        if( xFlushableClipboard.is() )
		        xFlushableClipboard->flushClipboard();
	    }
	    catch( const uno::Exception& )
	    {
	    }
        Application::AcquireSolarMutex( nRef );
    }

	// ::com::sun::star::uno::XInterface
	uno::Any TextDataObject::queryInterface( const uno::Type & rType ) throw(uno::RuntimeException)
	{
		uno::Any aRet = ::cppu::queryInterface( rType, SAL_STATIC_CAST( datatransfer::XTransferable*, this ) );
		return (aRet.hasValue() ? aRet : OWeakObject::queryInterface( rType ));
	}

	// ::com::sun::star::datatransfer::XTransferable
	uno::Any TextDataObject::getTransferData( const datatransfer::DataFlavor& rFlavor ) throw(datatransfer::UnsupportedFlavorException, io::IOException, uno::RuntimeException)
	{
		uno::Any aAny;

		ULONG nT = SotExchange::GetFormat( rFlavor );
		if ( nT == SOT_FORMAT_STRING )
		{
			aAny <<= (::rtl::OUString)GetString();
		}
		else
		{
			throw datatransfer::UnsupportedFlavorException();
		}
		return aAny;
	}

	uno::Sequence< datatransfer::DataFlavor > TextDataObject::getTransferDataFlavors(  ) throw(uno::RuntimeException)
	{
		uno::Sequence< datatransfer::DataFlavor > aDataFlavors(1);
		SotExchange::GetFormatDataFlavor( SOT_FORMAT_STRING, aDataFlavors.getArray()[0] );
		return aDataFlavors;
	}

	sal_Bool TextDataObject::isDataFlavorSupported( const datatransfer::DataFlavor& rFlavor ) throw(uno::RuntimeException)
	{
		ULONG nT = SotExchange::GetFormat( rFlavor );
		return ( nT == SOT_FORMAT_STRING );
	}

}}	// namespace vcl::unohelper
