/*
 *  Copyright 2001-2005 Internet2
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* SAMLDoNotCacheCondition.cpp - SAML audience condition implementation

   Scott Cantor
   5/9/04

   $History:$
*/

#include "internal.h"

using namespace saml;
using namespace std;


SAMLDoNotCacheCondition::SAMLDoNotCacheCondition()
{
    RTTI(SAMLDoNotCacheCondition);
}

SAMLDoNotCacheCondition::SAMLDoNotCacheCondition(DOMElement* e)
{
    RTTI(SAMLDoNotCacheCondition);
    fromDOM(e);
}

SAMLDoNotCacheCondition::SAMLDoNotCacheCondition(istream& in) : SAMLCondition(in)
{
    RTTI(SAMLDoNotCacheCondition);
    fromDOM(m_document->getDocumentElement());
}

void SAMLDoNotCacheCondition::fromDOM(DOMElement* e)
{
    SAMLObject::fromDOM(e);

    if (SAMLConfig::getConfig().strict_dom_checking) {
        if (XMLString::compareString(XML::SAML_NS,e->getNamespaceURI()))
            throw MalformedException("SAMLDoNotCacheCondition::fromDOM() missing saml namespace on root element");

        if (XMLString::compareString(L(DoNotCacheCondition),e->getLocalName())) {
            auto_ptr<saml::QName> type(saml::QName::getQNameAttribute(e,XML::XSI_NS,L(type)));
            if (XMLString::compareString(L(Condition),e->getLocalName()) ||
                !type.get() || XMLString::compareString(XML::SAML_NS,type->getNamespaceURI()) ||
                XMLString::compareString(L(DoNotCacheConditionType),type->getLocalName()))
                throw MalformedException("SAMLDoNotCacheCondition::fromDOM() requires saml:DoNotCacheCondition at root");
        }
    }
}

DOMElement* SAMLDoNotCacheCondition::buildRoot(DOMDocument* doc, bool xmlns) const
{
    DOMElement* c=doc->createElementNS(XML::SAML_NS,L(DoNotCacheCondition));
    if (xmlns)
        c->setAttributeNS(XML::XMLNS_NS,L(xmlns),XML::SAML_NS);
    return c;
}

DOMNode* SAMLDoNotCacheCondition::toDOM(DOMDocument* doc, bool xmlns) const
{
    SAMLObject::toDOM(doc,xmlns);
    
    if (m_bDirty)
        setClean();
    else if (xmlns) {
        DECLARE_DEF_NAMESPACE(static_cast<DOMElement*>(m_root),XML::SAML_NS);
    }

    return m_root;
}

SAMLObject* SAMLDoNotCacheCondition::clone() const
{
    return new SAMLDoNotCacheCondition();
}
