<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">

	<xsl:template match="/">
		<document xmlns:fo="http://www.w3.org/1999/XSL/Format">
			<template leftMargin="2.0cm" rightMargin="2.0cm" topMargin="2.0cm"
				bottomMargin="2.0cm" title="Bill of material"
				author="Generated by Tiny ERP" allowSplitting="20">
				<xsl:for-each select="/boms/bom">
					<pageTemplate>
						<xsl:attribute name="id">
							<xsl:value-of select="position()" />
						</xsl:attribute>
						<pageGraphics>
							<!--page bottom-->
							<place x="1cm" y="1.5cm" width="19cm" height="3cm">
								<blockTable colWidths="11cm,4cm,4cm" style="cadre">
									<tr>
										<td>
											<para style="huge">
												<xsl:value-of select="name" />
											</para>
											<spacer length="5mm" />
											<para>
												<xsl:value-of select="product" />
											</para>
										</td>
										<td>
											<para style="huge">
												<xsl:text>N° </xsl:text><xsl:value-of select="id" />
											</para>
										</td>
										<td>
											<para>INDICE</para>
											<para>
												<xsl:value-of 
													select="revision[last()]/indice" />
											</para>
										</td>
									</tr>
								</blockTable>
							</place>
						</pageGraphics>
						<frame id="list" x1="1cm" y1="1.0cm" width="19.0cm" height="24.5cm" />
					</pageTemplate>
				</xsl:for-each>
			</template>
			<stylesheet>
				<paraStyle name="huge" fontSize="15" />
				<blockTableStyle id="bom">
					<blockValign value="TOP" />
					<blockTextColor colorName="white" start="0,0" stop="-1,0" />
					<blockBackground colorName="grey" start="0,0" stop="-1,0" />
					<lineStyle kind="LINEABOVE" thickness="0.5" start="0,0"
						stop="-1,0" colorName="black" />
					<lineStyle kind="LINEBELOW" thickness="0.5" colorName="black" />
					<lineStyle kind="LINEBEFORE" thickness="0.5" colorName="black" />
					<lineStyle kind="LINEAFTER" thickness="0.5" colorName="black" />
				</blockTableStyle>

				<blockTableStyle id="cadre">
					<blockValign value="TOP" />
					<lineStyle kind="LINEABOVE" thickness="0.5" start="0,0"
						stop="-1,0" colorName="black" />
					<lineStyle kind="LINEBELOW" thickness="0.5" colorName="black" />
					<lineStyle kind="LINEBEFORE" thickness="0.5" colorName="black" />
					<lineStyle kind="LINEAFTER" thickness="0.5" colorName="black" />
				</blockTableStyle>

				<blockTableStyle id="cadre2">
					<blockValign value="TOP" />
					<lineStyle kind="LINEBELOW" thickness="0.5" colorName="black" start="0,0" stop="-1,-2"/>
				</blockTableStyle>
			</stylesheet>
			<story>
				<xsl:apply-templates select="/boms/bom" />
			</story>
		</document>

	</xsl:template>

	<xsl:template match="bom">
		<blockTable repeatRows="1" colWidths="1.5cm,1.5cm,8cm,4cm"
			style="bom">
			<tr>
				<td>Pos.</td>
				<td>Qty</td>
				<td>Designation</td>
				<td>Ref</td>
			</tr>
			<xsl:for-each select="bom-line">
				<tr>
					<td>
						<xsl:value-of select="pos" />
					</td>
					<td>
						<xsl:value-of select="qty" />
					</td>
					<td>
						<xsl:value-of select="name" />
					</td>
					<td/>
				</tr>
			</xsl:for-each>
		</blockTable>
		<blockTable colWidths="11cm,4cm,4cm" style="cadre">
			<tr>
				<td>
					<blockTable colWidths="1cm,5cm,2cm,2cm"
						style="cadre2">
						<tr>
							<td>Indice</td>
							<td>Modification</td>
							<td>Author</td>
							<td>Date</td>
						</tr>
						<xsl:for-each select="revision">
							<tr>
								<td>
									<xsl:value-of select="indice" />
								</td>
								<td>
									<xsl:value-of select="modif" />
								</td>
								<td>
									<xsl:value-of select="author" />
								</td>
								<td>
									<xsl:value-of select="date" />
								</td>
							</tr>
						</xsl:for-each>
					</blockTable>
				</td>
				<td>
					<para>
						<xsl:text>Date </xsl:text>
					</para>
					<para>
						<xsl:value-of select="date" />
					</para>
				</td>
				<td>
					<xsl:text>Page </xsl:text>
				</td>
			</tr>
		</blockTable>

		<xsl:if test="position() &lt; count(/boms/bom)">
			<setNextTemplate>
				<xsl:attribute name="name">
					<xsl:value-of select="position()+1" />
				</xsl:attribute>
			</setNextTemplate>
		</xsl:if>
		<pageBreak />
	</xsl:template>
</xsl:stylesheet>
