
/**************************************************************************
 *                                                                        *
 *  BTools - Miscellaneous Java utility classes                           *
 *                                                                        *
 *  Copyright (c) 1998-2001, Ben Burton                                   *
 *  For further details contact Ben Burton (benb@acm.org).                *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or         *
 *  modify it under the terms of the GNU General Public License as        *
 *  published by the Free Software Foundation; either version 2 of the    *
 *  License, or (at your option) any later version.                       *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful, but   *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *  General Public License for more details.                              *
 *                                                                        *
 *  You should have received a copy of the GNU General Public             *
 *  License along with this program; if not, write to the Free            *
 *  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,        *
 *  MA 02111-1307, USA.                                                   *
 *                                                                        *
 **************************************************************************/

/* end stub */

package org.gjt.btools.utilities;

/**
 * Stores an object and a corresponding text description.  This can be
 * used in list boxes, combo boxes and the like where the program needs
 * to store some underlying value but the user interface should display
 * a friendly description.  Routine <tt>toString()</tt> has been
 * overridden to behave properly in these circumstances.
 */
public final class ExtendedObject {
    /**
     * The underlying value stored.
     */
    private Object value;

    /**
     * The corresponding text description.
     */
    private String description;

    /**
     * Creates a new extended object.
     *
     * @param value the underlying value to store.
     * @param desc the corresponding text description.
     */
    public ExtendedObject(Object value, String desc) {
        this.value = value;
        this.description = desc;
    }

    /**
     * Returns the underlying value stored with this object.
     *
     * @return the underlying value.
     */
    public Object getValue() {
        return value;
    }

    /**
     * Sets the underlying value stored with this object.
     *
     * @param value the new underlying value to store.
     */
    public void setValue(Object value) {
        this.value = value;
    }

    /**
     * Returns the text description associated with this object.
     *
     * @return the text description.
     */
    public String getDescription() {
        return description;
    }

    /**
     * Sets the text description associated with this object.
     *
     * @param desc the new text description.
     */
    public void setDescription(String desc) {
        this.description = desc;
    }

    /**
     * Returns the text description associated with this object.
     * If the description is <tt>null</tt>, this routine will return
     * <tt>value.toString()</tt> where <tt>value</tt> is the underlying
     * value stored.
     *
     * @return the description for this object.
     */
    public String toString() {
        return (description == null ? value.toString() : description);
    }
}
