/*  gngeo a neogeo emulator
 *  Copyright (C) 2001 Peponas Mathieu
 * 
 *  This program is free software; you can redistribute it and/or modify  
 *  it under the terms of the GNU General Public License as published by   
 *  the Free Software Foundation; either version 2 of the License, or    
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
 */

#ifndef _MEMORY_H_
#define _MEMORY_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <SDL.h>
#include "video.h"
#include "ym2610/2610intf.h"
#include "state.h"
#include "driver.h"

#define READ_WORD(a)          (*(UINT16 *)(a))
#define WRITE_WORD(a,d)       (*(UINT16 *)(a) = (d))
#define SWAP16(y) ((((y)>>8)&0x00FF)+((((y)<<8)&0xFF00)))
#define SWAP32(y) ( (((y)>>24) & 0x000000FF) + \
		    (((y)>>8)  & 0x0000FF00) + \
		    (((y)<<8)  & 0x00FF0000) + \
		    (((y)<<24) & 0xFF000000) )

#ifdef USE_GENERATOR68K
#  ifdef WORDS_BIGENDIAN
#    define WRITE_WORD_ROM WRITE_WORD
#    define READ_WORD_ROM READ_WORD
#  else /* WORDS_BIGENDIAN */
#    define WRITE_WORD_ROM(a,d) (WRITE_WORD(a,SWAP16(d)))
#    define READ_WORD_ROM(a) (SWAP16(READ_WORD(a)))
#  endif
#else /* USE_GENERATOR68K */
#  define WRITE_WORD_ROM WRITE_WORD
#  define READ_WORD_ROM READ_WORD
#endif

typedef struct neo_mem {
    unsigned char *cpu;
    unsigned int cpu_size;
    unsigned char *ram;
    unsigned char *bios;
    unsigned char *ng_lo;
    unsigned char *sm1;
    unsigned int sm1_size;
    unsigned char *sfix_board;
    unsigned char *sfix_game;
    unsigned int sfix_size;
    unsigned char *sound1;
    unsigned int sound1_size;
    unsigned char *sound2;
    unsigned int sound2_size;
    unsigned char *gfx;
    unsigned int gfx_size;
    unsigned int nb_of_tiles;
    //tile **tile_in_cache;
    unsigned char video[0x20000];
    unsigned char *pal1, *pal2;
    unsigned char *pal_pc1, *pal_pc2;
    unsigned char sram[0x10000];
    unsigned int *pen_usage;
    unsigned char fix_board_usage[4096];
    unsigned char *fix_game_usage;
    unsigned char z80_ram[0x800];
    /* internal representation of key */
    Uint8 intern_p1, intern_p2, intern_coin, intern_start;
    /* crypted rom bankswitch system */
    Uint32 bksw_handler;
    Uint8 bksw_unscramble[6];
    Uint8 bksw_offset[64];
} neo_mem;

neo_mem memory;

/* video related */
extern int irq2enable, irq2start, irq2repeat, irq2control;
extern int lastirq2line;
extern int irq2repeat_limit;
int palno, vptr, high_tile, vhigh_tile, vvhigh_tile;
short modulo;
unsigned char *current_pal;
unsigned char *current_pal_dirty;
unsigned short *current_pc_pal;
unsigned char *current_fix;
unsigned char *fix_usage;

/* memory card */
extern unsigned char neo_memcard[0x1000];;

/* sram */
unsigned char sram_lock;
unsigned int sram_protection_hack;

/* Sound control */
unsigned char sound_code;
unsigned char pending_command;
unsigned char result_code;


/* 68k cpu Banking control */
extern int bankaddress;		/* current bank */
uint8 current_cpu_bank;
Uint16 z80_bank[4];

/* misc utility func */
void update_all_pal(void);
void dump_hardware_reg(void);

/* cpu 68k interface */
int cpu_68k_getcycle(void);
void cpu_68k_init(void);
void cpu_68k_reset(void);
int cpu_68k_run(Uint32 nb_cycle);
void cpu_68k_interrupt(int a);
void cpu_68k_bankswitch(unsigned int address);
void cpu_68k_disassemble(int pc, int nb_instr);
void cpu_68k_dumpreg(void);
int cpu_68k_run_step(void);
Uint32 cpu_68k_getpc(void);
void cpu_68k_fill_state(M68K_STATE *st);
void cpu_68k_set_state(M68K_STATE *st);
int cpu_68k_debuger(void (*execstep)(void),void (*dump)(void));


/* cpu z80 interface */
void cpu_z80_run(int nbcycle);
void cpu_z80_nmi(void);
void cpu_z80_raise_irq(int l);
void cpu_z80_lower_irq(void);
void cpu_z80_init(void);
void cpu_z80_switchbank(Uint8 bank, Uint16 PortNo);
Uint8 z80_port_read(Uint16 PortNo);
void z80_port_write(Uint16 PortNb, Uint8 Value);
void cpu_z80_set_state(Z80_STATE *st);
void cpu_z80_fill_state(Z80_STATE *st);

/* memory handler prototype */
void neogeo_sound_irq(int irq);



/* 68k fetching function */
uint8 mem68k_fetch_ram_byte(uint32 addr);
uint16 mem68k_fetch_ram_word(uint32 addr);
uint32 mem68k_fetch_ram_long(uint32 addr);
uint8 mem68k_fetch_invalid_byte(uint32 addr);
uint16 mem68k_fetch_invalid_word(uint32 addr);
uint32 mem68k_fetch_invalid_long(uint32 addr);
uint8 mem68k_fetch_cpu_bk_byte(uint32 addr);
uint16 mem68k_fetch_cpu_bk_word(uint32 addr);
uint32 mem68k_fetch_cpu_bk_long(uint32 addr);
uint8 mem68k_fetch_cpu_byte(uint32 addr);
uint16 mem68k_fetch_cpu_word(uint32 addr);
uint32 mem68k_fetch_cpu_long(uint32 addr);
uint8 mem68k_fetch_bios_byte(uint32 addr);
uint16 mem68k_fetch_bios_word(uint32 addr);
uint32 mem68k_fetch_bios_long(uint32 addr);
uint8 mem68k_fetch_sram_byte(uint32 addr);
uint16 mem68k_fetch_sram_word(uint32 addr);
uint32 mem68k_fetch_sram_long(uint32 addr);
uint8 mem68k_fetch_pal_byte(uint32 addr);
uint16 mem68k_fetch_pal_word(uint32 addr);
uint32 mem68k_fetch_pal_long(uint32 addr);
uint8 mem68k_fetch_video_byte(uint32 addr);
uint16 mem68k_fetch_video_word(uint32 addr);
uint32 mem68k_fetch_video_long(uint32 addr);
uint8 mem68k_fetch_ctl1_byte(uint32 addr);
uint16 mem68k_fetch_ctl1_word(uint32 addr);
uint32 mem68k_fetch_ctl1_long(uint32 addr);
uint8 mem68k_fetch_ctl2_byte(uint32 addr);
uint16 mem68k_fetch_ctl2_word(uint32 addr);
uint32 mem68k_fetch_ctl2_long(uint32 addr);
uint8 mem68k_fetch_ctl3_byte(uint32 addr);
uint16 mem68k_fetch_ctl3_word(uint32 addr);
uint32 mem68k_fetch_ctl3_long(uint32 addr);
uint8 mem68k_fetch_coin_byte(uint32 addr);
uint16 mem68k_fetch_coin_word(uint32 addr);
uint32 mem68k_fetch_coin_long(uint32 addr);
uint8 mem68k_fetch_memcrd_byte(uint32 addr);
uint16 mem68k_fetch_memcrd_word(uint32 addr);
uint32 mem68k_fetch_memcrd_long(uint32 addr);

/* 68k storring function */
void mem68k_store_invalid_byte(uint32 addr, uint8 data);
void mem68k_store_invalid_word(uint32 addr, uint16 data);
void mem68k_store_invalid_long(uint32 addr, uint32 data);
void mem68k_store_ram_byte(uint32 addr, uint8 data);
void mem68k_store_ram_word(uint32 addr, uint16 data);
void mem68k_store_ram_long(uint32 addr, uint32 data);
void mem68k_store_bk_switch_byte(uint32 addr, uint8 data);
void mem68k_store_bk_switch_word(uint32 addr, uint16 data);
void mem68k_store_bk_switch_long(uint32 addr, uint32 data);
void mem68k_store_sram_byte(uint32 addr, uint8 data);
void mem68k_store_sram_word(uint32 addr, uint16 data);
void mem68k_store_sram_long(uint32 addr, uint32 data);
void mem68k_store_pal_byte(uint32 addr, uint8 data);
void mem68k_store_pal_word(uint32 addr, uint16 data);
void mem68k_store_pal_long(uint32 addr, uint32 data);
void mem68k_store_video_byte(uint32 addr, uint8 data);
void mem68k_store_video_word(uint32 addr, uint16 data);
void mem68k_store_video_long(uint32 addr, uint32 data);
void mem68k_store_pd4990_byte(uint32 addr, uint8 data);
void mem68k_store_pd4990_word(uint32 addr, uint16 data);
void mem68k_store_pd4990_long(uint32 addr, uint32 data);
void mem68k_store_z80_byte(uint32 addr, uint8 data);
void mem68k_store_z80_word(uint32 addr, uint16 data);
void mem68k_store_z80_long(uint32 addr, uint32 data);
void mem68k_store_setting_byte(uint32 addr, uint8 data);
void mem68k_store_setting_word(uint32 addr, uint16 data);
void mem68k_store_setting_long(uint32 addr, uint32 data);
void mem68k_store_memcrd_byte(uint32 addr, uint8 data);
void mem68k_store_memcrd_word(uint32 addr, uint16 data);
void mem68k_store_memcrd_long(uint32 addr, uint32 data);

#endif
