/* adapted from the Serial Programming HOWTO */

#include <termios.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/signal.h>
#include <sys/types.h>
     
#define BAUDRATE B9600
#define MODEMDEVICE "/dev/ttyS0"
#define _POSIX_SOURCE 1 /* POSIX compliant source */
#define FALSE 0
#define TRUE 1
  
volatile int STOP=FALSE;
  
void signal_handler_IO (int status);   /* definition of signal handler */
int wait_flag=TRUE;		       /* TRUE while no signal received */
int fd;
FILE *out;

int send_packet ( const unsigned char *header, const unsigned char *s ) {
	static int calls = 0;
	unsigned char *packet, *t;
	int i, len;
	unsigned char buf[1024], eot = 4;

	if ( header ) {
		if ( write( fd, header, strlen(header)) == -1 )
			perror("Write:");
	}

	if ( !s ) {
//		write( fd, &eot, 1 );
		return 0;
	}

	len = strlen(s);
	packet = (unsigned char *)malloc(len+3);

	packet[0] = (unsigned char)((len & 0xFF00)>>8);
	packet[1] = (unsigned char)(len & 0x00FF);
	memcpy( packet+2, s, len );
	
	/* checksum */
	packet[len+2] = 0;
	for ( (const unsigned char *)t = s; *t != '\0'; t++ )
		packet[len+2] += *t;

	/* send the packet */
	write( fd, packet, strlen(packet));
	write( fd, &eot, 1 );
	free( packet );

	usleep(1000000);
	if ( (len = read(fd,buf,1024)) == -1 ) {
		perror( NULL);
		return;
	}
	for ( i = 0; i < len; i++ )  
		if ( buf[i] == 6 ) {
			fprintf( stderr, "ack");
			break;
		}
	return 0;
}

char *get_packet ( void ) {
	int res;
	unsigned int size, i;
	unsigned char buf[1024], c = 0;

	usleep(1000000);
	if ( (res = read(fd,buf,1024)) == -1 ) {
		perror( NULL);
		return;
	}

	if ( res > 1023 )
		fprintf( stderr, "big");
	size = (buf[0]<<8) + buf[1];
	fprintf( stderr, "%d\n", size );
	for ( i = 2; i < size+2; i++ ) {
		c += buf[i];
		putc( buf[i], out );
	}
	if ( c != buf[i] )
		fprintf( stderr, "par");
	return NULL;
}

int main( ) { 
	int c;
	struct termios oldtio,newtio;
	struct sigaction saio;  	 /* definition of signal action */
	char ack = 6, buffer[2][255];
	
	out = fopen( "saida.txt", "w");
	
	/* open the device to be non-blocking (read will return immediatly) */
	fd = open(MODEMDEVICE, O_RDWR | O_NOCTTY | O_NONBLOCK );
	if (fd <0) {perror(MODEMDEVICE); exit(-1); }
	
	tcgetattr(fd,&oldtio); /* save current port settings */
	/* set new port settings for canonical input processing */
	newtio.c_cflag = BAUDRATE | CS8 | CLOCAL | CREAD;
	newtio.c_iflag = IGNPAR;
	newtio.c_oflag = 0;
	newtio.c_lflag = ~(ICANON | ECHO | ECHOE |ISIG);
	newtio.c_cc[VMIN]=1;
	newtio.c_cc[VTIME]=8;
	tcflush(fd, TCIOFLUSH);
	tcsetattr(fd,TCSANOW,&newtio);
	
	/* loop while waiting for input. normally we would do something
	   useful here */
	while (STOP==FALSE) {
		printf("Header: " );
		gets(buffer[0]);
		if ( buffer[0][0] == '\0' || buffer[0][0] == 'Q' ) {
			STOP = TRUE;
			if ( buffer[0][0] == '\0' )
				break;
		}
		else if ( buffer[0][0] == 'A') {
			write( fd, &ack, 1 );
			continue;
		}

		printf("Packet: " );
		gets(buffer[1]);
		send_packet(buffer[0], ( buffer[1][0] == '\0' ? NULL : buffer[1]) );
		get_packet();

#ifdef war324
		/* after receiving SIGIO, wait_flag = FALSE, input is available
		and can be read */
		if (wait_flag==FALSE) {
			res = read(fd,buf,255);
			buf[res]=0;
			fwrite(buf, res, 1, out);
			wait_flag = TRUE;      /* wait for new input */
		}
#endif
	}
	fclose(out);
	/* restore old port settings */
	tcsetattr(fd,TCSANOW,&oldtio);
}
