/* serial tests for HPTalx 2.0 */
#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>


FILE *serial, *out;

int send_packet ( const unsigned char *header, const unsigned char *s ) {
	static int calls = 0;
	unsigned char *packet, *t;
	int i, len;

	if ( header ) {
		for ( i = 0; i < strlen(header); i++ )
			fputc( header[i], serial);
		fflush( serial );
	}

	if ( !s ) 
		return 0;

	len = strlen(s);
	packet = (unsigned char *)malloc(len+4);

	packet[0] = (unsigned char)((len & 0xFF00)>>8);
	packet[1] = (unsigned char)(len & 0x00FF);
	memcpy( packet+2, s, len );
	
	/* checksum */
	packet[len+2] = 0;
	for ( (const unsigned char *)t = s; *t != '\0'; t++ )
		packet[len+2] += *t;
	packet[len+3] = '\0'; 

	/* send the packet */
	for ( i = 0; i < len+4; i++ )
		fputc( packet[i], serial);
	fflush(serial);
	free( packet );

#ifdef notusethiscode
	/* get response \006 */
	FD_ZERO( &set );
	FD_SET( fileno(serial), &set );
	tv.tv_sec = 0;
	tv.tv_usec = 200000;
	
	switch ( select (FD_SETSIZE, &set, NULL, NULL, &tv) ) {
		case -1:
			/* error. send again */
		case 0:
			/* timeout. Resend the packet. */
			if ( calls < 5) {
				calls++;
				if ( send_packet( header, s ) == -1 )
					return -1;
			}
			else if ( calls >= 5 ) {
				set_status("Packet error, 5 resents.");
				calls = 0;
				return -1;
			}
			break;
		case 1:
			if ( fgetc( serial ) != 6 )
				set_status("OK byte error, ignoring.");
			break;
	}
#endif
	return 0;
}

unsigned char *get_packet ( int *size ) {
	unsigned char *data, *t, c = 0;
	int i;

	*size = (fgetc( serial )&0xFF)<<8;
	*size += (fgetc( serial )&0xFF);
	i = *size;

	data = (unsigned char *) malloc (i+1);

	t = data;
	for ( ; i > 0; i-- )
		c += *t++ = fgetc( serial );
	*t = '\0';

	if ( c != (unsigned char) fgetc( serial ) )  {
		free(data);
		return NULL;
	}
	fputc( '\006', serial );
	return data;
}

int main () {
	int c, i;
	int filed[2];
	char str[] = "STARTEQW", ver[] = "VERSION", t, buffer[2][256];
	struct timeval tv;
	fd_set set;
	
	system("stty 1:0:8bd:0:3:1c:7f:15:4:5:1:0:11:13:1a:0:12:f:17:16:0:0:73:0:0:0:0:0:0:0:0:0:0:0:0:0 < /dev/ttyS0 > /dev/ttyS0");
	
	if ((serial = fopen("/dev/ttyS0", "r+")) == 0) {
		char *s;
		perror(s);
		fprintf(stderr, "pau: %s\n", s );
		exit(1);
	} 

	/* Quit */
#ifdef QUIT
	fputc('Q', serial);
#endif

	/* version */
#define VERSION
#ifdef VERSION
	fputc('V', serial);
	fflush(serial);
	c = 0;
	c = (fgetc( serial )&0xFF)<<8;
	c += (fgetc( serial )&0xFF);
	fprintf(stderr, "c:%d\n", c);
	while ( c > 0 ) {
		i = fgetc( serial );
		putchar( i );
		c--;
	}
	fgetc( serial );
#endif

#ifdef XMIT
	fputc('E', serial);
	fputc('\000', serial);
	fputc('\004', serial);
	fprintf(serial, "XMIT");
	t = (unsigned char)'X'+'M'+'I'+'T';
	fputc(t, serial );
	fflush(serial);
	fgetc(serial); // acknowledge
	while ( select ) {
		i = fgetc( serial );
		putchar( i );
		c--;
	}
#endif

#ifdef hpver
	fputc('E', serial);
	fputc('\0', serial);
	fputc(strlen(ver), serial);
	fprintf(serial, ver);
	t = 0;
	for ( i = 0; i < strlen(ver); i++ )
		t += ver[i];
	fputc(t, serial);
	fflush(serial);
	out = fopen("saida.txt", "w");

	c = 0;
	c = (fgetc( serial )&0xFF)<<8;
	c += (fgetc( serial )&0xFF);
	fprintf(stderr, "c:%d\n", c);
	while ( c > 0 ) {
		i = fgetc( serial );
		fputc( i, out );
		c--;
	}
	fgetc( serial );
	fclose(out);
#endif


#ifdef list
	out = fopen("saida.txt", "wb");
	fputc('L', serial);
	fflush(serial);

	c = 0;
	c = (fgetc( serial )&0xFF)<<8;
	i = c >>8;
	c += (fgetc( serial )&0xFF);
	i += (c&0xFF)<<8;
	fprintf(stderr, "c:%d ; i: %d\n", c, i);
	while ( c > 0 ) {
		i = fgetc( serial );
		fputc( i, out );
		c--;
	}
	fgetc( serial );
	fputc( '\006', out );
	fclose(out);
#endif

#ifdef getf
/* 	fputc('G', serial);
	fputc('\0', serial);
	fputc(8, serial);
	fprintf(serial, str);
	t = 0;
	for ( i = 0; i < 8; i++ )
		t += str[i];
	fputc(t, serial);
	fflush(serial);
 	if ( (i = fork ()) == -1 ) {
		fprintf(stderr, "erro no fork");
		exit(2);
	}
	else if ( i == 0 ) { */

		if ( (filed[0] = open( "/dev/ttyS0", O_RDONLY )) < 0 ||
			(filed[1] = open( "/dev/ttyS0", O_WRONLY )) < 0 ) {
			fprintf(stderr, "gato\n");
			exit(3);
		}

		close(STDIN_FILENO);
		dup(filed[0]);
		close(filed[0]);
		close(STDOUT_FILENO);
		dup(filed[1]);
		close(filed[1]);

		setvbuf( stdout, NULL, _IONBF, 0 );
		setvbuf( stdin, NULL, _IONBF, 0 );

		putchar('G' );
		putchar('\0');
		putchar(8 );
		printf(str);
		t = 0;
		for ( i = 0; i < 8; i++ )
			t += str[i];
		putchar(t);

		if ( execl("/usr/local/bin/lrx", "lrx", "-a", "STARTEQW", NULL) == -1 ) {
			char *s;
			perror(s);
			fprintf(stderr, s); 
		}
//		system("lrx STARTEQW < /dev/ttyS0 > /dev/ttyS0");
#endif

#ifdef terminal
	out = fopen("saida.txt", "w");
	if ( fcntl( fileno(serial), F_SETFL, O_NONBLOCK ) == -1 ) {
		return 1;
	}

	do {
		printf("Header: " );
		gets(buffer[0]);
		if ( buffer[0][0] == '\0')
			break;
		else if ( buffer[0][0] == 'A') {
			fputc( '\006', serial );
			continue;
		}

		printf("Packet: " );
		gets(buffer[1]);
		send_packet(buffer[0], ( buffer[1][0] == '\0' ? NULL : buffer[1]) );

		FD_ZERO( &set );
		FD_SET( fileno(serial), &set );

/*		do { 		
		  tv.tv_sec = 0;
		  tv.tv_usec = 400000;
		  i = select (FD_SETSIZE, &set, NULL, NULL, &tv);

 		  switch ( i ) {
			case -1:
				fprintf(stderr, "Error");
			case 0:
				break;
			case 1:
				continue;
		  }
		} while ( i != 0 );*/
				sleep(1);
//		while ( read( fileno(serial), &c, 1 ) != -1 ) 
		while ( i = fgetc(serial) != EOF)
			fputc( i, out );

		perror(NULL);
		fprintf(out, "\n");
		
	} while(buffer[0][0] != '\0' );
	fclose(out);
#endif
	fclose(serial);


}
