\name{scatmat.ggobi}
\alias{scatmat.ggobi}
\title{Create a ggobi scatterplot matrix display}
\description{
Creates a new window under the management of the specified ggobi
instance containing a grid of all pairwise scatterplots of the
variables specified in the \code{x} and \code{y} arguments.  The
display is similar to that produced by the \code{\link{pairs}} 
function, but is interactive and dynamic, allowing linking
across the other plots within the ggobi instance.
Greater control of which pairs of variables are plotted
together can be obtained by specifying both \code{x} and
\code{y}.
}
\usage{
scatmat.ggobi(x, y, .data=1, .gobi=getDefaultGGobi())
}
\arguments{
  \item{x}{the names or indices of the variables to plot}
  \item{y}{if specified,  this should have the same length
as \code{x} and then the pair \code{(x[i], y[i])}
 are plotted.
}
  \item{.data}{}
  \item{.gobi}{the ggobi instance in which the plot is created
and the variable identifiers resolved.}
}

\value{
 An object of class \code{ggobiDisplay}.
This is an opaque type whose contents are
to be interpreted by C code and other S functions
only.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{
\code{\link{scatterplot.ggobi}}
\code{\link{parcoords.ggobi}}
}

\examples{
  g <- ggobi(system.file("data", "flea.xml", package="Rggobi"), args="-noinit")
  scatmat.ggobi(1:3)
  scatmat.ggobi(c("tars1", "tars2", "aede1"))
}
\concept{visualization}

\keyword{iplot}
\keyword{dynamic}
