#ifndef S9X_PREFS_H
#define S9X_PREFS_H


#include <string>
#include "defines.h"
#include "frend.h"
#include "skins.h"
#include "misc.h"


class s9x_Interface;

class s9x_Prefs: public fr_Window, public s9x_OptionManager, private fr_Listener
{
 private:
  fr_Element*		Banner;
  fr_Notebook		Notebook;
  fr_Notepage		PgAppear, PgPaths, PgReset, PgPower;
  fr_RadioGroup		VideoDriver;
  fr_RadioButton	UseX11, UseGL, UseGlide;
  fr_Checkbox		Start2Prof, Start2Last;
  fr_Checkbox		Reset2Prof, Reset2Last, Reset2Args;
  fr_NumEntry		Snes9xVersion;
  fr_File		ROMdir, snes9xDir, *SnapDir;
  fr_Button		BtnApply, BtnSave, BtnClose, BtnOK;
  s9x_File		PrefsFile;
  s9x_SkinSelector	SkinSelector;
  void			CreatePgAppear();
  void			CreatePgPaths();
  void			CreatePgReset();
  void			CreatePgPower();
  void			EventOccurred(fr_Event*e);
 public:
  s9x_Prefs(fr_Element*parent);
  virtual ~s9x_Prefs();
  void			SetToDefaults();
  void			SiftArgs(fr_ArgList& L);
  std::string		GetROMdir();
  std::string		GetSnapDir();
  std::string		GetSnes9xDir();
  void			Load();
  void			Save();
  void			Apply();
  void			ApplySkin(s9x_Skin*S);
  bool			ResetToProfile();
  bool			ResetToArgs();
  bool			ResetToLast();
  bool			StartToProfile();
  bool			StartToLast();
};
#endif
