/* Stars -- Displays a Map of the Night Sky
    Copyright (C) September 22, 2002  Walter Brisken

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA*/

#ifndef __COORDUTILS__
#define __COORDUTILS__

#include <glib.h>

#define PI_180  0.0174532925
#define PI_12   0.261799387799
#define PI      3.14159265359
#define PI2     6.28318530718
#define PI_2    1.5707963268
#define MAS_RAD	206264806.247

double text2double(const gchar *str);
double text3double(const gchar *str);
double formattedtext2double(const gchar *str, const gchar *format);
void double2text(double num, char *str, gchar sep);
gchar *g_double2text(double num, gchar sep);
gint uranopage(double ra, double dec);

#endif
