#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include "../src/object.h"

#define PI 3.14159265358979

FILE *out;
int num=0;


/*      index   From            To
        0       RA-Dec          Galactic
        1       Galactic        RA-DEC
        2       RA-Dec          Ecliptic
        3       Ecliptic        RA-Dec
        4       Ecliptic        Galactic
        5       Galactic        Ecliptic
*/

double psi[6]    = {0.57477043300, 4.9368292465, 0.00000000000,
                    0.0000000000, 0.11142137093, 4.71279419371};
double stheta[6] = {0.88998808748, -0.88998808748, 0.39777715593,
                    -0.39777715593, 0.86766622025,-0.86766622025};
double ctheta[6] = {0.45598377618, 0.45598377618, 0.91748206207,
                    0.91748206207, 0.49714719172, 0.49714719172};
double phi[6]    = {4.9368292465, 0.57477043300, 0.0000000000,
                    0.00000000000, 4.71279419371, 0.11142137093};

void convert(int I, double ai, double bi, double *ao, double *bo)
{
	double a, b, cb, sb, cbsa;

	a  = ai - phi[I];
        b = bi;
        sb = sin(b);
        cb = cos(b);
        cbsa = cb * sin(a);
        b  = -stheta[I] * cbsa + ctheta[I] * sb;
        *bo    = asin(b);
        a =  atan2( ctheta[I] * cbsa + stheta[I] * sb, cb * cos(a) );
        *ao = a+psi[I];
        while(*ao >= 2.0*PI) *ao -= 2.0*PI;
        while(*ao < 0.0) *ao += 2.0*PI;
}

void writeline(double ra, double dec, int t, int linetype, unsigned char e)
{
	struct object obj;
	double x, y, z;

	x = cos(ra)*cos(dec);
	y = -sin(ra)*cos(dec);
	z = sin(dec);

	obj.x = (long)(x*(double)(1<<30));
	obj.y = (long)(y*(double)(1<<30));
	obj.z = (long)(z*(double)(1<<30));
	obj.type=t;
	obj.icon=linetype;
	obj.mask = 0x0F;
	obj.mag = e;

	fwrite(&obj, 1, sizeof(obj), out);
	num++;
}

void writex(char *str, double ra, double dec)
{
	double x, y, z;
	
	x = cos(ra)*cos(dec);
	y = -sin(ra)*cos(dec);
	z = sin(dec);

	printf("%s Xaxis = %f, %f, %f\n",
		str, x, y, z);
}

void writey(char *str, double ra, double dec)
{
	double x, y, z;
	
	x = cos(ra)*cos(dec);
	y = -sin(ra)*cos(dec);
	z = sin(dec);

	printf("%s Yaxis = %f, %f, %f\n",
		str, x, y, z);
}

void writepoles(char *str, double ra, double dec)
{
	double x, y, z;
	
	x = cos(ra)*cos(dec);
	y = -sin(ra)*cos(dec);
	z = sin(dec);

	printf("%s Poles : N = %f, %f, %f, S = %f, %f, %f\n",
		str, x, y, z, -x, -y, -z);
}

int main()
{
	int d, r, lt, l, m;
	double dec, ra;
	double a, b;

	out=fopen("equcoords.cat", "w");

	for(r = 0; r <= 96; r++)
        {
		ra = (double)r*PI/48.0;
		if(r % 4 == 0) lt = 0; else lt = 1;
		if(r % 2 != 0) m = 60;
		else if(r % 4 != 0) m = 75;
		else if(r % 12 != 0) m = 80;
		else if(r % 24 != 0) m = 85;
		else m = 90;
		for(d = m; d >= -m; d-=5)
		{
			if(d == m) l = 255; else l = lt;
			dec = (double)d*PI/180.0;
			if(r == 0 && d == 90) writepoles("EQU", ra, dec);
			if(r == 0 && d == 0) writex("EQU", ra, dec);
			if(r == 72 && d == 0) writey("EQU", ra, dec);
			writeline(ra, dec, 193, l, lt);
		}
	}


	for(d = 85; d >= -85; d-=5)
	{
		dec = (double)d*PI/180.0;
		if(d%3 == 0) lt = 0; else lt = 1;
		for(r = 0; r <= 96; r++)
		{
			if(r == 0) l = 255; else l = lt;
			ra = (double)r*PI/48.0;
			writeline(ra, dec, 193, l, lt);
		}
			
	}

	fclose(out);
	printf("equcoords.cat: %d objects\n", num);

	num = 0;

	out=fopen("galcoords.cat", "w");

	for(r = 0; r <= 96; r++)
        {
		ra = (double)r*PI/48.0;
		if(r % 4 == 0) lt = 0; else lt = 1;
		if(r % 2 != 0) m = 60;
		else if(r % 4 != 0) m = 75;
		else if(r % 12 != 0) m = 80;
		else if(r % 24 != 0) m = 85;
		else m = 90;
		for(d = m; d >= -m; d-=5)
		{
			if(d == m) l = 255; else l = lt;
			dec = (double)d*PI/180.0;
			convert(1, ra, dec, &a, &b);
			if(r == 0 && d == 90) writepoles("GAL", a, b);
			writeline(a, b, 194, l, lt);
			if(r == 0 && d == 0) writex("GAL", a, b);
			if(r == 72 && d == 0) writey("GAL", a, b);
		}
	}


	for(d = 85; d >= -85; d-=5)
	{
		dec = (double)d*PI/180.0;
		if(d%3 == 0) lt = 0; else lt = 1;
		for(r = 0; r <= 96; r++)
		{
			if(r == 0) l = 255; else l = lt;
			ra = (double)r*PI/48.0;
			convert(1, ra, dec, &a, &b);
			writeline(a, b, 194, l, lt);
		}
			
	}

	fclose(out);
	printf("galcoords.cat: %d objects\n", num);

	num = 0;

	out=fopen("eclcoords.cat", "w");

	for(r = 0; r <= 96; r++)
        {
		ra = (double)r*PI/48.0;
		if(r % 4 == 0) lt = 0; else lt = 1;
		if(r % 2 != 0) m = 60;
		else if(r % 4 != 0) m = 75;
		else if(r % 12 != 0) m = 80;
		else if(r % 24 != 0) m = 85;
		else m = 90;
		for(d = m; d >= -m; d-=5)
		{
			if(d == m) l = 255; else l = lt;
			dec = (double)d*PI/180.0;
			convert(3, ra, dec, &a, &b);
			if(r == 0 && d == 90) writepoles("ECL", a, b);
			if(r == 0 && d == 0) writex("ECL", a, b);
			if(r == 72 && d == 0) writey("ECL", a, b);
			writeline(a, b, 195, l, lt);
		}
	}


	for(d = 85; d >= -85; d-=5)
	{
		dec = (double)d*PI/180.0;
		if(d%3 == 0) lt = 0; else lt = 1;
		for(r = 0; r <= 96; r++)
		{
			if(r == 0) l = 255; else l = lt;
			ra = (double)r*PI/48.0;
			convert(3, ra, dec, &a, &b);
			writeline(a, b, 195, l, lt);
		}
			
	}

	fclose(out);
	printf("eclcoords.cat: %d objects\n", num);

	return 0;
}
