//
// Receiver_i.cpp,v 1.1 2002/04/04 19:04:50 bala Exp
//
#include "Receiver_i.h"

ACE_RCSID(MT_BiDir,
          Receiver_i,
          "Receiver_i.cpp,v 1.1 2002/04/04 19:04:50 bala Exp")

Receiver_i::Receiver_i (void)
  :  message_count_ (0)
  ,  byte_count_ (0)
{
}


void
Receiver_i::receive_payload (const Receiver::Payload &payload
                        ACE_ENV_ARG_DECL_NOT_USED)
  ACE_THROW_SPEC ((CORBA::SystemException))
{
  ACE_GUARD (ACE_SYNCH_MUTEX, ace_mon, this->mutex_);
  this->message_count_++;
  this->byte_count_ += payload.length ();
}

CORBA::Long
Receiver_i::get_event_count (void)
{
  ACE_GUARD_RETURN (ACE_SYNCH_MUTEX, ace_mon, this->mutex_, 0);
  return this->message_count_;
}
