"""
adesklets initializer module
"""

from sys import _getframe
import re

from error_handler import *
from singleton import _Singleton, _States
from children_handler import _Children_handler
from communicator import _Communicator
from commands_handler import _Commands_handler
from which import Which

class _Initializer(_Singleton, _States):
    """
    Initialize the whole modules global instances.
    """
    def __init__(self, debug=False):
        """
        Initialize the whole adesklets thing. Set debug to True
        to avoid problem raising execeptions.
        """
        _Singleton.__init__(self,'_initializer')
        _States.__init__(self)
        self.hdlrs = [ _Children_handler() ]
        # Determine stack lowest frame
        i=0
        while 1:
            try:
                _getframe(i)
            except ValueError:
                break
            i+=1
        i-=1;
        # Use it to find canonical applet name
        if _getframe(i).f_locals.has_key('__file__'):
           script_name = Which(_getframe(i).f_locals['__file__']).run()
           if script_name is None:
               script_name=':'
        else:
            script_name=':'
            
        self._States__shared_state.setdefault('script_name',script_name)
        comm=_Communicator('adesklets',[script_name])
        self._States__shared_state.setdefault('communicator', comm)

        re_event=re.compile('^event:')
        re_event_ready=re.compile('^event: ready!$')
        while 1:
            # Loop until the ready event in sent.
            # Raise initialization exception error on first problem.
            event=comm.err(.1)
            if event:
                if re_event.match(event):
                    if re_event_ready.match(event):
                        break
                else:
                    if not debug:
                        raise ADESKLETSError(3,event)
                    else:
                        print event
        self._States__shared_state.setdefault('commands_handler',
                                              _Commands_handler())
    def __del__(self):
        _States.__del__(self)
        _Singleton.__del__(self)
