//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

//Systemwide includes
#include <qwidget.h>
#include <qapplication.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qpixmap.h>

//Projectwide includes
#include "guiTools.h"

#define SUBALBUM_TEXT_LENGTH 35
#define PHOTO_TEXT_LENGTH  35

//==============================================
void centerWindow(QWidget* window)
{
  //---------------------------------------------------------
  //get size and location of application window
  QRect appRec = qApp->mainWidget()->frameGeometry();
  QRect windowRec = window->frameGeometry();
  //---------------------------------------------------------
  //if new window smaller then application window then center window
  //over application window, otherwise align left/top with application window
  int x, y;

  //horizontal alignment
  if(windowRec.width() < appRec.width())
  { x = appRec.x() + ((appRec.width() - windowRec.width())/2); }
  else
  { x = appRec.x(); }

  //vertical alignment
  if(windowRec.height() < appRec.height())
  { y = appRec.y() + ((appRec.height() - windowRec.height())/2); }
  else
  { y = appRec.y(); }
  //---------------------------------------------------------
  //ensure window is not off screen, favor top/left sides of window is bigger than screen!
  QRect screen = QApplication::desktop()->availableGeometry();

  //right
  if(x + windowRec.width() > screen.width() )
    x = screen.width() - windowRec.width();

  //left
  if(x < 0)
    x = 0;

  //bottom
  if(y + windowRec.height() > screen.height() )
    y = screen.height() - windowRec.height();

  //top
  if(y < 0)
    y = 0;
  //---------------------------------------------------------
  //place window
  window->move( QPoint( x, y) );
}
//==============================================
QString clipText(QString string, int lines, int lineWidth)
{
  if(lineWidth == 0)
  {
//    cout << "ERROR: given 0 width when clipping: " << string << endl;
    return "";
  }

  QString result = "";
  QString building = "";
  QFontMetrics fm( qApp->font() );

  //decrement characters off head of string for each line
  while(string.length() > 0 && lines > 0)
  {
    bool spaceFound = false;
    QString line = "";

    //while there are character to be popped up
    while(string.length() > 0)
    {
      //if we can afford to add this character, add it to the building string
      //then update the character found, and space found strings
      if(fm.width( QString(line + building + string.at(0) ) )  < lineWidth )
      {
        building = building + string.at(0);

        //found a space, add this space and all built up words to the text for this line, no need
        //to wrap what has been found so far
        if(string.at(0) == ' ') // QChar::Separator_Space)
        {
          line = line + building;
          building = "";
          spaceFound = true;
          string = string.remove(0, 1);
          continue;
        }

        string = string.remove(0, 1);
        if(string.length() == 0)
        {
          line = line + building;
          building = "";
        }

      }
      //uh oh, can't add this character? move to next line
      else
      {
        //if no spaces found up to this point, suck up character so far, we're breaking on this one
        if(!spaceFound || lines == 1)
        {
          if(lines == 1)
            building = building + string;

          //if this is the last line then make sure we have enough space for the ...
          line = line + building;
          if(fm.width( line ) >  lineWidth )
          {
            while( fm.width(line + "...") > lineWidth )
            {
              line.truncate( line.length() - 1);
            }
            line = line + "...";
          }
          building = "";
        }
        break;
      }
    }

    //move on to next line
    result = result + line;
    line = "";
    lines--;
  }

  return result;
}
//==============================================
QString clipPhotoText(const QString in)
{
  if(in.length() > PHOTO_TEXT_LENGTH)
  {
    QString res = in;
    res.truncate(PHOTO_TEXT_LENGTH-3); res = res + "...";
    return res;
  }
  else
    return in;
}
//==============================================
