//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

//Systemwide includes
#include <qfile.h>
#include <qtextstream.h>
#include <qstringlist.h>
#include <qnamespace.h>
#include <qkeysequence.h>

//Projectwide includes
#include "manipulating.h"
#include "helpWindow.h"
#include "../../config.h"

//==============================================
QString Manipulating::filename()
{
  return QString("%1/manipulating.html").arg(TEMP_DIR);
}
//==============================================
void Manipulating::generateHTML(QTextStream::Encoding type, QString charSet)
{
  //create/open html file
  QFile file( filename() );
  if(file.open(IO_WriteOnly))
  {
    //-----
    QTextStream stream;
    stream.setEncoding( type );
    stream.setDevice( &file );
    //-----
    stream << "<html><head>\n";
    stream << "<meta http-equiv='Content-Type' content='text/html; charset=" << charSet << "'>\n";
    stream << "</head><body>\n";
    stream << "<table cellpadding='4'><tr>\n";
    stream << "<td><img src='" << IMAGE_PATH << "helpImages/asHelpLogoSmall.png'></td>\n";
    stream << "<td valign='middle'><font face='Arial, sans-serif' size='+3'>";
    stream << HelpWindow::tr("Manipulations") << "</font></td>\n";
    stream << "</tr></table>\n";
    stream << "<font face='Arial, sans-serif'>\n";
    
    stream << "<table cellspacing='10' cellpadding='0'><tr><td>\n";

    stream << "<table width='100%' cellpadding='4' cellspacing='0'><tr><td bgcolor='lightgray'>\n";
    stream << "<font size='+1'><b>" << HelpWindow::tr("Stylize your Photos:") << "</b></font>\n";
    stream << "</td></tr></table>\n";

    stream << "<table cellpadding='4' cellspacing='0'><tr><td valign='middle'>\n";
    stream << "<p align='justify'>\n";
    stream << HelpWindow::tr("If you want to stylize your photo, try applying one of the many manipulations. Manipulation controls are located at the lower right of the photo editor. A preview of the selected manipulation is shown to the right of the manipulation controls. Create your own effects by applying several manipulations.") << "\n";
    stream << "</td><td valign='middle'>\n";
    stream << "<img src='" << IMAGE_PATH << "helpImages/manipulateControls.png'>\n";
    stream << "</td></tr></table>\n";
    
    stream << "</td></tr><tr><td>\n";
    
    stream << "<table cellpadding='4' cellspacing='0'><tr><td valign='middle'>\n";
    stream << "<img src='" << IMAGE_PATH << "helpImages/manipulations.png'>\n";
    stream << "</td><td valign='middle'>\n";
    stream << "<p align='justify'>\n";
    stream << HelpWindow::tr("Album Shaper currently supports the following manipulations pictured from left to right: black and white, sepia coloring, invert colors, color preserving emboss, and an oil painting effect.") << "\n";
    stream << "</td></tr></table>\n";
    stream << "</font>\n";
    stream << "</body></html>\n";
    file.close();
  }
}
//==============================================
