# This module is part of Alicq package. It is used for saving values of 
# properties changed by user when working with Alicq
#
# Author: Ihar Viarheichyk

namespace eval meta {
	array set path [list type map property Global:Saver|paths\
		description "Paths to save objects to"\
		default [list * $::RCFILE]]
}
handler ConfigLoaded onConfig {args} {
	foreach x [namespace children ::modules] { CheckMeta $x }
	handler ModuleLoaded onLoad {ns args} { CheckMeta ::modules::$ns }
	foreach x [select] {CheckForSave $x}
	hook New:* [nc CheckForSave]
	hook New:* [nc ObjectNew]
}

handler exit onExit {args} {
	variable saved
	variable modified
	foreach x [metainfo module] {
		if {![info exists ${x}(save)] ||
		     [set ${x}(save)]!="exit" } continue
		set var [meta2var $x]
		if {![info exists saved($var)]||[set $var]!=$saved($var)} { 
			Save $var
		}
	}
	# Save modified objects
	foreach {uid val} [array get modified] { if {$val} {SaveObject $uid} }
}

proc CheckForSave {uid} {
	trace variable [ref $uid] w [nc ObjectChanged $uid]
	trace variable [ref $uid] u [nc ObjectDeleted $uid]
}

variable modified 
proc ObjectChanged {uid ref field args} {
	variable modified
	set x [metainfo object $uid $field]
	if {$x=="" || ![info exists ${x}(save)]} return 
	switch -- [set ${x}(save)] {
		exit {  set modified($uid) 1 }
		change {
			if {[info exists ${x}(default)] &&
			    [set ${x}(default)]==[set ${ref}($field)] ||
			    ![info exists ${x}(default)] &&
			    [set ${ref}($field)]==""} return 
			delayed [nc SaveObject $uid]
		}
	}
}

proc ObjectDeleted {uid ref x args} { 
	if {$x==""} { SaveObject $uid 1 } else { ObjectChanged $uid $ref $x}
}
proc ObjectNew {uid args} { SaveObject $uid }

proc ObjectKey {uid} { 
	switch -glob $uid {
		Contact:ICQ:* - Group:common:* {
			foreach {type _ uin} [split $uid :] break
			return "^\\s*${type}\\s+${uin}\\s"
		}
		default { return "^\\s*[string map {: {\s+}} $uid]\\s" }
	}
}

proc ObjectCommand {uid} {
	switch -glob $uid {
		Contact:ICQ:* - Group:common:* {return [ContactCommand $uid]}
	}
	set list [list]
	foreach {key val} [array get [ref $uid]] {
		if {[set var [metainfo object $uid $key]]==""} continue
		upvar #0 $var meta
		if {[info exists meta(default)] && $meta(default)!=$val ||
		    ![info exists meta(default)] && $val!=""} { 
		    	lappend list $key $val
		}
	}
	concat [split $uid :] [list $list]
}

proc SaveObject {uid {del 0}} {
	variable path
	set file ""
	foreach {key file} $path { if {[string match $key $uid]} break }
	if {$file==""} return
	set str [expr {$del?[nil]:[ObjectCommand $uid]}]
	::Save $file [ObjectKey $uid] $str 
	variable modified
	set modified($uid) 0
}

proc ContactCommand {uid} {
	foreach {type _ uin} [split $uid :] break
	foreach {Alias Groups lst} [list $uin [list] [list]] break
	foreach {field val} [array get [ref $uid]] {
		switch $field {
			Alias - Groups { set $field $val }
			default {
				set var [metainfo object $uid $field]
				if {![info exists ${var}(save)]} continue
				if {[info exists ${var}(default)] &&
				    [set ${var}(default)]==$val} continue
				lappend lst ${field}=${val}
			}
		}
	}
	list $type $uin $Alias $Groups $lst
}

proc CheckMeta {ns} {
	variable saved
	foreach x [metainfo module ::${ns}] {
		if {![info exists ${x}(save)]} continue
		set name [meta2var $x]
		if { [set ${x}(save)]=="change" } {
			trace variable $name w [nc Save $name]
		} elseif {[set ${x}(save)]=="exit" && [info exists $name]} {
			set saved($name) [set $name]
		}
	}
}

proc Save {name args} {
	upvar #0 $name var
	if {![info exists var]} return
	set cmd [lrange [split [string map {:: "\0"} $name] "\0"] 2 end]
	set value [string map {"\n" " "} $var]
	::Save $::RCFILE "^ *$cmd " "$cmd [list $value]"
}

