# This module is used to view Alicq log messages in Alicq.
# it is part of Alicq instant messenger client
# 
# Author: Ihar Viarheichyk

variable last_pos
variable all_tags [list]

option add *AlicqLogWindow*LogColor black widgetDefault
option add *AlicqLogWindow*Menubutton.relief sunken widgetDefault
option add *AlicqLogWindow*Menubutton.background gray90 widgetDefault
option add *AlicqLogWindow*Menubutton.anchor w widgetDefault
foreach {name color} {error red warning magenta notice green debug gray50} {
	option add *AlicqLogWindow*${name}Color $color widgetDefault
}

proc ViewLog {args} {
	set top .log
	if {[winfo exists $top]} {
		raise $top; focus $top; return
	}
	toplevel $top -class AlicqLogWindow
	wm title $top "Alicq Log"
	set vals [set [namespace parent]::log::meta::level(values)]
	set var1 [namespace current]::severity
	grid [text $top.txt -yscrollcommand [list $top.sb set]]\
		-row 0 -column 0 -sticky news
	grid [scrollbar $top.sb -orient vertical -command\
		[list $top.txt yview]] -row 0 -column 1 -sticky ns
	grid [frame $top.btn -class ButtonBar]\
		-row 1 -column 0 -columnspan 2 -sticky we -pady 2
	grid [label $top.btn.lb1 -text [mc "Display records up to level"]]\
	     [ui::variant $top.btn.level -values $vals -variable $var1]\
		-row 0 -padx 4
	grid [button $top.btn.close -command [list destroy $top]]\
		-row 0 -column 10 -sticky e -pady 2 -padx 4
	bind $top <<Close>> [list $top.btn.close invoke]
	foreach x {row column} { grid ${x}configure $top 0 -weight 1 }
	grid columnconfigure $top.btn 9 -weight 1
	foreach x $vals {
		$top.txt tag configure $x -foreground\
			[option get $top.txt ${x}Color LogColor]
	}
	trace variable $var1 w [nc Severity $top.txt]
	set $var1 [set $var1]
	$top.txt configure -state disabled
	if {$::modules::log::fd!="stderr"} {
		variable last_pos
		set last_pos 0
		Update $top
		set id [hook Log [nc Update $top] 0.99]
		bind $top.txt <Destroy> [list unhook $id]
	}
}

proc Severity {txt name1 name2 op} {
	upvar #0 $name1 severity
	set line [list error warning notice info debug]
	set pos [lsearch $line $severity]
	foreach x [lrange $line 0 $pos] { $txt tag configure $x -elide 0 }
	foreach x [lrange $line [incr pos] end] { $txt tag configure $x -elide 1}
}

proc Update {top args} {
	variable last_pos
	variable all_tags
	set cur [tell $::modules::log::fd]
	if {$last_pos>=$cur} return
	seek $::modules::log::fd $last_pos
	$top.txt configure -state normal
	while {[gets $::modules::log::fd line]!=-1} {
		set pos1 [expr [string first {[} $line]+1]
		set pos2 [expr [string first {]} $line $pos1]-1]
		set tags [string range $line $pos1 $pos2]
		lappend lines $line $tags "\n" $tags
		foreach x $tags {
			if {[lsearch -exact $all_tags $x]==-1} {
				lappend all_tags $x
			}
		}
	}
	eval $top.txt insert end $lines
	$top.txt see end
	$top.txt configure -state disabled
	set last_pos $cur
}

namespace eval meta {
	array set ViewLog {type action script ViewLog
		menu {"View Log"} weight .9}
}

