/* $Id: wmiconify.c,v 1.19 2000/03/03 18:39:08 komatsu Exp $ */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdlib.h>  /* malloc */
#include "wmclient.h"
#include "wmiconify.h"
#include "wmtitle.h"
#include "wmdrag.h"
#include "wmmain.h"
#include "wmdesign.h"
#include "wmbutton.h"
#include "wmaction.h"
#include "wmmisc.h"

gint wm_icon_clicked(GtkWidget *widget, gpointer data);
static void wm_ititle_destroy(GtkWidget *widget, GdkEventAny *event, gpointer *data);
static void wm_ititle_close(GtkWidget *widget, gpointer *data);
static void wm_ititle_move_signal(GtkWidget *widget, gint x, gint y, 
				  gpointer pointer);

/* 󲽤ε. (󲽥ܥǤϤʤ) */
void wm_iconify_iconify_signal(GtkWidget *widget, gpointer data)
{
    GtkWidget *icon;

    icon = wm_icon_button_new_default(widget);
    gtk_widget_set_uposition(GTK_WIDGET(icon),
			     WM_CLIENT_X(WM_CLIENT(widget)), 
			     WM_CLIENT_Y(WM_CLIENT(widget)));
    gtk_widget_show(icon);
    gtk_widget_hide(widget);
    WM_CLIENT_STATE(widget) = IconicState;
}

GtkWidget *wm_iconify_button_new(GtkWidget *client)
{
    GtkWidget *icon;

    wm_message("WmIconify: button_new\n");

    icon = wm_button_new_default(client);
    gtk_signal_connect(GTK_OBJECT(icon), "press1", 
		       GTK_SIGNAL_FUNC(wm_action_iconify), client);
    gtk_signal_connect(GTK_OBJECT(icon), "press2", 
		       GTK_SIGNAL_FUNC(wm_action_iconify_group), client);
    return icon;
}

GtkWidget *wm_iconify_button_new_with_xpm(GtkWidget *client, gchar *filename)
{
    GtkWidget *icon;

    icon = wm_iconify_button_new(client);
    wm_design_xpm_pack(icon, filename);

    return icon;
}



GtkWidget *wm_iconify_button_new_default(GtkWidget *client)
{
    GtkWidget *icon;
    icon = wm_iconify_button_new(client);
    wm_design_label_pack(icon, " _ ");

    return icon;
}

/* ---------------------------------------------------------------------- */

GtkWidget *wm_icon_button_new(GtkWidget *client)
{
    GtkWidget *icon;
    icon = wm_button_new_default(client);
    gtk_signal_connect(GTK_OBJECT(icon), "press1", 
		       GTK_SIGNAL_FUNC(wm_action_deiconify), client);
    gtk_signal_connect(GTK_OBJECT(icon), "press2", 
		       GTK_SIGNAL_FUNC(wm_action_deiconify_group), client);
    return icon;
}

GtkWidget *wm_icon_button_new_default(GtkWidget *client)
{
    GtkWidget
	*window,
	*hbox,
	*icon,
	*titleBtn,
	*title;
    gint *signal;
    signal = (gint *)g_malloc(sizeof(gint));

    window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_container_border_width(GTK_CONTAINER(window), 3);

    hbox   = gtk_hbox_new(FALSE, 0);

    icon = wm_icon_button_new(client);
    wm_design_label_pack(icon, " ! ");

    title = wm_title_label_new_default(client);
    titleBtn = wm_button_new_default(client);
    wm_signal_connect_safety(GTK_OBJECT(client), "destroy",
			     GTK_SIGNAL_FUNC(wm_ititle_close), window);
    gtk_signal_connect(GTK_OBJECT(titleBtn), "press1", 
		       GTK_SIGNAL_FUNC(wm_action_raise),   client);
    gtk_signal_connect(GTK_OBJECT(titleBtn), "press1", 
		       GTK_SIGNAL_FUNC(wm_ititle_press1),  client);
    gtk_signal_connect(GTK_OBJECT(titleBtn), "double1", 
		       GTK_SIGNAL_FUNC(wm_action_lower),   client);
    gtk_signal_connect(GTK_OBJECT(titleBtn), "double1", 
		       GTK_SIGNAL_FUNC(wm_ititle_double1), client);
    gtk_signal_connect(GTK_OBJECT(titleBtn), "drag1", 
		       GTK_SIGNAL_FUNC(wm_ititle_drag1), client);

    /* map_event ǤϤʤ, map, show ³ȤʤǤޤäƤޤ */
    wm_signal_connect_safety(GTK_OBJECT(client), "map_event",
			     GTK_SIGNAL_FUNC(wm_ititle_destroy), window);
    wm_signal_connect_safety(GTK_OBJECT(client), "move",
			     GTK_SIGNAL_FUNC(wm_ititle_move_signal), window);

    gtk_container_add(GTK_CONTAINER(titleBtn), title);

    gtk_box_pack_start(GTK_BOX(hbox), icon,     FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(hbox), titleBtn, TRUE,  TRUE,  0);
    gtk_container_add(GTK_CONTAINER(window), hbox);

    gtk_widget_show(icon);
    gtk_widget_show(title);
    gtk_widget_show(titleBtn);
    gtk_widget_show(hbox);

    return window;
}

/* wm_ititle_destroy 줷, ǤΤ? */
static void wm_ititle_close(GtkWidget *widget, gpointer *data)
{
    gtk_widget_destroy(GTK_WIDGET(data));
}

/* wm_ititle_close 줷, ǤΤ? */
static void wm_ititle_destroy(GtkWidget *widget,
			      GdkEventAny *event, gpointer *data)
{
    gtk_widget_destroy(GTK_WIDGET(data));
}
    
void wm_ititle_press1(GtkWidget *widget, GdkEventButton *event, gpointer data)
{
    gdk_window_raise(gdk_window_get_parent(widget->window));
/*     gdk_window_raise(gdk_window_get_parent(GTK_WIDGET(data)->window)); */
}

void wm_ititle_double1(GtkWidget *widget, GdkEventButton *event, gpointer data)
{
    gdk_window_lower(gdk_window_get_parent(widget->window));
/*     gdk_window_lower(gdk_window_get_parent(GTK_WIDGET(data)->window)); */
}

void wm_ititle_drag1(GtkWidget *widget, GdkEventMotion *event, gpointer data)
{
    gint dx, dy;

    wm_drag_get_increase((int)(event->x_root), (int)(event->y_root), &dx, &dy);
    wm_client_move(data, 
		   WM_CLIENT_X_PREV(data) + dx, WM_CLIENT_Y_PREV(data) + dy);
    gtk_widget_set_uposition(gtk_widget_get_toplevel(widget), 
			     WM_CLIENT_X_PREV(data) + dx,
			     WM_CLIENT_Y_PREV(data) + dy);
}

static void wm_ititle_move_signal(GtkWidget *widget, gint x, gint y, 
				  gpointer pointer)
{
    gdk_window_move(GTK_WIDGET(pointer)->window, x, y);
}
