// download_list.h  (this is -*-c++-*-)
//
//  Copyright 2001 Daniel Burrows
//
//  A better download manager.  (..finally..)

#ifndef DOWNLOAD_LIST_H
#define DOWNLOAD_LIST_H

#include <vector>
#include <string>

#include <apt-pkg/acquire.h>

#include <vscreen/vscreen_widget.h>
#include <vscreen/slotarg.h>

class download_manager;

class download_list:public vscreen_widget
{
  // Caches the last-seen info about a worker.
  struct workerinf
  {
    std::string msg;
    int current,total;

    workerinf(std::string _msg, int _current, int _total)
      :msg(_msg), current(_current), total(_total) {}
  };

  // Contains strings paired with attributes.
  typedef std::vector<std::pair<std::string, int> > msglist;

  // Contains strings paired with the current and total sizes associated
  // with that worker (updated in Pulse)
  typedef std::vector<workerinf> workerlist;

  msglist msgs;
  workerlist workers;

  // Where in the list we are (can be >msgs.size() -- that would mean we're
  // viewing the currently progressing downloads)
  unsigned int start;

  // Whether we should stick to the bottom of the screen (set to false
  // when the user scrolls up, set back to true when the user scrolls
  // back down)
  bool sticky_end;

  // Set to true if the user asks to cancel the download
  bool cancelled;

  Slot0Arg abortslot;

  // Will we display things other than the current workers?
  bool display_messages;

  // The starting offset to display messages with.
  std::string::size_type startx;

  // We have to mirror the download_manager's information (ewww)
  // Another option is to store a reference to the download-manager,
  // but I don't like that for other reasons. (sigh..)
  //
  // A note: these values are only updated when Pulse() is called anyway.
  unsigned long TotalItems, CurrentItems;
  double CurrentCPS, TotalBytes, CurrentBytes;

  // Updates the set of displayed progress bars.
  void update_workers(pkgAcquire *Owner);

  // Syncs the current location in the list which is displayed
  void sync_top();

  // Cancels a download
  void cancel() {cancelled=true;}

  void layout_me();
protected:
  void paint();
  bool handle_char(chtype ch);
public:
  download_list(Slot0Arg _abortslot=NULL,
		bool _display_messages=true);

  bool MediaChange(std::string media, std::string drive,
		   download_manager &manager);
  void IMSHit(pkgAcquire::ItemDesc &itmdesc, download_manager &manager);
  void Fetch(pkgAcquire::ItemDesc &itmdesc, download_manager &manager);
  void Done(pkgAcquire::ItemDesc &itmdesc, download_manager &manager);
  void Fail(pkgAcquire::ItemDesc &itmdesc, download_manager &manager);
  bool Pulse(pkgAcquire *Owner, download_manager &manager);
  void Start(download_manager &manager);
  void Stop(download_manager &manager);
  void Complete(download_manager &manager);

  size size_request();
  bool get_cursorvisible() {return false;}
  point get_cursorloc() {return point(0,0);}
  bool focus_me() {return true;}

  // FIXME: overriding this is a terrible hack.  A cancel() hook should be
  // used instead.
  void destroy();

  // Used to move around in the list (can be called manually to
  // simulate these actions)
  void pageup();
  void pagedown();
  void lineup();
  void linedown();
  void skip_to_top();
  void skip_to_bottom();
  void shift_left();
  void shift_right();
};

#endif
