/***************************************************************************
 $RCSfile: convert.cpp,v $
                             -------------------
    cvs         : $Id: convert.cpp,v 1.1 2003/05/29 15:37:47 aquamaniac Exp $
    begin       : Sun Mar 30 2003
    copyright   : (C) 2003 by Martin Preuss
    email       : martin@aquamaniac.de
*/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif



#include "convert.h"
#include "aqmconverter.h"
#include "aqmconverterdta.h"
#include "aqmconvertertrans.h"

#include <string>


HBCI::Pointer<AQMConverter> getConverter(const string &format) {
  HBCI::Pointer<AQMConverter> conv;

  if (strcasecmp(format.c_str(),"dta")==0) {
    conv=new AQMConverterDTA();
  }
  else if (strcasecmp(format.c_str(),"trans")==0) {
    conv=new AQMConverterTRANS();
  }
  else
    conv=0;
  return conv;
}



HBCI::Error convert(HBCI::Pointer<AQMAPI> hbciif,
		    HBCI::SimpleConfig &opt){
  HBCI::Error err;
  string infile;
  string informat;
  string outfile;
  string outformat;
  HBCI::Pointer<Stream> instream;
  HBCI::Pointer<Stream> outstream;
  HBCI::Pointer<AQMConverter> reader;
  HBCI::Pointer<AQMConverter> writer;

  try {
    infile=opt.getVariable("infile","-",opt.root());
    informat=opt.getVariable("informat","trans",opt.root());
    outfile=opt.getVariable("outfile","-",opt.root());
    outformat=opt.getVariable("outformat","",opt.root());

    if (outformat.empty()) {
      return HBCI::Error("convert",
			 ERROR_LEVEL_NORMAL,
			 0,
			 ERROR_ADVISE_DONTKNOW,
			 "no outformat given");
    }

    // setup converters
    reader=getConverter(informat);
    if (!reader.isValid()) {
      return HBCI::Error("convert",
			 ERROR_LEVEL_NORMAL,
			 0,
			 ERROR_ADVISE_DONTKNOW,
			 "this informat is not supported",
			 informat);
    }
    writer=getConverter(outformat);
    if (!writer.isValid()) {
      return HBCI::Error("convert",
			 ERROR_LEVEL_NORMAL,
			 0,
			 ERROR_ADVISE_DONTKNOW,
			 "this outformat is not supported",
			 outformat);
    }

    // setup streams
    if (infile=="-")
      instream=new FileStream(File::StdTypeStdIn);
    else {
      FileStream *fs;
      fs=new FileStream(infile);
      instream=fs;
      err=fs->openFile(FILE_AM_RDONLY | FILE_AM_OPEN_EXISTING);
      if (!err.isOk())
	return HBCI::Error("convert", err);
    }

    if (outfile=="-")
      outstream=new FileStream(File::StdTypeStdOut);
    else {
      FileStream *fs;
      fs=new FileStream(outfile);
      outstream=fs;
      err=fs->openFile(FILE_AM_RDWR | FILE_AM_CREATE_ALWAYS);
      if (!err.isOk())
	return HBCI::Error("convert", err);
    }

    // now read transactions
    err=reader.ref().readFromStream(instream);
    if (!err.isOk())
      return HBCI::Error("convert", err);
    writer.ref().setTransactions(reader.ref().transactions());

    // now write transactions
    err=writer.ref().writeToStream(outstream);
    if (!err.isOk())
      return HBCI::Error("convert", err);
    outstream.ref().flushBuffer();

    // close streams if needed
    if (outfile!="-") {
      err=outstream.cast<FileStream>().ref().closeFile();
      if (!err.isOk())
	return HBCI::Error("convert", err);
    }

    if (infile!="-") {
      err=instream.cast<FileStream>().ref().closeFile();
      if (!err.isOk())
	return HBCI::Error("convert", err);
    }
    err=HBCI::Error();
  }
  catch (HBCI::Error lerr) {
    err=lerr;
  }
  return err;
}





